/* MiscVirtual3DMouseFrontend.m				 
 *
 * This object deals with the GUI we need to do all the settings.
 * It is the frontend to the slider or trackPad based 3DMouse system.
 * Basically intended for testing a custom app without owning a real 3Dmouse.
 *
 * For interface-info see the header file. The comments in this file mostly
 * cover only the real implementation details.
 *
 * Written by: 		Thomas Engel
 * Created:    		09.04.1994 (Copyleft)
 * Last modified: 	14.04.1994
 */

#import "MiscVirtual3DMouseFrontend.h"
#import "Misc3DMouseDriver.h"
#import "BBSlider.h"

@implementation MiscVirtual3DMouseFrontend

- revert:sender
{
	[super revert:sender];
	
	if( !mouseDriver ) mouseDriver = [Misc3DMouseDriver new];
	if( !view )
	{
		// Before we will do anything else..lets change the slider class.
		// we need that for our transForStart/End stuff.
	
		[BBSlider poseAs:[Slider class]];
	
		if( [NXApp loadNibSection:"MiscVirtual3DMouse.nib" owner:self] == nil )
			NXRunAlertPanel( NULL, "Couldn't load MiscVirtual3DMouse.nib",
							 "OK", NULL, NULL);
	}
	[[NXApp delegate] setMouse:mouseDriver];		// BUGGY ! NASTY !
	
	// Let's init all the default data.
	
	return self;
}

- xRotation:sender
{
	float 	angle;
	
	angle = [sender floatValue] - lastSliderValue;
	[rotValue setIntValue:[sender intValue]];
	if( angle == 0.0 ) return self;
	
	if( [mouseDriver deliverTranslation:0 :0 :0 andRotation:angle :0 :0] )
		lastSliderValue = [sender floatValue];

	return self;
}

- yRotation:sender
{
	float 	angle;
	
	angle = [sender floatValue] - lastSliderValue;
	[rotValue setIntValue:[sender intValue]];
	if( angle == 0.0 ) return self;
	
	if( [mouseDriver deliverTranslation:0 :0 :0 andRotation:0 :angle :0] )
		lastSliderValue = [sender floatValue];

	return self;
}

- zRotation:sender
{
	float 	angle;
	
	angle = [sender floatValue] - lastSliderValue;
	[rotValue setIntValue:[sender intValue]];
	if( angle == 0.0 ) return self;
	
	if( [mouseDriver deliverTranslation:0 :0 :0 andRotation:0 :0 :angle] )
		lastSliderValue = [sender floatValue];

	return self;
}

- xTranslation:sender
{
	float 	delta;
	
	delta = [sender floatValue] - lastSliderValue;
	[transValue setIntValue:[sender intValue]];
	if( delta == 0.0 ) return self;
	
	if( [mouseDriver deliverTranslation:delta :0: 0 andRotation:0 :0 :0] )
		lastSliderValue = [sender floatValue];

	return self;
}

- yTranslation:sender
{
	float 	delta;
	
	delta = [sender floatValue] - lastSliderValue;
	[transValue setIntValue:[sender intValue]];
	if( delta == 0.0 ) return self;
	
	if( [mouseDriver deliverTranslation:0 :delta :0 andRotation:0 :0 :0] )
		lastSliderValue = [sender floatValue];

	return self;
}

- zTranslation:sender
{
	float 	delta;
	
	delta = [sender floatValue] - lastSliderValue;
	[transValue setIntValue:[sender intValue]];
	if( delta == 0.0 ) return self;
	
	if( [mouseDriver deliverTranslation:0 :0 :delta andRotation:0 :0 :0] )
		lastSliderValue = [sender floatValue];

	return self;
}

- switchLocking:sender
{
	if( [modeLock state] == YES )
			[self transformationWillStart:self];
	else	[self transformationDidEnd:self];
	
	return self;
}

- takeRotationRangeFrom:sender
{
	int	newRange;
	
	newRange = [sender intValue];
	
	if( newRange < 0 ) newRange *= -1;
	if( newRange < 1 ) newRange = 1;
	if( newRange > 180 ) newRange = 180;
	
	[aSlider setMinValue:-newRange];
	[aSlider setMaxValue:newRange];
	[bSlider setMinValue:-newRange];
	[bSlider setMaxValue:newRange];
	[cSlider setMinValue:-newRange];
	[cSlider setMaxValue:newRange];
	[sender setIntValue:newRange];
	[negRotRange setIntValue:-newRange];
	
	return self;
}

- takeTranslationRangeFrom:sender
{
	int	newRange;
	
	newRange = [sender intValue];
	
	if( newRange < 0 ) newRange *= -1;
	if( newRange < 1 ) newRange = 1;
	if( newRange > 5000 ) newRange = 5000;
	
	[xSlider setMinValue:-newRange];
	[xSlider setMaxValue:newRange];
	[ySlider setMinValue:-newRange];
	[ySlider setMaxValue:newRange];
	[zSlider setMinValue:-newRange];
	[zSlider setMaxValue:newRange];
	[sender setIntValue:newRange];
	[negTransRange setIntValue:-newRange];
	
	return self;
}

- (oneway void)transformationWillStart:sender
{
	[[mouseDriver target] transformationWillStart:mouseDriver];
	return;
}

- (oneway void)transformationDidEnd:sender
{
	// If the sender is one of our sliders we will reset it to the
	// Zero point.
	
	if( sender == aSlider ||
		sender == bSlider ||
		sender == cSlider )
	{
		[sender setFloatValue:0];
		[rotValue setIntValue:0];
		lastSliderValue = 0;
	}
	else if( sender == xSlider ||
			 sender == ySlider ||
			 sender == zSlider )
	{
		[sender setFloatValue:0];
		[transValue setIntValue:0];
		lastSliderValue = 0;
	}
	if( [modeLock state] == NO )
		[[mouseDriver target] transformationDidEnd:mouseDriver];
	return;
}

@end

/*
 * History: 14.04.94 Really got it going.
 *
 *			09.04.94 First codeing done.
 *
 *
 * Bugs: - Not very likely.
 */