
/*
 * (c) 1988 by George Kyriazis
 */

/*
 *	vector operations 
 */

#include	"ray.h"
#include	<math.h>

struct	vector	vadd(a,b)
struct	vector	a,b;
{
	struct	vector	c;

	c.x=a.x+b.x;
	c.y=a.y+b.y;
	c.z=a.z+b.z;

	return c;
}

struct	vector	vsub(a,b)
struct	vector	a,b;
{
	struct	vector	c;

	c.x=a.x-b.x;
	c.y=a.y-b.y;
	c.z=a.z-b.z;

	return c;
}

struct	vector	vneg(a)
struct	vector	a;
{
	struct	vector	b;

	b.x= -a.x;
	b.y= -a.y;
	b.z= -a.z;

	return b;
}

struct	vector	svproduct(k,a)
double	k;
struct	vector	a;
{
	a.x*=k;
	a.y*=k;
	a.z*=k;

	return a;
}
 
double	vdot(a,b)
struct	vector	a,b;
{
	return (a.x*b.x+a.y*b.y+a.z*b.z);
}

struct	vector	vcross(a,b)
struct	vector	a,b;
{
	struct	vector	c;

	c.x=a.y*b.z-b.y*a.z;
	c.y=b.x*a.z-a.x*b.z;
	c.z=a.x*b.y-b.x*a.y;

	return c;
}

struct	vector	norm(a)
struct	vector	a;
{
	double len;
	struct	vector	b;

	len=sqrt(a.x*a.x+a.y*a.y+a.z*a.z);
	b.x=a.x/len;
	b.y=a.y/len;
	b.z=a.z/len;

	return	b;
}
