/* Give up the ghost
   Copyright (C) 1991, 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include <libhurd.h>
#include <mach/error.h>

volatile void
panic (char *s)
{
  volatile int a, b;
  printf ("panic: %s\n", s);
  
  a = b / 0;
  for (;;);
}

volatile void
panic_with_error (char *s, error_t error_code)
{
  volatile int a, b;
  
  printf ("panic: %s: %s (0x%x = %d/%d/%d)\n", s, mach_error_string (error_code),
	  (int) error_code, err_get_system (error_code), 
	  err_get_sub (error_code), 
	  err_get_code (error_code));
  a = b / 0;
  for (;;);
}
