#ifndef	_fs
#define	_fs

/* Module fs */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#ifdef	mig_external
mig_external
#else
extern
#endif
void init_fs
#if	(defined(__STDC__) || defined(c_plusplus))
    (mach_port_t rep_port);
#else
    ();
#endif
#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>

/* Routine file_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_exec
#if	defined(LINTLIBRARY)
    (exec_file, exec_task, argv, argvCnt, envp, envpCnt, fds_active, fds, fdsCnt, cwdir, crdir, honor_setuid)
	file_t exec_file;
	task_t exec_task;
	args_t argv;
	mach_msg_type_number_t argvCnt;
	args_t envp;
	mach_msg_type_number_t envpCnt;
	fd_mask_t fds_active;
	fd_array_t fds;
	mach_msg_type_number_t fdsCnt;
	mach_port_t cwdir;
	mach_port_t crdir;
	int honor_setuid;
{ return file_exec(exec_file, exec_task, argv, argvCnt, envp, envpCnt, fds_active, fds, fdsCnt, cwdir, crdir, honor_setuid); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t exec_file,
	task_t exec_task,
	args_t argv,
	mach_msg_type_number_t argvCnt,
	args_t envp,
	mach_msg_type_number_t envpCnt,
	fd_mask_t fds_active,
	fd_array_t fds,
	mach_msg_type_number_t fdsCnt,
	mach_port_t cwdir,
	mach_port_t crdir,
	int honor_setuid
);
#else
    ();
#endif
#endif

/* Routine file_chown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_chown
#if	defined(LINTLIBRARY)
    (chown_file, new_owner, new_group)
	file_t chown_file;
	uid_t new_owner;
	gid_t new_group;
{ return file_chown(chown_file, new_owner, new_group); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chown_file,
	uid_t new_owner,
	gid_t new_group
);
#else
    ();
#endif
#endif

/* Routine file_chauthor */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_chauthor
#if	defined(LINTLIBRARY)
    (chauth_file, new_author)
	file_t chauth_file;
	uid_t new_author;
{ return file_chauthor(chauth_file, new_author); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chauth_file,
	uid_t new_author
);
#else
    ();
#endif
#endif

/* Routine file_chmod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_chmod
#if	defined(LINTLIBRARY)
    (chmod_file, new_mode)
	file_t chmod_file;
	mode_t new_mode;
{ return file_chmod(chmod_file, new_mode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chmod_file,
	mode_t new_mode
);
#else
    ();
#endif
#endif

/* Routine file_utimes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_utimes
#if	defined(LINTLIBRARY)
    (utimes_file, new_atime, new_mtime)
	file_t utimes_file;
	time_value_t new_atime;
	time_value_t new_mtime;
{ return file_utimes(utimes_file, new_atime, new_mtime); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t utimes_file,
	time_value_t new_atime,
	time_value_t new_mtime
);
#else
    ();
#endif
#endif

/* Routine file_seek */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_seek
#if	defined(LINTLIBRARY)
    (seek_file, offset, whence, newp)
	file_t seek_file;
	int offset;
	int whence;
	int *newp;
{ return file_seek(seek_file, offset, whence, newp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t seek_file,
	int offset,
	int whence,
	int *newp
);
#else
    ();
#endif
#endif

/* Routine file_truncate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_truncate
#if	defined(LINTLIBRARY)
    (trunc_file, new_size)
	file_t trunc_file;
	int new_size;
{ return file_truncate(trunc_file, new_size); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t trunc_file,
	int new_size
);
#else
    ();
#endif
#endif

/* Routine file_lock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_lock
#if	defined(LINTLIBRARY)
    (lock_file, flags)
	file_t lock_file;
	int flags;
{ return file_lock(lock_file, flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t lock_file,
	int flags
);
#else
    ();
#endif
#endif

/* Routine file_getdev */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_getdev
#if	defined(LINTLIBRARY)
    (dev_file, device)
	file_t dev_file;
	device_t *device;
{ return file_getdev(dev_file, device); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t dev_file,
	device_t *device
);
#else
    ();
#endif
#endif

/* Routine file_getcontrol */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_getcontrol
#if	defined(LINTLIBRARY)
    (file, control)
	file_t file;
	mach_port_t *control;
{ return file_getcontrol(file, control); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	mach_port_t *control
);
#else
    ();
#endif
#endif

/* Routine file_statfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_statfs
#if	defined(LINTLIBRARY)
    (file, info)
	file_t file;
	fsys_statfsbuf_t *info;
{ return file_statfs(file, info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	fsys_statfsbuf_t *info
);
#else
    ();
#endif
#endif

/* Routine file_sync */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_sync
#if	defined(LINTLIBRARY)
    (file, wait)
	file_t file;
	int wait;
{ return file_sync(file, wait); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait
);
#else
    ();
#endif
#endif

/* Routine file_syncfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_syncfs
#if	defined(LINTLIBRARY)
    (file, wait, do_children)
	file_t file;
	int wait;
	int do_children;
{ return file_syncfs(file, wait, do_children); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait,
	int do_children
);
#else
    ();
#endif
#endif

/* Routine file_pathconf */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_pathconf
#if	defined(LINTLIBRARY)
    (file, pathconf)
	file_t file;
	pathconf_t *pathconf;
{ return file_pathconf(file, pathconf); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	pathconf_t *pathconf
);
#else
    ();
#endif
#endif

/* Routine dir_pathtrans */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_pathtrans
#if	defined(LINTLIBRARY)
    (start_dir, pathname, pathnameCnt, flags, mode, do_retry, retry_name, retry_nameCnt, result)
	file_t start_dir;
	filename_t pathname;
	mach_msg_type_number_t pathnameCnt;
	int flags;
	mode_t mode;
	retry_type *do_retry;
	filename_t retry_name;
	mach_msg_type_number_t *retry_nameCnt;
	file_t *result;
{ return dir_pathtrans(start_dir, pathname, pathnameCnt, flags, mode, do_retry, retry_name, retry_nameCnt, result); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t start_dir,
	filename_t pathname,
	mach_msg_type_number_t pathnameCnt,
	int flags,
	mode_t mode,
	retry_type *do_retry,
	filename_t retry_name,
	mach_msg_type_number_t *retry_nameCnt,
	file_t *result
);
#else
    ();
#endif
#endif

/* Routine dir_setsys */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_setsys
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
{ return dir_setsys(directory, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt
);
#else
    ();
#endif
#endif

/* Routine dir_lstat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_lstat
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, stat_info)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	io_statbuf_t *stat_info;
{ return dir_lstat(directory, name, nameCnt, stat_info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	io_statbuf_t *stat_info
);
#else
    ();
#endif
#endif

/* Routine dir_mkdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_mkdir
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, mode)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	int mode;
{ return dir_mkdir(directory, name, nameCnt, mode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	int mode
);
#else
    ();
#endif
#endif

/* Routine dir_rmdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_rmdir
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
{ return dir_rmdir(directory, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt
);
#else
    ();
#endif
#endif

/* Routine dir_mknod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_mknod
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, mode, device)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	mode_t mode;
	dev_t device;
{ return dir_mknod(directory, name, nameCnt, mode, device); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	mode_t mode,
	dev_t device
);
#else
    ();
#endif
#endif

/* Routine dir_unlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_unlink
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
{ return dir_unlink(directory, name, nameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt
);
#else
    ();
#endif
#endif

/* Routine dir_link */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_link
#if	defined(LINTLIBRARY)
    (oldfile, newdirectory, newname, newnameCnt)
	file_t oldfile;
	file_t newdirectory;
	filecomp_t newname;
	mach_msg_type_number_t newnameCnt;
{ return dir_link(oldfile, newdirectory, newname, newnameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t oldfile,
	file_t newdirectory,
	filecomp_t newname,
	mach_msg_type_number_t newnameCnt
);
#else
    ();
#endif
#endif

/* Routine dir_symlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_symlink
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, linktarget, linktargetCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	filename_t linktarget;
	mach_msg_type_number_t linktargetCnt;
{ return dir_symlink(directory, name, nameCnt, linktarget, linktargetCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	filename_t linktarget,
	mach_msg_type_number_t linktargetCnt
);
#else
    ();
#endif
#endif

/* Routine dir_readlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_readlink
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, contents, contentsCnt)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	filename_t contents;
	mach_msg_type_number_t *contentsCnt;
{ return dir_readlink(directory, name, nameCnt, contents, contentsCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	filename_t contents,
	mach_msg_type_number_t *contentsCnt
);
#else
    ();
#endif
#endif

/* Routine dir_rename */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_rename
#if	defined(LINTLIBRARY)
    (olddirectory, oldname, oldnameCnt, newdirectory, newname, newnameCnt)
	file_t olddirectory;
	filecomp_t oldname;
	mach_msg_type_number_t oldnameCnt;
	file_t newdirectory;
	filecomp_t newname;
	mach_msg_type_number_t newnameCnt;
{ return dir_rename(olddirectory, oldname, oldnameCnt, newdirectory, newname, newnameCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t olddirectory,
	filecomp_t oldname,
	mach_msg_type_number_t oldnameCnt,
	file_t newdirectory,
	filecomp_t newname,
	mach_msg_type_number_t newnameCnt
);
#else
    ();
#endif
#endif

/* Routine dir_set_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_set_translator
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, permanent, oldtrans_flags, trans_name, trans_nameCnt, existing)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	boolean_t permanent;
	int oldtrans_flags;
	filename_t trans_name;
	mach_msg_type_number_t trans_nameCnt;
	fsys_t existing;
{ return dir_set_translator(directory, name, nameCnt, permanent, oldtrans_flags, trans_name, trans_nameCnt, existing); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	boolean_t permanent,
	int oldtrans_flags,
	filename_t trans_name,
	mach_msg_type_number_t trans_nameCnt,
	fsys_t existing
);
#else
    ();
#endif
#endif

/* Routine dir_use_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_use_translator
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, useit)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	int useit;
{ return dir_use_translator(directory, name, nameCnt, useit); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	int useit
);
#else
    ();
#endif
#endif

/* Routine dir_get_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_get_translator
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, trans_control)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	mach_port_t *trans_control;
{ return dir_get_translator(directory, name, nameCnt, trans_control); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	mach_port_t *trans_control
);
#else
    ();
#endif
#endif

/* Routine dir_statfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_statfs
#if	defined(LINTLIBRARY)
    (directory, name, nameCnt, info)
	file_t directory;
	filecomp_t name;
	mach_msg_type_number_t nameCnt;
	fsys_statfsbuf_t *info;
{ return dir_statfs(directory, name, nameCnt, info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	filecomp_t name,
	mach_msg_type_number_t nameCnt,
	fsys_statfsbuf_t *info
);
#else
    ();
#endif
#endif

#endif	_fs
