/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.config;

import com.izforge.izpack.util.xmlmerge.ConfigurationException;
import com.izforge.izpack.util.xmlmerge.config.AbstractXPathConfigurer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyXPathConfigurer
extends AbstractXPathConfigurer {
    public static final String DEFAULT_ACTION_KEY = "action.default";
    public static final String DEFAULT_MAPPER_KEY = "mapper.default";
    public static final String DEFAULT_MATCHER_KEY = "matcher.default";
    public static final String PATH_PREFIX = "xpath.";
    public static final String MAPPER_PREFIX = "mapper.";
    public static final String MATCHER_PREFIX = "matcher.";
    public static final String ACTION_PREFIX = "action.";
    Properties m_props;
    Set<String> m_paths = new LinkedHashSet<String>();

    public PropertyXPathConfigurer(String propString) throws ConfigurationException {
        this.m_props = new Properties();
        try {
            this.m_props.load(new ByteArrayInputStream(propString.getBytes()));
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe);
        }
    }

    public PropertyXPathConfigurer(Map<String, String> map) {
        this.m_props = new Properties();
        this.m_props.putAll(map);
    }

    public PropertyXPathConfigurer(Properties properties) {
        this.m_props = properties;
    }

    @Override
    protected void readConfiguration() throws ConfigurationException {
        String token = this.m_props.getProperty(DEFAULT_ACTION_KEY);
        if (token != null) {
            this.setDefaultAction(token);
        }
        if ((token = this.m_props.getProperty(DEFAULT_MAPPER_KEY)) != null) {
            this.setDefaultMapper(token);
        }
        if ((token = this.m_props.getProperty(DEFAULT_MATCHER_KEY)) != null) {
            this.setDefaultMatcher(token);
        }
        Enumeration<Object> keys = this.m_props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(PATH_PREFIX)) continue;
            this.m_paths.add(key.substring(PATH_PREFIX.length()));
        }
        for (String path : this.m_paths) {
            token = this.m_props.getProperty(ACTION_PREFIX + path);
            if (token != null) {
                this.addAction(this.m_props.getProperty(PATH_PREFIX + path), token);
            }
            if ((token = this.m_props.getProperty(MAPPER_PREFIX + path)) != null) {
                this.addMapper(this.m_props.getProperty(PATH_PREFIX + path), token);
            }
            if ((token = this.m_props.getProperty(MATCHER_PREFIX + path)) == null) continue;
            this.addMatcher(this.m_props.getProperty(PATH_PREFIX + path), token);
        }
    }
}

