/* LocaleInformation_zh.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_zh extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|GNF|PGK|OMS|OMR|UYP|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|GMP|KMF|SLL|GMD|XEU|BSP|CMF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|PDN|PDK|NPR|CKD|JPY|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "\u7ea6\u65e6\u7b2c\u7eb3\u5c14\u5143|\u9ec4\u91d1|\u6cd5\u7f57\u7fa4\u5c9b\u514b\u6717|\u9ece\u5df4\u5ae9\u78c5|\u6b27\u5143|\u8d8a\u5357\u76fe|\u5766\u6851\u5c3c\u4e9a\u5148\u4ee4|\u73bb\u5229\u7ef4\u4e9a\u6bd4\u7d22|\u67ec\u57d4\u5be8\u91cc\u5c14|\u4e9a\u6d32\u8d27\u5e01\u5355\u4f4d|\u73bb\u5229\u7ef4\u4e9a (1863-1962)|\u67ec\u57d4\u5be8\u65e7\u91cc\u5c14|\u8d5e\u6bd4\u4e9a\u78c5|\u6fb3\u5927\u5229\u4e9a\u78c5|\u9a6c\u5c14\u4ed6\u78c5|\u52a0\u7eb3\u91cd\u8bc4\u4f30\u585e\u7b2c|\u8d5e\u6bd4\u4e9a\u9a6c\u62c9\u7ef4|\u4e9a\u6d32\u7b2c\u7eb3\u5c14\u5143\u5e10\u6237\u5355\u4f4d|\u52a0\u7eb3\u78c5|\u73bb\u5229\u7ef4\u4e9a|\u52a0\u7eb3\u65e7\u585e\u7b2c|\u9a6c\u5c14\u4ed6\u91cc\u62c9|\u6fb3\u5927\u5229\u4e9a\u5143|\u7f8e\u5143 (\u540c\u4e00\u5929)|\u610f\u5927\u5229\u91cc\u62c9|\u7f8e\u5143 (\u4e0b\u4e00\u5929)|\u52a0\u7eb3\u585e\u7b2c|\u65b0\u52a0\u5761\u5143|\u5df4\u62ff\u9a6c\u5df4\u6ce2\u4e9a|\u8001\u631d\u57fa\u666e|\u5409\u5c14\u5409\u65af\u5766\u8428\u59c6|\u745e\u58eb\u6cd5\u90ce|\u5965\u5730\u5229\u897f\u4ee4|\u7f8e\u5143|\u57c3\u585e\u4fc4\u6bd4\u4e9a\u5143|\u6c76\u83b1\u5143|\u7259\u4e70\u52a0\u78c5|\u57c3\u585e\u4fc4\u6bd4\u4e9a\u6bd4\u5c14|\u963f\u5c14\u53ca\u5229\u4e9a\u6cd5\u90ce\u6bd4\u65af\u67e5|\u963f\u5c14\u53ca\u5229\u4e9a\u65b0\u6cd5\u90ce|\u963f\u5c14\u53ca\u5229\u4e9a\u7b2c\u7eb3\u5c14\u5143|\u5df4\u62c9\u572d\u5e01|\u5229\u6bd4\u4e9a\u78c5|\u7259\u4e70\u52a0\u5143|\u51b0\u5c9b\u514b\u6717|\u897f\u73ed\u7259\u9a6c\u8d5b\u5854|\u767e\u6155\u5927\u78c5|\u5229\u6bd4\u4e9a\u7b2c\u7eb3\u5c14\u5143|\u5229\u6bd4\u4e9a\u82f1\u56fd\u519b\u961f\u519b\u65b9\u91cc\u62c9|\u767e\u6155\u5927\u5143|\u8377\u5170\u76fe|\u91cc\u5854\u5c3c\u4e9a\u4e4c\u5409\u4e9a|\u4f0a\u6717\u91cc\u4e9a \u5c14|\u745e\u58eb\u514b\u6717|\u5384\u7acb\u7279\u91cc\u4e9a\u7eb3\u798f\u5361|\u80af\u5c3c\u4e9a\u5148\u4ee4|\u4e2d\u975e\u5171\u548c\u56fd CFA \u6cd5\u90ce|\u963f\u6839\u5ef7\u6bd4\u7d22|\u963f\u6839\u5ef7\u6bd4\u7d22 (1983-1985)|\u963f\u6839\u5ef7\u6bd4\u7d22\u6807\u51c6\u5c40|\u65b0\u53f0\u5e01|\u82cf\u4e39\u78c5|\u4e54\u6cbb\u4e9a\u5e93\u84ec\u62c9\u745e|\u4e54\u6cbb\u4e9a\u5e93\u84ec\u62c9\u745e\u7279|\u9a6c\u8482\u5c3c\u6cd5\u90ce|\u798f\u514b\u5170\u7fa4\u5c9b\u78c5|\u963f\u6839\u5ef7\u5965\u65af\u7279|\u82cf\u4e39\u7b2c\u7eb3\u5c14\u5143|\u4f0a\u62c9\u514b\u7b2c\u7eb3\u5c14\u5143|\u56fe\u74e6\u5362\u5143|\u585e\u820c\u5c14\u5362\u6bd4|\u62c9\u8131\u7ef4\u4e9a\u5362\u5e03|\u6590\u6d4e\u78c5|\u62c9\u8131\u7ef4\u4e9a\u62c9\u7279|\u521a\u679c\u624e\u4f0a\u5c14|\u521a\u679c\u5171\u548c\u56fd\u6cd5\u90ce|\u521a\u679c\u6cd5\u90ce|\u6590\u6d4e\u5143|\u5c3c\u52a0\u62c9\u74dc\u91d1\u54e5\u591a\u534e|\u6fb3\u95e8\u5143|\u5c3c\u52a0\u62c9\u74dc\u91d1\u79d1\u591a\u5df4|\u5c3c\u52a0\u62c9\u74dc\u79d1\u591a\u5df4|\u82ac\u5170\u739b\u5361 (1860-1962)|\u82ac\u5170\u739b\u5361|\u6240\u7f57\u95e8\u7fa4\u5c9b\u5143|\u5362\u68ee\u5821\u6cd5\u90ce|\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5\u65e7\u5143|\u5b89\u54e5\u62c9\u57c3\u65af\u5e93\u591a|\u5b89\u6208\u62c9\u5bbd\u624e Reajustado (1995-1999)|\u8499\u53e4\u56fe\u683c\u91cc\u514b|\u5308\u7259\u5229\u7f36\u745e\u7279|\u5e03\u9686\u8fea\u6cd5\u90ce|\u5b89\u6208\u62c9\u65b0\u5bbd\u624e (1990-2000)|\u5b89\u6208\u62c9\u5bbd\u624e (1977-1990)|\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5\u5143|\u65af\u5a01\u58eb\u5170\u5e01|\u65b0\u8d6b\u5e03\u91cc\u5e95 CFP \u6cd5\u90ce|\u82f1\u78c5|\u6c99\u7279\u7279\u6743\u91cc\u4e9a\u5c14|\u6c99\u7279\u91cc\u4e9a\u5c14|\u7acb\u9676\u5b9b\u5854\u54af\u5450\u53f8|\u5370\u5ea6\u5362\u6bd4|\u8461\u8404\u7259\u94c3\u6728|\u5b89\u6208\u62c9\u5bbd\u624e|\u8461\u8404\u7259\u5025\u6d82|\u7acb\u9676\u5b9b\u5229\u5854|\u54c8\u8428\u514b\u817e\u989d|\u54c8\u8428\u514b\u5362\u5e03|\u82f1\u56fd\u7ef4\u4eac\u7fa4\u5c9b\u5e01|\u5c3c\u65e5\u5229\u4e9a\u78c5|\u7f05\u7538\u5143\u5916\u6c47\u5238|\u5c3c\u65e5\u5229\u4e9a\u5948\u62c9.|\u6d77\u5730\u53e4\u5fb7|\u53d9\u5229\u4e9a\u78c5|\u5df4\u52d2\u65af\u5766\u78c5|\u5df4\u6797\u7b2c\u7eb3\u5c14\u5143|\u7f05\u7538\u5f00\u4e9a\u7279|\u8377\u5170\u5b89\u66ff\u5170\u76fe|\u6377\u514b\u514b\u90ce|\u66fc\u5c9b\u78c5|\u4fdd\u52a0\u5229\u4e9a\u5217\u514b\u5916\u6c47\u5238|\u83b1\u7d22\u6258|\u4fdd\u52a0\u5229\u4e9a\u5217\u514b (1879-1952)|\u4fdd\u52a0\u5229\u4e9a\u65b0\u5217\u514b|\u4fdd\u52a0\u5229\u4e9a\u793e\u4f1a\u4e3b\u4e49\u5217\u514b|\u52a0\u62ff\u5927\u5143|\u4fdd\u52a0\u5229\u4e9a\u786c\u5217\u514b|\u571f\u8033\u5176\u91cc\u62c9|\u5f00\u66fc\u5c9b\u5143|\u585e\u6d66\u8def\u65af\u78c5|\u4ee5\u8272\u5217\u65b0\u8c22\u5ba2\u5c14|\u572d\u4e9a\u90a3\u5143|\u4e9a\u7f8e\u5c3c\u4e9a\u5fb7\u62c9\u59c6|\u4ee5\u8272\u5217\u78c5|\u9a6c\u91cc\u6cd5\u90ce|\u4ee5\u8272\u5217\u8c22\u5ba2\u5c14|\u5185\u745e\u62c9\u535a\u5229\u74e6|\u963f\u5c14\u5df4\u5c3c\u4e9a\u5143\u5916\u6c47\u5238|\u5229\u6bd4\u4e9a\u5143|\u963f\u5c14\u5df4\u5c3c\u4e9a\u5217\u514b\u5e01|\u514b\u7f57\u5730\u4e9a\u5e93\u5a1c\u5143|\u7559\u5c3c\u6c6a\u8054\u5408\u4f1a\u6cd5\u90ce|\u514b\u7f57\u5730\u4e9a\u7b2c\u7eb3\u5c14\u5143|\u963f\u5c14\u5df4\u5c3c\u4e9a\u5217\u514b|\u6cfd\u897f\u78c5|\u963f\u5c14\u5df4\u5c3c\u4e9a\u5217\u514b (1946-1961)|\u9a6c\u5176\u987f\u6234\u7eb3 (1992-1993)|\u5317\u8d8a\u76ae\u827e\u65af\u7279\u660e\u76fe|\u5317\u8d8a\u76ae\u827e\u65af\u7279\u65b0\u76fe|\u9a6c\u5176\u987f\u6234\u7eb3|\u5317\u8d8a\u76ae\u827e\u65af\u7279\u76fe|\u5e1d\u6c76\u5e15\u5854\u5361|\u6bd4\u5229\u65f6\u6cd5\u90ce\uff08\u91d1\u878d\uff09|\u51e0\u5185\u4e9a\u6bd4\u7d22|\u79d1\u5a01\u7279\u7b2c\u7eb3\u5c14\u5143|\u8461\u8404\u7259\u51e0\u5185\u4e9a\u8ff7\u6d31\u745e|\u6bd4\u5229\u65f6\u6cd5\u90ce|\u5e1d\u6c76\u57c3\u65af\u5e93\u591a|\u6bd4\u5229\u65f6\u6cd5\u90ce\u5151\u6362\u5238|\u8461\u8404\u7259\u51e0\u5185\u4e9a\u57c3\u65af\u5e93\u591a|\u8428\u5c14\u74e6\u591a\u79d1\u6d1b\u6d85|\u5e93\u62c9\u76fe|\u5b5f\u52a0\u62c9\u8fbe\u5361|\u6c64\u52a0\u78c5|\u6c64\u52a0\u5e01|\u82cf\u8054\u5362\u5e03|\u82cf\u8054\u65b0\u5362\u5e03|\u65b0\u5361\u91cc\u591a\u5c3c\u4e9a\u65b0\u6cd5\u90ce|\u4f5b\u5f97\u89d2\u57c3\u65af\u5e93\u591a|\u6cd5\u56fd\u5b89\u7684\u5217\u65af CFA \u6cd5\u90ce|\u5357\u975e\u5170\u7279|\u591a\u7c73\u5c3c\u52a0\u6bd4\u7d22|\u53e4\u5df4\u5916\u6c47\u5238|\u5357\u975e\u78c5|\u5357\u975e\u5170\u7279 (\u91d1\u878d)|\u7a81\u5c3c\u65af\u7b2c\u7eb3\u5c14\u5143|\u53e4\u5df4\u6bd4\u7d22|\u6cd5\u56fd\u5c5e\u572d\u4e9a\u90a3\u6cd5\u90ce|\u4e4c\u5e72\u8fbe\u5148\u4ee4|\u9521\u5170\u5362\u6bd4|\u963f\u53d1\u548c\u4f0a\u8428\u6cd5\u90ce|\u68b5\u8c1b\u5188\u91cc\u62c9|\u5723\u591a\u7f8e\u666e\u6797\u897f\u6bd4\u94c3\u6728|\u4e4c\u5e72\u8fbe\u5148\u4ee4 (1966-1987)|\u5723\u591a\u7f8e\u666e\u6797\u897f\u6bd4\u90fd\u6bd4\u62c9|\u9a6c\u7ecd\u5c14\u7fa4\u5c9b\u5143|\u65b0\u897f\u5170\u78c5|\u897f\u8428\u6469\u4e9a\u5854\u62c9|\u897f\u8428\u6469\u4e9a\u78c5|\u6d2a\u90fd\u62c9\u65af\u52d2\u76ae\u62c9|\u6cd5\u56fd\u57ce\u5e02\u504c\u4f5b\u6cd5\u90ce|\u571f\u5e93\u66fc\u65af\u5766\u5e01|\u5371\u5730\u9a6c\u62c9|\u65b0\u897f\u5170\u5143|\u82cf\u683c\u5170\u78c5|\u5df4\u5df4\u591a\u65af\u5143|\u7eb3\u7c73\u6bd4\u4e9a\u5143|\u9a6c\u8fbe\u52a0\u65af\u52a0\u6cd5\u90ce|\u9a6c\u8fbe\u52a0\u65af\u52a0\u963f\u65e5\u745e|\u57c3\u53ca\u78c5|\u5c5e\u6d2a\u90fd\u62c9\u65af\u5143|\u6ce2\u5170\u5179\u7f57\u63d0 (1950-1995)|\u6ce2\u58eb\u5c3c\u4e9a-\u8d6b\u585e\u54e5\u7ef4\u7eb3\u65b0\u7b2c\u7eb3\u5c14\u5143|\u6ce2\u5170\u7f8e\u5143 \u5916\u6c47\u5238|\u6ce2\u58eb\u5c3c\u4e9a-\u8d6b\u585e\u54e5\u7ef4\u7eb3\u5151\u6362\u5238|\u4f2f\u5229\u5179\u5143|\u6ce2\u58eb\u5c3c\u4e9a-\u8d6b\u585e\u54e5\u7ef4\u7eb3\u7b2c\u7eb3\u5c14\u5143|\u6ce2\u5170\u5179\u7f57\u63d0|\u4e5f\u95e8\u91cc\u5c14|\u82cf\u91cc\u5357\u57fa\u5c14|\u6377\u514b\u786c\u514b\u90ce|\u97e9\u56fd\u5e01|\u767d\u4fc4\u7f57\u65af\u5362\u5e03|\u4e5f\u95e8\u963f\u9a6c\u8fea\u91cc\u5c14|\u767d\u4fc4\u7f57\u65af\u5362\u5e03 (1992-1994)|\u6377\u514b\u514b\u90ce|\u97e9\u56fd\u65e7\u5e01|\u97e9\u56fd\u5143|\u767d\u4fc4\u7f57\u65af\u65b0\u5362\u5e03 (1994-1999)|\u7d22\u9a6c\u91cc\u5927\u9646\u5148\u4ee4|\u5e0c\u814a\u65b0\u5fb7\u62c9\u514b\u9a6c|\u5df4\u57fa\u65af\u5766\u5362\u6bd4|\u963f\u5bcc\u6c57\u5c3c|\u6d25\u5df4\u5e03\u97e6\u5143|\u65af\u91cc\u5170\u5361\u5362\u6bd4|\u5e0c\u814a\u5fb7\u62c9\u514b\u9a6c|\u7231\u5c14\u5170\u78c5|\u963f\u5bcc\u6c57\u5c3c (1927-2002)|\u4e5f\u95e8\u7b2c\u7eb3\u5c14\u5143|\u5362\u65fa\u8fbe\u6cd5\u90ce|\u54e5\u65af\u8fbe\u9ece\u52a0\u79d1\u9686|\u5854\u5409\u514b\u65af\u5766\u7d22\u83ab\u5c3c|\u5854\u5409\u514b\u65af\u5766\u5362\u5e03|\u7231\u6c99\u5c3c\u4e9a\u514b\u6717|\u8d64\u9053\u51e0\u5185\u4e9a\u5339\u585e\u5854|\u5357\u7279\u5e02\u5362\u5e03|\u6e2f\u5143|\u4e39\u9ea6\u514b\u6717|\u5357\u7279\u5e02\u5217\u4f0a|\u8d64\u9053\u51e0\u5185\u4e9a\u6cd5\u90ce|\u8d64\u9053\u51e0\u5185\u4e9a\u7231\u514b\u5a01\u4e50|\u5370\u5ea6\u5c3c\u897f\u4e9a\u76fe|\u963f\u8054\u914b\u8fea\u62c9\u59c6|\u5317\u671d\u9c9c\u5e01|\u5370\u5ea6\u5c3c\u897f\u4e9a\u65b0\u76fe|\u6ce2\u6e23\u90a3\u6251\u62c9|\u5357\u7279\u5e02\u5217\u4f0a\u5e01|\u5370\u5ea6\u5c3c\u897f\u4e9a\u722a\u54c7\u76fe|\u5317\u671d\u9c9c\u4eba\u6c11\u5e01|\u5370\u5ea6\u5c3c\u897f\u4e9a\u5c3c\u5361\u76fe|\u74e6\u52aa\u963f\u56fe|\u4f0a\u65af\u5170\u7b2c\u7eb3\u5c14\u5143|\u7d22\u9a6c\u91cc\u5148\u4ee4|\u5b89\u9053\u5c14\u6bd4\u585e\u5854\u5143|\u4fc4\u56fd\u5362\u5e03 (1991-1998)|\u74dc\u5fb7\u7f57\u666e\u5c9b\u6cd5\u90ce|\u5409\u5e03\u63d0\u6cd5\u90ce|\u5b89\u9053\u5c14\u7b2c\u7eb3\u5c14\u5143|\u6469\u6d1b\u54e5\u9769\u547d\u65f6\u671f\u8d27\u5e01|\u6469\u6d1b\u54e5\u65b0\u6cd5\u90ce|\u5384\u74dc\u591a\u5c14\u82cf\u514b\u96f7|\u5217\u652f\u6566\u58eb\u767b\u6cd5\u90ce|\u4fc4\u56fd\u5362\u5e03|\u83f2\u5f8b\u5bbe\u6bd4\u7d22|\u4e4c\u5179\u522b\u514b\u65af\u5766\u5e01|\u54e5\u4f26\u6bd4\u4e9a\u6bd4\u7d22|\u6cf0\u94e2|\u5317\u7231\u5c14\u5170\u78c5|\u7f05\u7538\u5362\u6bd4|\u521a\u679c CFA \u6cd5\u90ce|\u7f05\u5143|\u54e5\u4f26\u6bd4\u4e9a\u7eb8\u6bd4\u7d22|\u4e4c\u5179\u522b\u514b\u65af\u5766\u8d27\u5e01\u5238|\u4e4c\u514b\u5170\u5e01|\u5361\u5854\u5c14\u91cc\u4e9a\u5c14|\u4e4c\u514b\u5170\u8d6b\u91cc\u7eb3|\u51e0\u5185\u4e9aSyli|\u4eba\u6c11\u5e01|\u83ab\u6851\u6bd4\u514b\u5e01|\u4e2d\u56fd\u7f8e\u5143\u5916\u6c47\u5238|\u4e4c\u62c9\u572d\u6bd4\u7d22|\u51e0\u5185\u4e9a\u6cd5\u90ce (1960-1972)|\u5723\u9a6c\u5229\u8bfa\u91cc\u62c9|\u83ab\u6851\u6bd4\u514b\u57c3\u65af\u5e93\u591a|\u4e2d\u56fd\u4eba\u6c11\u7968\u5143|\u51e0\u5185\u4e9a\u6cd5\u90ce|\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a\u57fa\u90a3|\u963f\u66fc\u91cc\u5c14\u585e\u8fea|\u963f\u66fc\u91cc\u5c14|\u4e4c\u62c9\u572d\u6bd4\u7d22 (1975-1993)|\u4e0d\u4e39\u5362\u6bd4|\u624e\u4f0a\u5c14\u5143|\u6469\u6d1b\u54e5\u6cd5\u90ce|\u6469\u6d1b\u54e5\u8fea\u62c9\u59c6|\u4e0d\u4e39\u52aa\u624e\u59c6|\u6cd5\u56fd\u91d1\u6cd5\u90ce|\u4e4c\u62c9\u572d\u6bd4\u7d22\u4f0f\u5c14\u7279|\u9a6c\u6765\u897f\u4e9a\u5e01|\u65b0\u624e\u4f0a\u5c14\u5143|\u5188\u6bd4\u4e9a\u78c5|\u79d1\u6469\u7f57\u6cd5\u90ce|\u8d5b\u62c9\u91cc\u6602\u5e01|\u5188\u6bd4\u4e9a\u8fbe\u62c9\u897f|\u6b27\u6d32\u8d27\u5e01\u5355\u4f4d|\u5df4\u54c8\u9a6c\u78c5|\u5580\u9ea6\u9686 CFA \u6cd5\u90ce|\u5df4\u54c8\u9a6c\u5143|\u58a8\u897f\u54e5\u94f6\u6bd4\u7d22 (1861-1992)|\u58a8\u897f\u54e5\u6bd4\u7d22|\u79d8\u9c81\u7d22\u989d|\u683c\u9675\u5170\u514b\u6717|\u5df4\u897f\u514b\u9c81\u585e\u7f57 (1942-1967)|\u79d8\u9c81\u7d22\u989d\u5974\u827e\u631d|\u667a\u5229 \u6bd4\u7d22|\u65af\u6d1b\u4f10\u514b\u79d1\u8def\u90a3|\u79d8\u9c81\u56e0\u8482|\u5df4\u897f\u514b\u9c81\u585e\u7f57|\u7279\u522b\u63d0\u6b3e\u6743|\u6cd5\u56fd\u6cd5\u90ce\u6bd4\u65af\u67e5/\u6cd5\u90ce\u5e9e\u52a0\u83b1|\u6cd5\u56fd\u6cd5\u90ce|\u5df4\u897f\u514b\u9c81\u585e\u7f57 Cruzado Novo|\u667a\u5229 Unidades de Fomento|\u667a\u5229\u57c3\u65af\u5e93\u591a|\u5df4\u897f\u91cc\u5c14|\u667a\u5229\u80af\u675c|\u5df4\u897f\u514b\u9c81\u585e\u7f57 (1990-1993)|\u5fb7\u56fd\u53f8\u8421\u9a6c\u514b|\u9a6c\u62c9\u7ef4\u78c5|\u5df4\u897f\u514b\u9c81\u585e\u7f57|\u5df4\u897f\u514b\u9c81\u8d5b\u7f57 (1967-1986)|\u9a6c\u62c9\u7ef4\u5938\u6070|\u8f66\u57ce\u5362\u5e03|\u5fb7\u56fd\u9a6c\u514b|\u8f66\u57ce\u65b0\u5362\u5e03|\u8f66\u57ce\u5362\u5e03\u5238|\u5c3c\u6cca\u5c14\u5362\u6bd4|\u5e93\u514b\u7fa4\u5c9b\u5143|\u65e5\u5143|\u9a6c\u5c14\u4ee3\u592b\u7fa4\u5c9b\u82a6\u83f2\u4e9a|\u9a6c\u5c14\u4ee3\u592b\u7fa4\u5c9b\u5362\u6bd4|\u4e1c\u52a0\u52d2\u6bd4\u5143|\u65af\u6d1b\u6587\u5c3c\u4e9a\u6dd8\u62c9|\u5357\u65af\u62c9\u592b\u6539\u9769\u7b2c\u7eb3\u5c14\u5143|\u963f\u9c81\u5df4\u57fa\u5c14\u5fb7\u5143|\u5357\u65af\u62c9\u592b\u5341\u6708\u7b2c\u7eb3\u5c14\u5143|\u4e1c\u5fb7\u5965\u65af\u7279\u9a6c\u514b|\u5357\u65af\u62c9\u592b\u5151\u6362\u7b2c\u7eb3\u5c14\u5143|\u5357\u65af\u62c9\u592b\u504c\u5a01\u7b2c\u7eb3\u5c14\u5143|\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b\u514b\u6717|\u5357\u65af\u62c9\u592b 1994 \u7b2c\u7eb3\u5c14\u5143|\u5357\u65af\u62c9\u592b\u8054\u90a6\u7b2c\u7eb3\u5c14\u5143|\u7f57\u9a6c\u5c3c\u4e9a\u65b0\u956d|\u5357\u65af\u62c9\u592b\u786c\u7b2c\u7eb3\u5c14\u5143|\u7f57\u9a6c\u5c3c\u4e9a\u956d|\u65af\u6d1b\u6587\u5c3c\u4e9a\u6dd8\u62c9\u78c5|\u632a\u5a01\u514b\u6717|\u6bdb\u91cc\u6c42\u65af\u5362\u6bd4|\u76f4\u5e03\u7f57\u9640\u78c5|\u8d8a\u5357\u56fd\u5bb6\u76fe|\u8d8a\u5357\u5171\u548c\u56fd\u76fe|\u6b27\u6d32\u91d1\u878d\u5355\u4f4d|\u6b27\u6d32\u590d\u5408\u5355\u4f4d|\u57fa\u91cc\u5df4\u65af\u5143|\u5723\u8d6b\u52d2\u62ff\u78c5|\u8d8a\u5357\u660e\u76fe";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|GMP|KMF|SLL|GMD|XEU|BSP|CMF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|PDN|PDK|NPR|CKD|JPY|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JOD|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|S$|PAB|LAK|KGS|CHF|ATS|US$|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|NT$|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|P|NIG|NIC|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|\uffe6|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HK$|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|\uffe5|MZM|CNX|UYU|GNI|SML|MZE|CNP|PGK|OMS|GNF|UYP|OMR|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|GMP|KMF|SLL|GMD|XEU|BSP|CMF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|PDN|PDK|NPR|CKD|JP\u00a5|MVR|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|GIP|VNS|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u4e00\u6708",
    "\u4e8c\u6708",
    "\u4e09\u6708",
    "\u56db\u6708",
    "\u4e94\u6708",
    "\u516d\u6708",
    "\u4e03\u6708",
    "\u516b\u6708",
    "\u4e5d\u6708",
    "\u5341\u6708",
    "\u5341\u4e00\u6708",
    "\u5341\u4e8c\u6708",
    null,
  };

  private static final String[] months = {
    "\u4e00\u6708",
    "\u4e8c\u6708",
    "\u4e09\u6708",
    "\u56db\u6708",
    "\u4e94\u6708",
    "\u516d\u6708",
    "\u4e03\u6708",
    "\u516b\u6708",
    "\u4e5d\u6708",
    "\u5341\u6708",
    "\u5341\u4e00\u6708",
    "\u5341\u4e8c\u6708",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u65e5",
    "\u4e00",
    "\u4e8c",
    "\u4e09",
    "\u56db",
    "\u4e94",
    "\u516d",
  };

  private static final String[] weekdays = {
    null,
    "\u661f\u671f\u65e5",
    "\u661f\u671f\u4e00",
    "\u661f\u671f\u4e8c",
    "\u661f\u671f\u4e09",
    "\u661f\u671f\u56db",
    "\u661f\u671f\u4e94",
    "\u661f\u671f\u516d",
  };

  private static final String[] eras = {
    "\u516c\u5143\u524d",
    "\u516c\u5143",
  };

  private static final String[] ampms = {
    "\u4e0a\u5348",
    "\u4e0b\u5348",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "\u592a\u5e73\u6d0b\u6807\u51c6\u65f6\u95f4", "PDT", "\u592a\u5e73\u6d0b\u590f\u4ee4\u65f6\u95f4",  "America/Los_Angeles" },
    { "GMT", "\u683c\u6797\u5a01\u6cbb\u6807\u51c6\u65f6\u95f4", "GMT", "\u683c\u6797\u5a01\u6cbb\u6807\u51c6\u65f6\u95f4",  "Africa/Casablanca" },
    { "EST", "\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4", "EDT", "\u4e1c\u90e8\u590f\u4ee4\u65f6\u95f4",  "America/New_York" },
    { "AST", "\u963f\u62c9\u65af\u52a0\u6807\u51c6\u65f6\u95f4", "ADT", "\u963f\u62c9\u65af\u52a0\u590f\u4ee4\u65f6\u95f4",  "America/Anchorage" },
    { "GMT", "\u683c\u6797\u5a01\u6cbb\u6807\u51c6\u65f6\u95f4", "GMT", "\u683c\u6797\u5a01\u6cbb\u6807\u51c6\u65f6\u95f4",  "Etc/GMT" },
    { "CTT", "\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4", "CDT", "\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4",  "Asia/Shanghai" },
    { "AST", "\u5927\u897f\u6d0b\u6807\u51c6\u65f6\u95f4", "ADT", "\u5927\u897f\u6d0b\u590f\u4ee4\u65f6\u95f4",  "America/Halifax" },
    { "CET", "\u4e2d\u6b27\u6807\u51c6\u65f6\u95f4", "CEST", "\u4e2d\u6b27\u590f\u4ee4\u65f6\u95f4",  "Europe/Paris" },
    { "MST", "\u5c71\u533a\u6807\u51c6\u65f6\u95f4", "MDT", "\u5c71\u533a\u590f\u4ee4\u65f6\u95f4",  "America/Denver" },
    { "IST", "\u4ee5\u8272\u5217\u6807\u51c6\u65f6\u95f4", "IDT", "\u4ee5\u8272\u5217\u590f\u4ee4\u65f6\u95f4",  "Asia/Jerusalem" },
    { "HST", "\u590f\u5a01\u5937\u6807\u51c6\u65f6\u95f4", "HST", "\u590f\u5a01\u5937\u6807\u51c6\u65f6\u95f4",  "Pacific/Honolulu" },
    { "CNT", "\u7ebd\u82ac\u5170\u6807\u51c6\u65f6\u95f4", "CDT", "\u7ebd\u82ac\u5170\u590f\u4ee4\u65f6\u95f4",  "America/St_Johns" },
    { "EST", "\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4", "EST", "\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4",  "America/Indianapolis" },
    { "CST", "\u4e2d\u592e\u6807\u51c6\u65f6\u95f4", "CDT", "\u4e2d\u592e\u590f\u4ee4\u65f6\u95f4",  "America/Chicago" },
    { "EET", "\u4e1c\u6b27\u6807\u51c6\u65f6\u95f4", "EEST", "\u4e1c\u6b27\u590f\u4ee4\u65f6\u95f4",  "Europe/Bucharest" },
    { "JST", "\u65e5\u672c\u6807\u51c6\u65f6\u95f4", "JST", "\u65e5\u672c\u6807\u51c6\u65f6\u95f4",  "Asia/Tokyo" },
    { "MST", "\u5c71\u533a\u6807\u51c6\u65f6\u95f4", "MST", "\u5c71\u533a\u6807\u51c6\u65f6\u95f4",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u4e1c\u5e1d\u6c76|\u6258\u514b\u52b3|\u5854\u5409\u514b\u65af\u5766|\u6cf0\u56fd|\u591a\u54e5|\u6cd5\u5c5e\u5357\u534a\u7403\u9886\u5730|\u572d\u4e9a\u90a3|\u4e4d\u5f97|\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b|\u51e0\u5185\u4e9a\u6bd4\u7ecd|\u5173\u5c9b|\u5371\u5730\u9a6c\u62c9|\u5357\u4f50\u6cbb\u4e9a\u548c\u5357\u4e09\u660e\u6cbb\u7fa4\u5c9b|\u5e0c\u814a|\u8d64\u9053\u51e0\u5185\u4e9a|\u74dc\u5fb7\u7f57\u666e\u5c9b|\u65af\u5a01\u58eb\u5170|\u53d9\u5229\u4e9a|\u51e0\u5185\u4e9a|\u5188\u6bd4\u4e9a|\u683c\u9675\u5170|\u8428\u5c14\u74e6\u591a|\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4|\u76f4\u5e03\u7f57\u9640|\u52a0\u7eb3|\u82cf\u91cc\u5357|\u6cd5\u5c5e\u572d\u4e9a\u90a3|\u585e\u5c14\u7ef4\u4e9a|\u683c\u9c81\u5409\u4e9a|\u7d22\u9a6c\u91cc|\u683c\u6797\u7eb3\u8fbe|\u585e\u5185\u52a0\u5c14|\u5723\u9a6c\u529b\u8bfa|\u82f1\u56fd|\u585e\u62c9\u5229\u6602|\u52a0\u84ec|\u65af\u6d1b\u4f10\u514b|\u65af\u74e6\u5c14\u5df4\u7279\u548c\u626c\u9a6c\u5ef6|\u65af\u6d1b\u6587\u5c3c\u4e9a|\u5723\u8d6b\u52d2\u62ff|\u65b0\u52a0\u5761|\u745e\u5178|\u82cf\u4e39|\u585e\u820c\u5c14|\u6240\u7f57\u95e8\u7fa4\u5c9b|\u6c99\u7279\u963f\u62c9\u4f2f|\u6cd5\u56fd|\u6cd5\u7f57\u7fa4\u5c9b|\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u8054\u90a6|\u5362\u65fa\u8fbe|\u798f\u514b\u5170\u7fa4\u5c9b|\u4fc4\u7f57\u65af\u8054\u90a6|\u6590\u6d4e|\u82ac\u5170|\u7f57\u9a6c\u5c3c\u4e9a|\u7559\u5c3c\u6c6a|\u57c3\u585e\u4fc4\u6bd4\u4e9a|\u897f\u73ed\u7259|\u5384\u7acb\u7279\u91cc\u4e9a|\u897f\u6492\u54c8\u62c9|\u57c3\u53ca|\u7231\u6c99\u5c3c\u4e9a|\u5384\u74dc\u591a\u5c14|\u963f\u5c14\u53ca\u5229\u4e9a|\u5361\u5854\u5c14|\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd|\u5df4\u62c9\u572d|\u591a\u7c73\u5c3c\u52a0\u5c98|\u5e15\u52b3|\u4e39\u9ea6|\u5409\u5e03\u63d0|\u8461\u8404\u7259|\u5df4\u52d2\u65af\u5766\u9886\u571f|\u6ce2\u591a\u9ece\u5404|\u5fb7\u56fd|\u76ae\u7279\u51ef\u6069|\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686|\u6ce2\u5170|\u5df4\u57fa\u65af\u5766|\u83f2\u5f8b\u5bbe|\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a|\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a|\u6377\u514b\u5171\u548c\u56fd|\u79d8\u9c81|\u585e\u6d66\u8def\u65af|\u5723\u8bde\u5c9b|\u4f5b\u5f97\u89d2|\u5df4\u62ff\u9a6c|\u53e4\u5df4|\u54e5\u65af\u8fbe\u9ece\u52a0|\u54e5\u4f26\u6bd4\u4e9a|\u4e2d\u56fd|\u5580\u9ea6\u9686|\u667a\u5229|\u5e93\u514b\u7fa4\u5c9b|\u8c61\u7259\u6d77\u5cb8|\u745e\u58eb|\u521a\u679c|\u4e2d\u975e\u5171\u548c\u56fd|\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd|\u79d1\u79d1\u65af\u7fa4\u5c9b|\u963f\u66fc|\u52a0\u62ff\u5927|\u4f2f\u5229\u5179|\u767d\u4fc4\u7f57\u65af|\u535a\u8328\u74e6\u7eb3|\u5e03\u7ef4\u7279\u5c9b|\u4e0d\u4e39|\u5df4\u54c8\u9a6c|\u5df4\u897f|\u65b0\u897f\u5170|\u73bb\u5229\u7ef4\u4e9a|\u6587\u83b1|\u767e\u6155\u5927|\u7ebd\u57c3|\u8d1d\u5b81|\u5e03\u9686\u8fea|\u5df4\u6797|\u7459\u9c81|\u4fdd\u52a0\u5229\u4e9a|\u5e03\u57fa\u7eb3\u6cd5\u7d22|\u5c3c\u6cca\u5c14|\u6bd4\u5229\u65f6|\u632a\u5a01|\u5b5f\u52a0\u62c9\u56fd|\u5df4\u5df4\u591a\u65af|\u6d25\u5df4\u5e03\u97e6|\u8377\u5170|\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u5c71\u5171\u548c\u56fd|\u5c3c\u52a0\u62c9\u74dc|\u5c3c\u65e5\u5229\u4e9a|\u8bfa\u798f\u514b\u5c9b|\u963f\u585e\u62dc\u7586|\u5c3c\u65e5\u5c14|\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a|\u963f\u9c81\u5df4|\u8d5e\u6bd4\u4e9a|\u7eb3\u7c73\u6bd4\u4e9a|\u6fb3\u5927\u5229\u4e9a|\u5965\u5730\u5229|\u7f8e\u5c5e\u8428\u6469\u4e9a|\u963f\u6839\u5ef7|\u5357\u6781\u6d32|\u83ab\u6851\u6bd4\u514b|\u5b89\u54e5\u62c9|\u9a6c\u6765\u897f\u4e9a|\u8377\u5c5e\u5b89\u7684\u5217\u65af\u7fa4\u5c9b|\u58a8\u897f\u54e5|\u4e9a\u7f8e\u5c3c\u4e9a|\u9a6c\u62c9\u7ef4|\u963f\u5c14\u5df4\u5c3c\u4e9a|\u9a6c\u5c14\u4ee3\u592b|\u5357\u975e|\u6bdb\u91cc\u6c42\u65af|\u9a6c\u8033\u4ed6|\u5b89\u572d\u62c9|\u8499\u7279\u585e\u62c9\u7fa4\u5c9b|\u6bdb\u91cc\u5854\u5c3c\u4e9a|\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe|\u9a6c\u63d0\u5c3c\u514b\u5c9b|\u963f\u5bcc\u6c57|\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b|\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd|\u4e2d\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a|\u5b89\u9053\u5c14|\u8499\u53e4|\u7f05\u7538|\u9a6c\u91cc|\u9a6c\u5176\u987f\u738b\u56fd|\u5357\u65af\u62c9\u592b|\u9a6c\u7ea6\u7279|\u9a6c\u7ecd\u5c14\u7fa4\u5c9b|\u9a6c\u8fbe\u52a0\u65af\u52a0|\u6469\u5c14\u591a\u74e6\u5171\u548c\u56fd|\u6469\u7eb3\u54e5|\u6469\u6d1b\u54e5|\u4e5f\u95e8|\u5229\u6bd4\u4e9a|\u62c9\u8131\u7ef4\u4e9a|\u5362\u68ee\u5821|\u7acb\u9676\u5b9b|\u83b1\u7d22\u6258|\u5229\u6bd4\u91cc\u4e9a|\u65af\u91cc\u5170\u5361|\u5217\u652f\u6566\u58eb\u767b|\u5723\u5362\u897f\u4e9a|\u9ece\u5df4\u5ae9|\u8001\u631d\u4eba\u6c11\u6c11\u4e3b\u5171\u548c\u56fd|\u54c8\u8428\u514b\u65af\u5766|\u5f00\u66fc\u7fa4\u5c9b|\u79d1\u5a01\u7279|\u97e9\u56fd|\u5317\u671d\u9c9c|\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af|\u79d1\u6469\u7f57|\u57fa\u91cc\u5df4\u65af|\u8428\u6469\u4e9a|\u67ec\u57d4\u5be8|\u5409\u5c14\u5409\u514b\u65af\u5766|\u80af\u5c3c\u4e9a|\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3|\u65e5\u672c|\u7ea6\u65e6|\u7259\u4e70\u52a0|\u74e6\u52aa\u963f\u56fe|\u8d8a\u5357|\u7f8e\u5c5e\u7ef4\u4eac\u7fa4\u5c9b|\u82f1\u5c5e\u7ef4\u4eac\u7fa4\u5c9b|\u59d4\u5185\u745e\u62c9|\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af|\u68b5\u8482\u5188|\u610f\u5927\u5229|\u51b0\u5c9b|\u4f0a\u6717|\u4f0a\u62c9\u514b|\u4e4c\u5179\u522b\u514b\u65af\u5766|\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730|\u4e4c\u62c9\u572d|\u5370\u5ea6|\u4ee5\u8272\u5217|\u7f8e\u56fd|\u7231\u5c14\u5170|\u5370\u5ea6\u5c3c\u897f\u4e9a|\u7f8e\u56fd\u8fb9\u8fdc\u5c0f\u5c9b|\u4e4c\u5e72\u8fbe|\u4e4c\u514b\u5170|\u5308\u7259\u5229|\u6d77\u5730|\u514b\u7f57\u5730\u4e9a|\u5766\u6851\u5c3c\u4e9a|\u6d2a\u90fd\u62c9\u65af|\u8d6b\u5fb7\u4e0e\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b|\u53f0\u6e7e|\u56fe\u74e6\u5362|\u4e2d\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a|\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5|\u571f\u8033\u5176|\u6c64\u52a0|\u7a81\u5c3c\u65af|\u571f\u5e93\u66fc\u65af\u5766";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|ijo|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|vai|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|tiv|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|ach|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|luo|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "\u5409\u7ef4\u514b\u7434\u6587|\u963f\u5361\u5fb7\u6587|\u4f0a\u4e54\u6587|\u73ed\u56fe\u6587|\u82cf\u9a6c\u6587|\u82cf\u82cf\u6587|\u5404\u79cd\u4e0d\u540c\u8bed\u8a00|\u6d1b\u5179\u6587|\u6c64\u52a0\u6587\uff08\u5c3c\u4e9a\u8428\u5730\u533a\uff09|\u6ce2\u90a3\u8d1d\u6587|\u7c73\u5357\u5361\u4fdd\u6587|\u82cf\u5e93\u9a6c\u6587|\u6c83\u5c14\u592b\u6587|\u8499\u53e4\u6587|\u5e93\u7279\u5185\u6587|\u7c73\u514b\u9a6c\u514b\u6587|\u83ef\u9686\u6587|\u5e93\u6885\u514b\u6587|\u8428\u6ce2\u8482\u514b\u6587|\u5176\u4ed6\u5e93\u65bd\u7279\u8bed\u7cfb|\u6d1b\u5409\u822c\uff08\u4eba\u5de5\u8bed\u8a00\uff09|\u591a\u683c\u6765\u6587|\u6c83\u62c9\u666e\u514b\u6587|\u5965\u6258\u7c73\u8bed\u7cfb|\u8d8a\u5357\u6587|\u74e6\u4f0a\u6587|\u62c9\u7f57\u6c64\u52a0\u6587|\u6587\u8fbe\u6587|\u62c9\u5e15\u52aa\u6587|\u62c9\u8d3e\u65af\u5766\u6587|\u5965\u6258\u66fc\u571f\u8033\u5176\u6587|\u5c3c\u5179\u739b\u6587|\u62ff\u6ce2\u91cc\u6587|\u4e4c\u5179\u522b\u514b\u6587|\u4e4c\u52a0\u91cc\u7279\u6587|\u5854\u739b\u538d\u514b\u6587|\u5176\u4ed6\u5317\u7f8e\u5370\u7b2c\u5b89\u8bed\u7cfb|\u7eb3\u74e6\u7279\u5c14\u6587|\u4e4c\u5c14\u90fd\u6587|\u82b3\u8482\u6587|\u4e4c\u514b\u5170\u6587|\u7ef4\u543e\u5c14\u6587|\u82b3\u683c\u6587|\u5176\u4ed6\u5c3c\u7f57\u8428\u54c8\u5170\u6587|\u4e2d\u53e4\u7231\u5c14\u5170\u6587|\u6ce2\u7f57\u7684\u6d77\u5730\u533a\u4e4b\u8bed\u8a00|\u5c3c\u7ea6\u7f57\u8bed\u65cf|\u5df4\u8428\u6587|\u5c3c\u6602\u79d1\u52d2\u6587|\u5c3c\u4e9a\u59c6\u97e6\u9f50\u6587|\u8d6b\u8499\u6587|\u5df4\u91cc\u6587|\u5965\u8428\u54f2\u6587|\u4ffe\u8def\u652f\u6587|\u5854\u897f\u63d0\u6587|\u5df4\u7c73\u7d2f\u514b\u6587|\u53f0\u6e7e\u6587|\u8c22\u5217\u5c14\u6587|\u7279\u6797\u5409\u7279\u6587|\u9791\u977c\u6587|\u7279\u677e\u52a0\u6587|\u73ed\u8fbe\u6587|\u571f\u8033\u5176\u6587|\u6c64\u52a0\u6587|\u7a81\u5c3c\u65af\u6587|\u5854\u52a0\u8def\u65cf\u6587|\u571f\u5e93\u66fc\u6587|\u63d0\u683c\u91cc\u5c3c\u4e9a\u6587|\u6cf0\u6587|\u5e93\u9c81\u514b\u6587|\u5854\u5409\u514b\u6587|\u5e03\u6797\u6587|\u6cf0\u5362\u56fa\u6587|\u514b\u9c81\u6587|\u5361\u8212\u6587|\u6cf0\u7c73\u5c14\u6587|\u9640\u514b\u5a04\u6587|\u65af\u74e6\u5e0c\u91cc\u6587|\u745e\u5178\u6587|\u82cf\u4e39\u6587|\u5361\u62c9\u5361\u5c14\u5e15\u514b\u6587|\u585e\u7d22\u6258\u6587|\u8f9b\u8f9b\u90a3\u63d0\u6587|\u585e\u5c14\u7ef4\u4e9a\u6587|\u963f\u5c14\u5df4\u5c3c\u4e9a\u6587|\u95e8\u8fea\u6587|\u514b\u91cc\u5965\u5c14\u8bed\u548c\u76ae\u94a6\u6587|\u7d22\u9a6c\u91cc\u6587|\u963f\u5f17\u91cc\u5e0c\u5229\u6587|\u585e\u5185\u52a0\u5c14\u6587|\u8428\u6469\u4e9a\u6587|\u65af\u6d1b\u6587\u5c3c\u4e9a\u6587|\u53e4\u5e0c\u814a\u6587|\u65af\u6d1b\u4f10\u514b\u6587|\u683c\u5217\u535a\u6587|\u50e7\u4f3d\u7f57\u6587|\u585e\u6ce2\u5c3c\u65af-\u514b\u7f57\u5730\u4e9a\u6587|\u514b\u91cc\u7c73\u4e9a\u571f\u8033\u5176\u6587\uff1b\u514b\u91cc\u7c73\u4e9a\u5854\u5854\u6587|\u5176\u4ed6\u4e9a\u975e\u8bed\u7cfb|\u6851\u6208\u6587|\u5317\u8428\u8ff7\u6587|\u82cf\u4e39\u6587|\u4e4c\u5fb7\u7a46\u5c14\u7279\u6587|\u8428\u4e01\u6587|\u68b5\u6587|\u5362\u65fa\u8fbe\u6587|\u4fc4\u6587|\u66fc\u8fbe\u5c14|\u7f57\u9a6c\u5c3c\u4e9a\u6587|\u57fa\u9686\u8fea\u6587|\u91cc\u6258\u7f57\u66fc\u65af\u6587|\u83ab\u514b\u6c99\u6587|\u8482\u592b\u6587|\u963f\u8fea\u4f55\u6587|\u7956\u5c3c\u8bed|\u514b\u4f69\u5217\u6587|\u76d6\u4e18\u4e9a\u6587|\u63d0\u683c\u96f7\u6587|\u6851\u6d77\u6587|\u4e0d\u7eaf\u7cb9\u4e4b\u8461\u56fd\u65b9\u8a00|\u7d22\u683c\u8fea\u4e9a\u6587|\u963f\u5f53\u6885\u6587|\u67ef\u53f8\u745e\u6069\u6587|\u897f\u53f0\u6587|\u4e0d\u7eaf\u7cb9\u4e4b\u6cd5\u56fd\u65b9\u8a00|\u4e0d\u7eaf\u7cb9\u4e4b\u82f1\u56fd\u65b9\u8a00|\u8d6b\u9a6c\u67e5\u5229\u6587|\u521a\u5361\u5c3c\u6587|\u5e0c\u5229\u76d6\u519c\u6587|\u54e5\u8fbe\u6587|\u79d1\u6d1b\u6d85\u8fbe\u7f57\u6587|\u5c97\u5fb7\u6587|\u4e01\u5361\u6587|\u52aa\u6bd4\u4e9a\u6587|\u8461\u8404\u7259\u6587|\u666e\u4ec0\u56fe\u6587|\u5f17\u7559\u5229\u6587|\u8153\u5229\u57fa\u6587|\u53e4\u4ee3\u9ad8\u5730\u5fb7\u6587|\u7d22\u5c3c\u57fa\u6587|\u79d1\u666e\u7279\u6587|\u96c5\u6d66\u6587|\u963f\u4e54\u5229\u6587|\u7476\u65cf\u6587|\u5176\u4ed6\u83f2\u5f8b\u5bbe\u8bed\u7cfb|\u6ce2\u5170\u6587|\u4e9a\u9f50\u6587|\u5e15\u5229\u6587|\u65c1\u906e\u666e\u6587|\u5e03\u5409\u6587|\u4f0a\u73ed\u6587|\u53f8\u5bc7\u7279\u8428\u8ff7\u6587|\u5e03\u91cc\u4e9a\u7279\u6587|\u8428\u4f0a\u8bed|\u4f9d\u7eb3\u65e5\u8428\u8ff7\u6587|\u5965\u585e\u63d0\u6587|\u9a6c\u6765\u4e9a\u73bb\u91cc\u5c3c\u897f\u4e9a\u8bed\u7cfb|\u6b27\u91cc\u4e9a\u6587|\u66fc\u4e01\u54e5\u6587|\u5362\u4e50\u8428\u8ff7\u6587|\u5176\u4ed6\u8428\u8ff7\u6587|\u671b\u52a0\u9521\u6587|\u963f\u66fc\u6587|\u8fc8\u8482\u5229\u6587|\u5965\u5b63\u5e03\u74e6\u6587|\u9a6c\u52a0\u4f0a\u6587|\u9a6c\u90fd\u62c9\u6587|\u5357\u8428\u8ff7\u6587|\u5965\u897f\u5766\u6587|\u5317\u7d22\u6258\u6587|\u5df4\u5854\u514b\u6587|\u4fc4\u65e5\u4e9a\u6587|\u591a\u683c\u6765\u6587|\u5c3c\u6602\u52a0\u6587\uff1b\u5207\u74e6\u6587\uff1b\u5207\u74e6\u6587|\u739b\u96c5\u6587|\u7eb3\u74e6\u970d\u6587|\u91d1\u90a6\u675c\u6587|\u5357\u90e8\u6069\u5fb7\u8d1d\u52d2\u6587|\u4e2d\u53e4\u9ad8\u5730\u5fb7\u6587|\u632a\u5a01\u6587|\u632a\u5a01\u5c3c\u8bfa\u65af\u514b\u6587|\u8377\u5170\u6587|\u6069\u4e1c\u52a0\u6587|\u5176\u4ed6\u65af\u62c9\u592b\u8bed\u7cfb|\u5c3c\u6cca\u5c14\u6587|\u5317\u6069\u5fb7\u8d1d\u52d2\u6587|\u67e5\u7c73\u514b\u6587|\u7279\u56fe\u4eec\u6587|\u632a\u5a01\u535a\u514b\u9a6c\u5c14\u6587|\u7459\u9c81\u6587|\u7279\u558f\u8bfa\u6587|\u4f53\u59c6\u5450\u6587|\u7f05\u7538\u6587|\u83b1\u5179\u4f9d\u6602\u6587|\u9a6c\u8033\u4ed6\u6587|\u53e4\u8001\u6ce2\u65af\u8bed|\u9a6c\u6765\u6587|\u9a6c\u62c9\u5730\u6587|\u53e4\u6cd5\u6587|\u6469\u5c14\u591a\u74e6\u6587|\u4e2d\u53e4\u6cd5\u6587|\u8499\u53e4\u6587|\u72b9\u592a\u963f\u62c9\u4f2f\u8bed\u7cfb|\u9a6c\u6765\u4e9a\u62c9\u59c6\u6587|\u9a6c\u5176\u987f\u6587|\u6bdb\u5229\u6587|\u9a6c\u7ecd\u5c14\u6587|\u9a6c\u5c14\u52a0\u4ec0\u6587|\u9a6c\u5c14\u5c3c\u91cc\u6587|\u5e03\u62c9\u6770\u6587|\u53f8\u96f7\u592b\u6587|\u62c9\u812b\u7dad\u4e9e\u6587|\u9c81\u5df4\u52a0\u4e39\u52a0\u6587|\u7279\u62c9\u74e6\u5370\u7b2c\u5b89\u4eba\u6587|\u7acb\u9676\u5b9b\u6587|\u8001\u631d\u6587|\u6797\u52a0\u62c9\u6587|\u6dcb\u5e03\u5c14\u5409\u6587|\u65fa\u675c\u6587|\u5362\u5e72\u8fbe\u6587|\u5362\u68ee\u5821\u6587|\u62c9\u4e01\u6587|\u72b9\u592a\u6ce2\u65af\u8bed\u7cfb|\u6c83\u63d0\u514b\u6587|\u5176\u4ed6\u6c49\u85cf\u8bed\u7cfb|\u5409\u5c14\u5409\u65af\u6587|\u51ef\u5c14\u7279\u6587|\u79d1\u7c73\u6587|\u5e93\u5c14\u5fb7\u6587|\u82cf\u8bed\u8bf8\u8bed\u8a00|\u514b\u4ec0\u7c73\u5c14\u6587|\u5361\u52aa\u91cc\u6587|\u963f\u74e6\u4e54\u6587|\u97e9\u6587|\u57c3\u7eb3\u5fb7\u6587|\u67ec\u57d4\u5be8\u6587|\u683c\u9675\u5170\u6587|\u54c8\u8428\u514b\u6587|\u5409\u666e\u8d5b\u6587|\u5173\u740a\u739b\u6587|\u6089\u8fbe\u6469\u6587|\u5409\u5e93\u5c24\u6587|\u521a\u679c\u6587|\u53e4\u8bfa\u5c14\u65af\u6587|\u683c\u9c81\u5409\u4e9a\u6587|\u6469\u65af\u79d1\u683c\u6587|\u5176\u4ed6\u62c9\u4e01\u8bed\u7cfb|\u8bfa\u76d6\u6587|\u8499\u8fbe\u6587|\u591a\u79cd\u8bed\u8a00|\u722a\u54c7\u6587|\u5409\u5c14\u4f2f\u7279\u65af\u6587|\u8d5e\u5fb7\u6587|\u63b8\u6587|\u4e30\u6587|\u5361\u5566\u8ff7\u514b\u6587|\u6fb3\u5927\u5229\u4e9a\u8bed\u7cfb|\u548c\u7530\u6587|\u65e5\u6587|\u5176\u4ed6\u79d1\u4f0a\u6851\u6587|\u5e15\u52b3\u6587|\u590f\u5ef6\u6587|\u5176\u4ed6\u6cf0\u6587|\u7231\u65af\u57fa\u6469\u6587|\u5e15\u76ae\u4e9a\u5185\u6258\u6587|\u610f\u5927\u5229\u6587|\u624b\u8bed|\u51b0\u5c9b\u6587|\u5361\u897f\u6587|\u5f7b\u7f57\u57fa\u6587|\u90a6\u677f\u7259\u6587|\u5e15\u62c9\u7ef4\u6587|\u4f69\u74e6\u626c\u6587|\u7231\u5fb7\u83aa\u6587\uff08\u4eba\u5de5\u8bed\u8a00\uff09|\u4e54\u514b\u6258\u6587|\u5951\u52aa\u514b\u6587|\u9a6c\u91cc\u6587|\u56fe\u74e6\u6587|\u73ed\u56fe\u6587|\u90a6\u963f\u897f\u5357\u6587|\u4f9d\u5974\u76ae\u7ef4\u514b\u6587|\u695a\u543e\u514b\u6587|\u56db\u5ddd\u8bdd|\u590f\u5a01\u5937\u6587|\u5170\u5df4\u6587|\u4f0a\u683c\u535a\u6587|\u67e5\u52a0\u6587|\u53e4\u7231\u5c14\u5170\u6587|\u5176\u4ed6\u5df4\u5e03\u4e9a\u6587|\u62c9\u4e01\u56fd\u9645\u6587|\u5370\u5ea6\u5c3c\u897f\u4e9a\u6587|\u62c9\u4ea8\u8fbe\u6587|\u8fbe\u96c5\u514b\u6587|\u5951\u5e03\u5361\u6587|\u62c9\u4e01\u56fd\u9645\u6587|\u62c9\u8fea\u8bfa\u6587|\u8d6b\u96f7\u7f57\u6587|\u6d77\u8fbe\u6587|\u8fbe\u5c14\u683c\u74e6\u6587|\u4e9a\u7f8e\u5c3c\u4e9a\u6587|\u5176\u4ed6\u963f\u6492\u5df4\u65af\u5361\u8bed\u7cfb|\u5308\u7259\u5229\u6587|\u8fbe\u79d1\u4ed6\u6587|\u514b\u7f57\u5730\u4e9a\u6587|\u65b0\u91cc\u6728\u6258\u6587|\u5370\u5730\u6587|\u8fea\u5c24\u62c9\u6587|\u5e0c\u4f2f\u6765\u6587|\u963f\u65af\u56fe\u91cc\u4e9a\u601d\u7279\u8bed|\u8c6a\u6492\u6587|\u7d22\u5e03\u8bf8\u8bed\u8a00|\u9a6c\u6069\u5c9b\u6587|\u53e4\u52a0\u62c9\u63d0\u6587|\u5176\u4ed6\u95ea\u65cf\u8bed\u7cfb|\u585e\u5c14\u5e93\u666e\u6587|\u4f0a\u6d1b\u90ed\u4f0a\u8d39\u6587|\u74dc\u62c9\u5c3c\u6587|\u52a0\u5229\u897f\u4e9a\u6587|\u963f\u62c9\u74e6\u514b\u6587|\u5409\u5179\u6587|\u5176\u4ed6\u4eba\u5de5\u8bed\u8a00|\u82cf\u683c\u5170- \u76d6\u5c14\u6587|\u4f0a\u6717\u6587|\u7231\u5c14\u5170\u6587|\u963f\u62c9\u5e15\u970d\u6587|\u963f\u52b3\u574e\u6587|\u5f17\u91cc\u65af\u5170\u6587|\u53f8\u514b\u53f8\u5361\u6587|\u55bb\u76ae\u514b\u6587|\u963f\u62c9\u7c73\u6587|\u6cd5\u6587|\u6cd5\u7f57\u6587|\u5176\u4ed6\u51ef\u5c14\u7279\u8bed\u7cfb|\u6590\u6d4e\u6587|\u82ac\u5170\u6587|\u592b\u62c9\u6587|\u56fe\u74e6\u5362\u6587|\u5bbf\u52a1\u6587|\u6ce2\u65af\u6587|\u5df4\u65af\u514b\u6587|\u82cf\u683c\u5170\u6587|\u7231\u6c99\u5c3c\u4e9a\u6587|\u897f\u73ed\u7259\u6587|\u4e16\u754c\u6587|\u82f1\u6587|\u5e0c\u814a\u6587|\u5176\u4ed6\u963f\u5c14\u6cf0\u8bed\u7cfb|\u7ebd\u57c3\u6587|\u56fe\u5339\u6587|\u5e7d\u6587|\u901a\u5e03\u5361\u6587|\u83ab\u897f\u6587|\u4e0d\u4e39\u6587|\u5176\u4ed6\u5c3c\u65e5\u5c14\u521a\u679c\u8bed\u7cfb|\u5362\u6652\u6587|\u82ac\u5308\u6587\uff08\u5176\u4ed6\uff09|\u8fea\u7ef4\u5e0c\u6587|\u5c3c\u5c14\u53f8\u6587|\u6469\u970d\u514b\u6587|\u5362\u5965\u6587|\u9686\u8fbe\u6587|\u963f\u5e15\u5207\u6587|\u8def\u6613\u585e\u8bfa\u6587|\u80e1\u5e15\u6587|\u6bd4\u5c3c\u6587|\u5fb7\u6587|\u9c81\u5df4\u9c81\u74e6\u6587|\u6bd5\u5e93\u5c14\u6587|\u74e6\u7ecd\u6587|\u672a\u5b9a\u8bed\u79cd|\u4f64\u745e\u6587|\u4e39\u9ea6\u6587|\u4e2d\u53e4\u8377\u5170\u6587|\u74e6\u62c9\u83ab\u6587|\u9a6c\u8bfa\u535a\u6c61\u6587|\u74e6\u5580\u5c71\u6587|\u6851\u55d2\u5229\u6587|\u5a01\u5c14\u58eb\u6587|\u585e\u585e\u5361\u6587|\u5361\u5df4\u5c14\u8fbe\u6587|\u695a\u74e6\u4ec0\u6587|\u5b97\u6559\u65af\u62c9\u592b\u6587|\u66fc\u5c3c\u666e\u91cc\u6587|\u6377\u514b\u6587|\u8428\u739b\u5229\u4e9a\u6587|\u514b\u91cc\u65cf\u6587|\u8428\u5229\u4ec0\u6587|\u90fd\u963f\u62c9\u6587|\u79d1\u897f\u5609\u6587|\u5176\u4ed6\u5357\u7f8e\u5370\u7b2c\u5b89\u6587|\u6ee1\u6587|\u96c5\u5e93\u7279\u6587|\u5361\u5a01\u6587|\u5370\u53e4\u4ec0\u6587|\u845b\u5df4\u4e9a\u6587|\u6563\u8fbe\u7ef4\u6587|\u67e5\u83ab\u7f57\u6587|\u5176\u4ed6\u5370\u6b27\u8bed\u7cfb|\u535a\u6770\u666e\u5c14\u6587|\u4e2d\u53e4\u82f1\u6587|\u5580\u4f26\u6587|\u5370\u5ea6\u6587\uff08\u5176\u4ed6\uff09|\u8f66\u81e3\u6587|\u8fe6\u7ea6\u6587|\u52a0\u6cf0\u7f57\u5c3c\u4e9a\u6587|\u59c6\u5d29\u675c\u6587|\u53d9\u5229\u4e9a\u6587|\u5361\u59c6\u5df4\u6587|\u8482\u59c6\u897f\u4e9a\u6587|\u4e2d\u53e4\u82f1\u8bed|\u5361\u7434\u6587|\u5176\u4ed6\u9ad8\u52a0\u7d22\u8bed\u7cfb|\u5361\u6bd4\u5c14\u6587|\u5361\u62c9\u5361\u5c14\u5e15\u514b\u6587|\u6ce2\u65af\u5c3c\u4e9a\u6587|\u5df4\u52d2\u6bd4\u6587|\u5e03\u91cc\u591a\u5c3c\u6587|\u897f\u85cf\u6587|\u5b5f\u52a0\u62c9\u6587|\u73ed\u5df4\u62c9\u6587|\u52a0\u6587|\u5176\u4ed6\u4e2d\u7f8e\u5370\u7b2c\u5b89\u8bed\u7cfb|\u6bd4\u65af\u62c9\u9a6c\u6587|\u6bd4\u54c8\u5c14\u6587|\u4fdd\u52a0\u5229\u4e9a\u6587|\u767d\u4fc4\u7f57\u65af\u6587|\u5361\u591a\u6587|\u5df4\u4ec0\u5ba2\u5c14\u6587|\u7956\u9c81\u6587|\u6cfd\u7eb3\u52a0\u6587|\u666e\u7f57\u6587\u65af\u6587|\u4e0a\u7d22\u5e03\u6587|\u963f\u585e\u62dc\u7586\u6587|\u827e\u9a6c\u62c9\u6587|\u963f\u74e6\u5c14\u6587|\u963f\u8428\u59c6\u6587|\u4e0b\u585e\u5c14\u7ef4\u4e9a\u6587|\u963f\u62c9\u4f2f\u6587|\u4f0a\u6d1b\u5e72\u8bfa\u6587|\u827e\u62c9\u7c73\u7279\u6587|\u4e2d\u6587|\u5370\u5ea6\u53e4\u4ee3\u53ca\u4e2d\u4e16\u7eaa\u4e4b\u4e2d\u90e8\u53ca\u5317\u90e8\u65b9\u8a00|\u963f\u59c6\u54c8\u62c9\u6587|\u5c3c\u74e6\u5c14\u6587|\u963f\u80af\u6587|\u85cf\u6587|\u5357\u975e\u8377\u5170\u6587|\u963f\u7ef4\u65af\u5854\u6587|\u963f\u5e03\u54c8\u897f\u4e9a\u6587|\u963f\u6cd5\u6587|\u7ea6\u9c81\u5df4\u6587|\u5176\u4ed6\u963f\u5c14\u8d21\u8bed\u7cfb|\u963f\u7559\u7533\u7fa4\u5c9b\u4e4b\u571f\u8bed|\u5176\u4ed6\u8499\u5409\u8511\u6587|\u4f9d\u5730\u6587|\u5176\u4ed6\u5fb7\u62c9\u7ef4\u8bed\u7cfb|\u5317\u975e\u56de\u6559\u571f\u65cf\u4e4b\u8bed\u8a00|\u5fb7\u56fd\u5317\u90e8\u7684\u5fb7\u6587\uff1b\u4f4e\u5730\u8428\u514b\u900a\u6587|\u522b\u59c6\u5df4\u6587|\u522b\u672d\u6587|\u6258\u514b\u76ae\u8f9b\u6587";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final String variantsKeys = "REVISED";

  private static final String variantsValues = "\u5df2\u4fee\u8ba2";

  private static final Hashtable variants;
  static
  {
    variants = new Hashtable();
    Enumeration keys = new StringTokenizer(variantsKeys, "|");
    Enumeration values = new StringTokenizer(variantsValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         variants.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
    { "variants", variants },
  };

  public Object[][] getContents() { return contents; }
}
