/*
 * wmdefaults -- examine and modify Workspace Manager defaults
 * Eric P. Scott, San Francisco State University, February 1992
 *
 * Requires NeXT Software Release 2.x
 *
 * >>> beware of 1024 character limits!
 * 
 * cc -O -o wmdefaults -s -object -bsd wmdefaults.c
 */

static char sccsid[]="@(#)wmdefaults.c	1.0 (SFSU) 2/9/92";

#include <stdio.h>
#include <strings.h>
#include <pwd.h>

#define DEFAULTS_MAGIC 0x6902fcae

main(argc, argv)
int argc;
char *argv[];
{
	char *getenv();
	extern char *optarg;
	extern int optind;
	register char *p;
	register int i;
	register struct passwd *pw;
	FILE *f;
	int flags;
	char path[1024];

	flags=0;
	path[0]='\0';
	while ((i=getopt(argc, argv, "f:stu:"))!=EOF) switch (i) {
	case 'f':
		if ((flags&14)!=0) goto usage;
		flags|=8;
		(void)strcpy(path, optarg);
		break;
	case 's':
		flags|=1;
		break;
	case 't':
		if ((flags&10)!=0) goto usage;
		flags|=4;
		(void)strcpy(path, "/usr/template/user");
		break;
	case 'u':
		if ((flags&14)!=0) goto usage;
		flags|=2;
		if (!(pw=getpwnam(optarg))) {
			(void)fprintf(stderr, "%s: unknown user\n", optarg);
			exit(1);
		}
		(void)strcpy(path, pw->pw_dir);
		break;
	default:
		goto usage;
	}
	if (optind!=argc) {
	usage:
		(void)fprintf(stderr,
			"Usage: %s [-u user|-t|-f file] [-s]\n", *argv);
		(void)fputs("\t-u  user's defaults\n\t-t  newuser template\n\
\t-f  arbitrary file (use - for stdin/stdout)\n\
\t-s  install new values from stdin (DANGEROUS!)\n",
			stderr);
		exit(1);
	}
	if ((flags&14)==0&&(p=getenv("HOME"))) (void) strcpy(path, p);
	if ((flags&8)==0) {
		if ((i=strlen(path))==0||path[i-1]!='/') {
			path[i++]='/'; path[i]='\0';
		}
		if (path[0]!='/') {
			(void)fprintf(stderr, "%s: bad path\n", *argv);
			exit(1);
		}
		(void)strcat(path, ".NeXT/defaults.wmd");
	}
	if (!(flags&1)) {
		if (!strcmp(path, "-")) f=stdin;
		else if (!(f=fopen(path, "r"))) {
			perror(path);
			exit(1);
		}
		if (getw(f)!=DEFAULTS_MAGIC) {
			(void)fprintf(stderr, "%s: bad magic number\n", path);
			(void)fclose(f);
			exit(1);
		}
		while ((i=fgetc(f))!=EOF) {
			register int c;
			if (fgetc(f)!=0||fgetc(f)!=0||fgetc(f)!=0) {
			interr:
				(void)fprintf(stderr,
					"%s: internal error\n", *argv);
				(void)fclose(f);
				exit(1);
			}
			while (i>0) {
				if ((c=fgetc(f))==EOF) {
				ueof:
					(void)fprintf(stderr,
						"%s: unexpected EOF\n", *argv);
					(void)fclose(f);
					exit(1);
				}
				putchar(c);
				--i;
			}
			putchar('=');
			if ((i=fgetc(f))==EOF||(c=fgetc(f))==EOF) goto ueof;
			i|=c<<8;
			if (fgetc(f)!=0||fgetc(f)!=0) goto interr;
			putchar('"');
			while (i>0) {
				if ((c=fgetc(f))==EOF) goto ueof;
				if (c=='\\'||c=='"') putchar('\\');
				if (c>=' '&&c<='~') putchar(c);
				else if (c>='\b'&&c<='\r') {
					putchar('\\');
					putchar("btnvfr"[c-'\b']);
				}
				else (void)printf("\\%03o", c&255);
				--i;
			}
			putchar('"'); putchar('\n');
		}
	}
	else {
		char out[1024];

		if ((flags&14)==0&&getenv("Workspace")) (void)fprintf(stderr,
"%s: warning--possible conflict with running Workspace\n", *argv);
		if (!strcmp(path, "-")) f=stdout;
		else if (!(f=fopen(path, "w"))) {
			perror(path);
			exit(1);
		}
		putw(DEFAULTS_MAGIC, f);
		while (fgets(path, sizeof path, stdin)) {
			register char *q;

			if (!(p=index(path, '='))||p[1]!='"') {
			badinp:
				(void)fprintf(stderr,
					"%s: bad input:\n", *argv);
				(void)fputs(path, stderr);
				continue;
			}
			if (p-path>255) goto badinp;
			putc(p-path, f);
			putc('\0', f);
			putc('\0', f);
			putc('\0', f);
			*p='\0'; fputs(path, f); *p='=';
			q=out; *q='\0';
			for (p+=2;;) {
				if (!*p||*p=='\n') goto badinp;
				if (*p=='"') {
					if (p[1]!='\n') goto badinp;
					break;
				}
				if (*p=='\\') {
					switch (*++p) {
					case '"': case '\\':
						break;
					case '0': case '1': case '2': case '3':
					case '4': case '5': case '6': case '7':
						i=*p++-'0';
						if (*p>='0'&&*p<='7') {
							i=i*8+*p++-'0';
							if (*p>='0'&&*p<='7') {
								i=i*8+*p++-'0';
								if (i>0377)
									goto
									badinp;
							}
						}
						*q++=i;
						continue;
					case 'a':
						*q++='\007';
						p++;
						continue;
					case 'b':
						*q++='\b';
						p++;
						continue;
					case 'f':
						*q++='\f';
						p++;
						continue;
					case 'n':
						*q++='\n';
						p++;
						continue;
					case 'r':
						*q++='\r';
						p++;
						continue;
					case 't':
						*q++='\t';
						p++;
						continue;
					case 'v':
						*q++='\013';
						p++;
						continue;
					default:
						goto badinp;
					}
				}
				*q++=*p++;
			}
			putc((q-out)&255, f);
			putc(((q-out)>>8)&255, f);
			putc('\0', f);
			putc('\0', f);
			(void)fwrite(out, 1, q-out, f);
		}
	}
	(void)fclose(f);
	exit(0);
}
