\ create a documentation file

\ Copyright (C) 1995 Free Software Foundation, Inc.

\ This file is part of Gforth.

\ Gforth is free software; you can redistribute it and/or
\ modify it under the terms of the GNU General Public License
\ as published by the Free Software Foundation; either version 2
\ of the License, or (at your option) any later version.

\ This program is distributed in the hope that it will be useful,
\ but WITHOUT ANY WARRANTY; without even the implied warranty of
\ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\ GNU General Public License for more details.

\ You should have received a copy of the GNU General Public License
\ along with this program; if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


\ the stack effect of loading this file is: ( addr u -- )
\ it takes the name of the doc-file to be generated.

\ the forth source must have the following format:
\  .... name ( stack-effect ) \ wordset [pronounciation]
\ \G description ...

\ The output is a Forth source file that looks like this:
\ doc-entry name stack-effect ) wordset [pronountiation]
\ description
\
\ (i.e., the entry is terminated by an empty line or the end-of-file)

\ this stuff uses the same mechanism as etags.fs, i.e., the
\ documentation is generated during compilation using a deferred
\ HEADER. It should be possible to use this togeter with etags.fs.

\ This is not very general. Input should come from stream files,
\ otherwise the results are unpredictable. It also does not detect
\ errors in the input (e.g., if there is something else on the
\ definition line) and reacts strangely to them.

\ possible improvements: we could analyse the defining word and guess
\ the stack effect. This would be handy for variables. Unfortunately,
\ we have to look back in the input buffer; we cannot use the cfa
\ because it does not exist when header is called.

\ This is ANS Forth with the following serious environmental
\ dependences: the variable LAST must contain a pointer to the last
\ header, NAME>STRING must convert that pointer to a string, and
\ HEADER must be a deferred word that is called to create the name.


r/w create-file throw value doc-file-id
\ contains the file-id of the documentation file

s" \ automatically generated by makedoc.fs" doc-file-id write-line throw

: \G ( -- )
    source >in @ /string doc-file-id write-line throw
    source >in ! drop ; immediate

: put-doc-entry ( -- )
    locals-list @ 0=	\ not in a colon def, i.e., not a local name
    last @ 0<> and	\ not an anonymous (i.e. noname) header
    if
	s" " doc-file-id write-line throw
	s" make-doc " doc-file-id write-file throw
	last @ name>string doc-file-id write-file throw
	>in @
	[char] ( parse 2drop
	[char] ) parse doc-file-id write-file throw
	s"  )" doc-file-id write-file throw
	[char] \ parse 2drop
	POSTPONE \g
	>in !
    endif ;

: (doc-header) ( -- )
    defers header
    put-doc-entry ;

' (doc-header) IS header
