#include "globals.h"
#include "cpt.h"
#include "../machdr/machdr.h"
#include "../fileio/fileio.h"
#include "masks.h"

unsigned long get4();
unsigned short get2();
void copy();
int do_query();

int cpt_filehdr(f, hdr)
struct fileHdr *f;
char *hdr;
{
    register int i;
    int n;
    char ftype[5], fauth[5];

    for(i = 0; i < INFOBYTES; i++) {
	info[i] = '\0';
    }

    n = hdr[F_FNAME] & BYTEMASK;
    if(n > F_NAMELEN) {
	n = F_NAMELEN;
    }
    info[I_NAMEOFF] = n;
    copy(info + I_NAMEOFF + 1, hdr + F_FNAME + 1, n);
    transname(hdr + F_FNAME + 1, text, n);

    f->folder = hdr[F_FOLDER];
    if(f->folder) {
	f->foldersize = get2(hdr + F_FOLDERSIZE);
    } else {
	f->cptFlag = get2(hdr + F_CPTFLAG);
	f->rsrcLength = get4(hdr + F_RSRCLENGTH);
	f->dataLength = get4(hdr + F_DATALENGTH);
	f->compRLength = get4(hdr + F_COMPRLENGTH);
	f->compDLength = get4(hdr + F_COMPDLENGTH);
	f->fileCRC = get4(hdr + F_FILECRC);
	f->FndrFlags = get2(hdr + F_FNDRFLAGS);
	f->filepos = get4(hdr + F_FILEPOS);
	f->volume = hdr[F_VOLUME];
    }

    write_it = 1;
    if(list) {
	for(i = 0; i < indent; i++) {
	    (void) putchar(' ');
	}
	if(f->folder) {
	    printf("folder=\"%s\"", text);
	} else {
	    transname(hdr + F_FTYPE, ftype, 4);
	    transname(hdr + F_CREATOR, fauth, 4);
	    printf("name=\"%s\", type=%4.4s, author=%4.4s, data=%ld, rsrc=%ld",
		   text, ftype, fauth, f->dataLength, f->rsrcLength);
	}
	if(info_only) {
	    write_it = 0;
	}
	if(query) {
	    write_it = do_query();
	} else {
	    (void) putchar('\n');
	}
    }


    if(write_it) {
	define_name(text);

	copy(info + I_TYPEOFF, hdr + F_FTYPE, 4);
	copy(info + I_AUTHOFF, hdr + F_CREATOR, 4);
	copy(info + I_FLAGOFF, hdr + F_FNDRFLAGS, 2);
	copy(info + I_DLENOFF, hdr + F_DATALENGTH, 4);
	copy(info + I_RLENOFF, hdr + F_RSRCLENGTH, 4);
	copy(info + I_CTIMOFF, hdr + F_CREATIONDATE, 4);
	copy(info + I_MTIMOFF, hdr + F_MODDATE, 4);
    }
    return 1;
}

