#include "globals.h"
#include "cpt.h"

void cpt_uncompact();

void cpt_folder(name, fileh, cptptr)
char *name;
struct fileHdr fileh;
char *cptptr;
{
    int i, nfiles;
    char loc_name[64];
    struct fileHdr filehdr;

    for(i = 0; i < 64; i++) {
	loc_name[i] = name[i];
    }
    if(write_it || info_only) {
	cptptr += FILEHDRSIZE;
	nfiles = fileh.foldersize;
	if(write_it) {
	    do_mkdir(text);
	    (void) chdir(text);
	}
	indent++;
	for(i = 0; i < nfiles; i++) {
	    if(cpt_filehdr(&filehdr, cptptr) == -1) {
		fprintf(stderr, "Can't read file header #%d\n", i+1);
		exit(1);
	    }
	    if(filehdr.folder) {
		cpt_folder(text, filehdr, cptptr);
		i += filehdr.foldersize;
		cptptr += filehdr.foldersize * FILEHDRSIZE;
	    } else {
		cpt_uncompact(filehdr);
	    }
	    cptptr += FILEHDRSIZE;
	}
	if(write_it) {
	    (void) chdir("..");
	}
	indent--;
	if(list) {
	    for(i = 0;  i < indent; i++) {
		(void) putchar(' ');
	    }
	    printf("leaving folder \"%s\"\n", loc_name);
	}
    }
}

