#include "../fileio/fileio.h"
#include "globals.h"
#include "cpt.h"
#include "../machdr/machdr.h"
#include "crc.h"

void cpt_wrfile();

void cpt_uncompact(filehdr)
struct fileHdr filehdr;
{
    if(filehdr.cptFlag & 1) {
	fprintf(stderr, "\tFile is password protected, skipping file\n");
	return;
    }
    if(verbose) {
	printf("\tRsrc: ");
	if(filehdr.compRLength == 0) {
	    printf("empty");
	} else if(filehdr.cptFlag & 2) {
	    printf("RLE/LZH compressed (%4.1f%%)",
		    100.0 * filehdr.compRLength / filehdr.rsrcLength);
	} else {
	    printf("RLE compressed (%4.1f%%)",
		    100.0 * filehdr.compRLength / filehdr.rsrcLength);
	}
	printf(", Data: ");
	if(filehdr.compDLength == 0) {
	    printf("empty");
	} else if(filehdr.cptFlag & 4) {
	    printf("RLE/LZH compressed (%4.1f%%)",
		    100.0 * filehdr.compDLength / filehdr.dataLength);
	} else {
	    printf("RLE compressed (%4.1f%%)",
		    100.0 * filehdr.compDLength / filehdr.dataLength);
	}
	printf(".\n");
    }
    if(write_it) {
	start_info(info, filehdr.rsrcLength, filehdr.dataLength);
	cpt_crc = INIT_CRC;
	cpt_char = cpt_data + filehdr.filepos;
	start_rsrc();
	cpt_wrfile(filehdr.compRLength, filehdr.rsrcLength,
		   filehdr.cptFlag & 2);
	cpt_char = cpt_data + filehdr.filepos + filehdr.compRLength;
	start_data();
	cpt_wrfile(filehdr.compDLength, filehdr.dataLength,
		   filehdr.cptFlag & 4);
	if(filehdr.fileCRC != cpt_crc) {
	    fprintf(stderr,
		"CRC error on file: need 0x%08x, got 0x%08x\n",
		filehdr.fileCRC, cpt_crc);
	    exit(1);
	}
	end_file();
    }
}

