#include "globals.h"
#include "../machdr/machdr.h"

void pit();
void sit();
void cpt();

void macbinary()
{
    char info[INFOBYTES];

    if(fread(info, 1, INFOBYTES, infp) != INFOBYTES) {
	fprintf(stderr, "Can't read MacBinary header.\n");
	exit(1);
    }
    if(!strncmp(info + I_TYPEOFF, "PIT ", 4) &&
       !strncmp(info + I_AUTHOFF, "PIT ", 4)) {
	if(verbose) {
	    printf("This is a \"PackIt\" archive.\n");
	}
	pit();
	exit(0);
    }
    if(!strncmp(info + I_TYPEOFF, "SIT!", 4) &&
       !strncmp(info + I_AUTHOFF, "SIT!", 4)) {
	if(verbose) {
	    printf("This is a \"StuffIt\" archive.\n");
	}
	sit();
	exit(0);
    }
    if(!strncmp(info + I_TYPEOFF, "SITD", 4) &&
       !strncmp(info + I_AUTHOFF, "SIT!", 4)) {
	if(verbose) {
	    printf("This is a \"StuffIt Deluxe\" archive.\n");
	}
	sit();
	exit(0);
    }
    if(!strncmp(info + I_TYPEOFF, "APPL", 4) &&
       !strncmp(info + I_AUTHOFF, "aust", 4)) {
	if(verbose) {
	    printf("This is a \"StuffIt\" self extracting archive.\n");
	}
	sit();
	exit(0);
    }
    if(!strncmp(info + I_TYPEOFF, "PACT", 4) &&
       !strncmp(info + I_AUTHOFF, "CPCT", 4)) {
	if(verbose) {
	    printf("This is a \"Compactor\" archive.\n");
	}
	cpt();
	exit(0);
    }
    if(!strncmp(info + I_TYPEOFF, "APPL", 4) &&
       !strncmp(info + I_AUTHOFF, "EXTR", 4)) {
	if(verbose) {
	    printf("This is a \"Compactor\" self extracting archive.\n");
	}
	cpt();
	exit(0);
    }
    fprintf(stderr, "Unrecognized archive type.\n");
    exit(1);
}

