#include "globals.h"
#include "sit.h"
#include "crc.h"

unsigned long get4();
unsigned short get2();
void sit_unstuff();
void sit_folder();

void sit()
{
    struct sitHdr sithdr;
    struct fileHdr filehdr;
    int i;

    updcrc = arc_updcrc;
    crcinit = arc_crcinit;
    if(readsithdr(&sithdr) == 0) {
	fprintf(stderr, "Can't read file header\n");
	exit(1);
    }

    for(i = 0; i < sithdr.numFiles; i++) {
	if(sit_filehdr(&filehdr, 0) == -1) {
	    fprintf(stderr, "Can't read file header #%d\n", i+1);
	    exit(1);
	}
	if(!sit_valid(filehdr)) {
	    continue;
	}
	if(filehdr.compRMethod == sfolder) {
	    sit_folder(text);
	} else {
	    sit_unstuff(filehdr);
	}
    }
}

readsithdr(s)
struct sitHdr *s;
{
    char temp[SITHDRSIZE];

    if(fread(temp, 1, SITHDRSIZE, infp) != SITHDRSIZE) {
	return 0;
    }

    if(strncmp(temp + S_SIGNATURE,  "SIT!", 4) != 0 ||
	strncmp(temp + S_SIGNATURE2, "rLau", 4) != 0) {
	fprintf(stderr, "Not a StuffIt file\n");
	return 0;
    }

    s->numFiles = get2(temp + S_NUMFILES);
    s->arcLength = get4(temp + S_ARCLENGTH);

    return 1;
}

