#include "globals.h"
#include "sit.h"

void sit_skip();
void sit_unstuff();

void sit_folder(name)
char *name;
{
    int i, recurse;
    char loc_name[64];
    struct fileHdr filehdr;

    for(i = 0; i < 64; i++) {
	loc_name[i] = name[i];
    }
    if(write_it || info_only) {
	if(write_it) {
	    do_mkdir(text);
	    (void) chdir(text);
	}
	indent++;
	while(1) {
	    if(sit_filehdr(&filehdr, 0) == -1) {
		fprintf(stderr, "Can't read file header #%d\n", i+1);
		exit(1);
	    }
	    if(!sit_valid(filehdr)) {
		continue;
	    }
	    if(filehdr.compRMethod == sfolder) {
		sit_folder(text);
	    } else if(filehdr.compRMethod == efolder) {
		break;
	    } else {
		sit_unstuff(filehdr);
	    }
	}
	if(write_it) {
	    (void) chdir("..");
	}
	indent--;
	if(list) {
	    for(i = 0;  i < indent; i++) {
		(void) putchar(' ');
	    }
	    printf("leaving folder \"%s\"\n", loc_name);
	}
    } else {
	recurse = 0;
	while(1) {
	    if(sit_filehdr(&filehdr, 1) == -1) {
		fprintf(stderr, "Can't read file header #%d\n", i+1);
		exit(1);
	    }
	    if(filehdr.compRMethod == sfolder) {
		recurse++;
	    } else if(filehdr.compRMethod == efolder) {
		recurse--;
		if(recurse < 0) {
		    break;
		}
	    } else {
		sit_skip(filehdr.compRLength);
		sit_skip(filehdr.compDLength);
	    }
	}
    }
}

