#include "globals.h"
#include "sit.h"
#include "../machdr/machdr.h"
#include "../fileio/fileglob.h"
#include "../fileio/fileio.h"
#include "crc.h"

void sit_wrfile();

void sit_unstuff(filehdr)
struct fileHdr filehdr;
{
    unsigned long crc;

    if(write_it) {
	start_info(info, filehdr.rsrcLength, filehdr.dataLength);
    }
    if(verbose) {
	printf("\tRsrc: ");
    }
    if(write_it) {
	start_rsrc();
    }
    sit_wrfile(filehdr.compRLength, filehdr.rsrcLength, filehdr.compRMethod);
    if(write_it) {
	crc = (*updcrc)(INIT_CRC, out_buffer, filehdr.rsrcLength);
	if(filehdr.rsrcCRC != crc) {
	    fprintf(stderr,
		"CRC error on resource fork: need 0x%04x, got 0x%04x\n",
		filehdr.rsrcCRC, crc);
	    exit(1);
	}
    }
    if(verbose) {
	printf(", Data: ");
    }
    if(write_it) {
	start_data();
    }
    sit_wrfile(filehdr.compDLength, filehdr.dataLength, filehdr.compDMethod);
    if(write_it) {
	crc = (*updcrc)(INIT_CRC, out_buffer, filehdr.dataLength);
	if(filehdr.dataCRC != crc) {
	    fprintf(stderr,
		"CRC error on data fork: need 0x%04x, got 0x%04x\n",
		filehdr.dataCRC, crc);
	    exit(1);
	}
	end_file();
    }
    if(verbose) {
	printf(".\n");
    }
}

