#include <stdio.h>
#include "sit.h"

void sit_skip();

int sit_valid(f)
struct fileHdr f;
{
    int fr = f.compRMethod, fd = f.compDMethod;

    if(fr == sfolder || fr == efolder) {
	return 1;
    }
    if((fr & prot) || (fd & prot)) {
	fprintf(stderr, "\tFile is password protected");
    } else if(fr >= prot || fd >= prot) {
	fprintf(stderr, "\tUnknown stuffit flags: %x %x", fr, fd);
    } else if(((1 << fr) & sknown) && ((1 << fd) & sknown)) {
	return 1;
    } else {
	fprintf(stderr, "\tUnknown compression methods: %x %x", fr, fd);
    }
    fprintf(stderr, ", skipping file.\n");
    sit_skip(f.compRLength);
    sit_skip(f.compDLength);
    return 0;
}

