#include "../fileio/fileio.h"
#include "globals.h"
#include "sit.h"
#include "crc.h"
#include "masks.h"

void sit_nocomp();
void sit_rle();
void sit_lzw();
void sit_huffman();
void sit_lzah();
void sit_skip();

void sit_wrfile(ibytes, obytes, type)
unsigned long ibytes, obytes;
unsigned char type;
{
    if(ibytes == 0) {
	if(verbose) {
	    printf("empty");
	}
	return;
    }
    switch(type) {
    case nocomp:		/* no compression */
	if(verbose) {
	    printf("No compression");
	}
	if(write_it) {
	    sit_nocomp(ibytes);
	} else {
	    sit_skip(ibytes);
	}
	break;
    case rle:		/* run length encoding */
	if(verbose) {
	    printf("RLE compressed (%4.1f%%)", 100.0 * ibytes / obytes);
	}
	if(write_it) {
	    sit_rle(ibytes);
	} else {
	    sit_skip(ibytes);
	}
	break;
    case lzw:			/* LZW compression */
	if(verbose) {
	    printf("LZW compressed (%4.1f%%)", 100.0 * ibytes / obytes);
	}
	if(write_it) {
	    sit_lzw(ibytes);
	} else {
	    sit_skip(ibytes);
	}
	break;
    case huffman:		/* Huffman compression */
	if(verbose) {
	    printf("Huffman compressed (%4.1f%%)", 100.0 * ibytes / obytes);
	}
	if(write_it) {
	    sit_huffman(obytes);
	} else {
	    sit_skip(ibytes);
	}
	break;
    case lzah:			/* LZAH compression */
	if(verbose) {
	    printf("LZAH compressed (%4.1f%%)", 100.0 * ibytes / obytes);
	}
	if(write_it) {
	    sit_lzah(obytes);
	} else {
	    sit_skip(ibytes);
	}
	break;
    case fixhuf:
	fprintf(stderr, "Fixed Huffman encoding not yet implemented\n");
	exit(1);
    case bigram:
	fprintf(stderr, "Bigram encoding not yet implemented\n");
	exit(1);
    default:
	fprintf(stderr, "Unknown compression method %2x\n", type);
	exit(1);
    }
}

