;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|
==================================================================
Change log:
   06/07/90 Brad Myers - created
==================================================================
|#

(in-package "USER" :use '("LISP"))


;; check first to see if place is set
(unless (boundp 'Garnet-Gadgets-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Gadgets-PathName before loading Gadgets."))

;;; Now load the Scrolling-Input-String module
;;;
(unless (get :garnet-modules :Scrolling-Input-String)
  (format t "Loading Scrolling-Input-String...~%")
  (load (merge-pathnames "scrolling-input-string"
			 #+cmu "gadgets:"
			 #+(not cmu) Garnet-Gadgets-PathName)
	:verbose T))

(setf (get :garnet-modules :Scrolling-Input-String) t)

(format t "...Done Scrolling-Input-String.~%")
