#
# makefile ---	makefile for portable Forth environment.
#		EMX version.
#

SYSTEM=	EMX
CCANS=	gcc -m486 -Wall -ansi -pedantic
CCENV=	gcc -m486 -Wall
OPTS=	
OPTIM=	-O6 -fomit-frame-pointer
DEBUG=	-g
STRIP=	-s
LFLAGS=
LIBS=	-lvideo
TERM_O=	term-emx.o
SYS_O=	unix.o


# if you want a final optimized version uncomment these lines:
 CFLAGS =	$(OPTS) $(OPTIM) -D$(SYSTEM)
 LDFLAGS =	$(OPTS) $(STRIP) $(LFLAGS)

# if you want a version for C-level debugging uncomment these lines:
# CFLAGS =	$(OPTS) $(DEBUG) -D$(SYSTEM)
# LDFLAGS =	$(OPTS) $(DEBUG) $(LFLAGS)

# my GNU-make 3.58 for DOS needs these, probably not installed correctly.
.SUFFIXES:	.o .c
.c.o:	;	$(CC) $(CFLAGS) -c $< -o $@

#==============================================================================
# dependencies
#==============================================================================

# object files that should be clean ANSI-C:
ANSOBJ =	core.o block.o double.o xception.o facility.o file.o \
		floating.o locals.o memory.o toolkit.o search.o string.o \
		forth-83.o lpf83.o misc.o debug.o dblsub.o support.o \
		dictnry.o vocs.o lined.o term.o version.o

# object files containing environmental dependencies:
ENVOBJ =	main.o $(TERM_O) 4ed.o signals.o sysdep.o $(SYS_O) shell.o \
		yours.o

OBJECTS =	$(ANSOBJ) $(ENVOBJ)

HEADERS =	forth.h const.h types.h macros.h preload.h support.h \
		compiler.h dblsub.h term.h lined.h config.h

pfe.exe:	$(OBJECTS)
		$(CCENV) $(LDFLAGS) -o pfe.exe *.o $(LIBS) -lm
		rm version.o

CC := $(CCANS)
$(ANSOBJ):	$(HEADERS)

CC := $(CCENV)
$(ENVOBJ):	$(HEADERS)

clean:
		rm -rf pfe core *.o *~ #*#

testit:		pfe
		( cd ..; src/pfe testsuite; cd src )
