/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1994  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.7 of 15-Sep-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * curses.c ---		Terminal driver for UNIX-like systems using
 *			the curses and terminfo libraries.

unfinished, don't use it

 * (duz 17May94)
 */

#include "forth.h"
#include "term.h"

#undef TRUE
#undef FALSE

#include <limits.h>
#include <sys/ioctl.h>		/* ioctl() */
#if 0
# include <sys/termio.h>	/* TIOCGWINSZ, should be in ioctl.h */
#endif
#include <curses.h>

#define SEQ(X)	{ '\033', (Byte)((X) >> CHAR_BIT), (Byte)(X), 0 }

static Byte
rks [][4] =			/* what function keys send */
{
  SEQ (KEY_F(1)),	SEQ (KEY_F(2)),
  SEQ (KEY_F(3)),	SEQ (KEY_F(4)),
  SEQ (KEY_F(5)),	SEQ (KEY_F(6)),
  SEQ (KEY_F(7)),	SEQ (KEY_F(8)),
  SEQ (KEY_F(9)),	SEQ (KEY_F(10)),
  SEQ (KEY_LEFT),	SEQ (KEY_RIGHT),
  SEQ (KEY_UP),		SEQ (KEY_DOWN),
  SEQ (KEY_HOME),	SEQ (KEY_LL),
  SEQ (KEY_PPAGE),	SEQ (KEY_NPAGE),
  SEQ (KEY_BACKSPACE),	SEQ (KEY_DC),
  SEQ (KEY_IC),		SEQ (KEY_IC),
  SEQ (KEY_IL),		SEQ (KEY_EOL),
  SEQ (KEY_DL),		SEQ (KEY_CLEAR),
  SEQ (KEY_ENTER)
};

Byte *rawkey_string [] =
{
  rks [ 0], rks [ 1], rks [ 2], rks [ 3], rks [ 4],
  rks [ 5], rks [ 6], rks [ 7], rks [ 8], rks [ 9],
  rks [10], rks [11], rks [12], rks [13], rks [14],
  rks [15], rks [16], rks [17], rks [18], rks [19],
  rks [20], rks [21], rks [22], rks [23], rks [24],
  rks [25], rks [26]
};

void show_control_strings() {}
void show_rawkey_strings () {}

int set_interrupt_key (char ch)		{ return 0; }
void interactive_terminal (void)	{ fixterm (); }
void system_terminal (void)		{ resetterm (); }

int
prepare_terminal (void)
{
  initscr ();
  cbreak ();
  nonl ();
  noecho ();
  idlok (stdscr, TRUE);
  scrollok (stdscr, TRUE);
  meta (stdscr, TRUE);
  keypad (stdscr, TRUE);
  nodelay (stdscr, FALSE);
  saveterm ();
  refresh ();
  return 1;
}

#ifdef TIOCGWINSZ
void
query_winsize (void)
{
  struct winsize size;

  if (ioctl (1, TIOCGWINSZ, (char *)&size) >= 0)
    {
      rows = size.ws_row;
      cols = size.ws_col;
      xmax = size.ws_xpixel;
      ymax = size.ws_ypixel;
    }
}
#else
void query_winsize (void) {}
#endif

static Byte nextch [3];
static int nnext = 0;

static int
key (void)
{
  int c;

  c = getch ();
  if (c == -1)
    return 0;
  if (c < 0x100)
    nextch [nnext++] = c;
  else
    nextch [nnext++] = c,
    nextch [nnext++] = c >> CHAR_BIT,
    nextch [nnext++] = '\033';
  return 1;
}

int
keypressed (void)
{
  refresh ();
  if (nnext) return 1;
  nodelay (stdscr, TRUE);
  key ();
  nodelay (stdscr, FALSE);
  return nnext != 0;
}

int
getkey (void)
{
  refresh (); 
  if (nnext || key ())
    return nextch [--nnext];
  else
    return -1;
}

void cputc (int c)		{ addch (c); refresh (); }
void cputs (const char *s)	{ addstr ((char *)s); refresh (); }

void gotoxy (int x, int y)	{ move (y, x); }
void wherexy (int *x, int *y)	{ getyx (stdscr, *y, *x); }

static void
addxy (int x, int y)
{
  int col, row;
  getyx (stdscr, row, col);
  move (row + y, col + x);
}

void goleft (void)		{ addxy (-1,  0); }
void goright (void)		{ addxy ( 1,  0); }
void goup (void)		{ addxy ( 0, -1); }
void godown (void)		{ addxy ( 0,  1); }

void clrscr (void)		{ clear (); refresh (); }
void home (void)		{ move (0, 0); }
void clreol (void)		{ clrtoeol (); }
void clrdown (void)		{ clrtobot (); }
void bing (void)		{ beep (); }

void standout_on (void)		{ standout (); }
void standout_off (void)	{ standend (); }
void bright (void)		{ attron (A_BOLD); }
void reverse (void)		{ attron (A_REVERSE); }
void blinking (void)		{ attron (A_BLINK); }
void normal (void)		{ attrset (A_NORMAL); }
void underline_on (void)	{ attron (A_UNDERLINE); }
void underline_off (void)	{ attroff (A_UNDERLINE); }
