'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_DeleteTrace.man,v 1.2 89/03/24 14:16:08 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_DeleteTrace tcl
.BS
.SH NAME
Tcl_DeleteTrace \- remove a previously-established command trace
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
\fBTcl_DeleteTrace\fR(\fIinterp, trace\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp
.AP Tcl_Interp *interp in
Interpreter containing \fItrace\fR.
.AP Tcl_Trace trace in
Token for trace to be removed (return value from previous call
to Tcl_CreateTrace).
.BE

.SH DESCRIPTION
.PP
This procedure removes a trace, so that no future calls will be
made to the procedure associated with the trace.  After \fBTcl_DeleteTrace\fR
returns, the caller should never again use the \fItrace\fR token.

.SH KEYWORDS
delete, interpreter, trace
