/* 
 * txinfo.c --
 *
 *	This is a very simple and complete program, which will
 *	fetch termcap information and will output on standard
 *	output the shell commands necessary to setup the TERM
 *	and TERMCAP environment variables.  This program tries
 *	three places for a terminal device:
 *	1. /dev/tty (under Unix)
 *	2. the file given by the "TTY" environment variable.
 *	3. stdin and stdout.
 *
 * Copyright 1987 Regents of the University of California
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /a/newcmds/txinfo/RCS/txinfo.c,v 1.5 89/06/29 16:23:43 ouster Exp $ SPRITE (Berkeley)";
#endif not lint

#include <stdio.h>
#include <sgtty.h>

/*
 * Library imports:
 */

char *getenv();

main()
{
#define MAX_LENGTH 1000
#define MAX_AT_ONCE 200
    FILE *in, *out;
    char line[MAX_LENGTH+5];
    char errorMsg[200];
    char *p;
    struct sgttyb sgttyb;
    int flags;
    int index;

#ifndef sprite
    in = fopen("/dev/tty", "r");
    if (in != NULL) {
	out = fopen("/dev/tty", "w");
    }
#else
    in = NULL;
    out = NULL;
#endif

    if ((in == NULL) || (out == NULL)) {
	char *ttyVar;

	ttyVar = getenv("TTY");
	if (ttyVar != NULL) {
	    in = fopen(ttyVar, "r");
	    if (in != NULL) {
		out = fopen(ttyVar, "w");
	    }
	}
    }
    if ((in == NULL) || (out == NULL)) {
	in = stdin;
	out = stdout;
    }

    /*
     * Turn off echo-ing while we're talking to Tx;  otherwise the
     * stuff that Tx sends us will appear on the screen.
     */

    ioctl(fileno(in), TIOCGETP, (char *) &sgttyb);
    flags = sgttyb.sg_flags;
    sgttyb.sg_flags &= ~ECHO;
    ioctl(fileno(in), TIOCSETP, (char *) &sgttyb);
    sgttyb.sg_flags = flags;
    fputs("\33format %s {Retrieving termcap entry}\n", out);

    /*
     * Fetching the termcap entry is tricky because of line-length
     * restrictions on input for some machines:  fetch it in many
     * small pieces.
     */

    index = 0;
    while (1) {
	int sizeRequested, sizeGot;

	sizeRequested = MAX_AT_ONCE;
	if ((index+sizeRequested) > MAX_LENGTH) {
	    sizeRequested = MAX_LENGTH - index;
	}
	fprintf(out,
		"\33insert [range $termcap %d %d chars]\n\33insert \\n\n",
		index, index + sizeRequested - 1);
	/*
	 * The following code is just to enable setting a breakpoint during
	 * debugging.
	 */
	fflush(out);
	p = fgets(&line[index], sizeRequested+100, in);
	if (p == NULL)  {
	    sprintf(errorMsg, "echo Error in getting termcap info from Tx.");
	    goto error;
	}
	sizeGot = strlen(p) - 1;
	if (line[index+sizeGot] != '\n') {
	    sprintf(errorMsg,
		    "echo Tx returned too much termcap info at once.");
	    goto error;
	}
	line[index+sizeGot] = 0;
	index += sizeGot;
	if (sizeGot != sizeRequested) {
	    break;
	}
    }

    ioctl(fileno(in), TIOCSETP, (char *) &sgttyb);
    printf("setenv TERM tx; setenv TERMCAP \"%s\"\n", line);
    exit(0);

    error:
    ioctl(fileno(in), TIOCSETP, (char *) &sgttyb);
    puts(errorMsg);
    exit(1);
}
