
/*
 * $Id: misc.c,v 1.9 1993/06/16 16:31:35 wade Exp $
 *
 * $Log: misc.c,v $
 * Revision 1.9  1993/06/16  16:31:35  wade
 * conditional conference stuff
 *
 * Revision 1.9  1993/06/16  16:31:35  wade
 * conditional conference stuff
 *
 * Revision 1.8  1993/04/20  16:04:01  wade
 * added databaseButton to greybar
 *
 * Revision 1.7  1993/01/06  20:32:24  wade
 * using XtCreatePopupShell now for popups
 *
 * Revision 1.6  1993/01/06  14:01:46  wade
 * added ctype header file
 *
 * Revision 1.5  1993/01/05  22:16:12  wade
 * changed Class name of popup to Xnetlib
 *
 * Revision 1.4  1992/12/21  14:19:37  wade
 * added grey_the_button in grey_the_bar for performance
 *
 * Revision 1.3  1992/12/15  22:38:24  wade
 * improved username logging
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */


#include "xnl.h"
#include <ctype.h>	/* for isspace() */
#include <pwd.h>
#include <sys/time.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>



extern char *getenv();

int ConvertColor();

int    bgColors[6]; /* GREEN RED YELLOW WHITE BLACK  */

/* process any outstanding events and return */
soak_events()
{
	XtAppContext    context;

	context = XtWidgetToApplicationContext (toplevel);

	/* event loop */
	while (XtAppPending(context)) {
		XtAppProcessEvent (context, XtIMAll);
	}
}

set_label(w, s)
Widget w;
String s;
{
	Arg args[5];

	XtSetArg(args[0], XtNlabel, s);
	XtSetValues(w, args, 1);
}

setGas(val, max)
int val, max;
{
    Arg args[5];
    register int n;

    n=0;
    XtSetArg(args[n], XtNgasValue, val);n++;
    if (max != 0) {
        XtSetArg(args[n], XtNmaxValue, max);n++;
    }
    XtSetValues(gasgauge, args, n);
}


unsigned long what_time()
{
    static struct timeval tp;
    gettimeofday(&tp, 0);
    return (tp.tv_sec);
}

char *age2s(a)
unsigned long a;
{
    char line[255];
    int days;
    
    days = (a + (SEC_PER_DAY/2) ) / SEC_PER_DAY;
    
    if (days < 1)
      sprintf(line, "%d hours", a/ SEC_PER_HOUR);
    else if (days == 1)
      return ("1 day");
    else 
      sprintf(line, "%d days", days);
    return line;
}

lib2server(s)
char *s;
{
    char lib[255];
    register int i;
    
    /* get the first directory element of the library */
	for (i=0; s[i] == '/'; i++) ;
    strcpy(lib, s +i);
    for (i=0; (lib[i] && (lib[i] != '/')); i++) ;
    lib[i] = '\0';
    
    for (i=0; topdirServerList[i] != -1; i++) {
      if (strcmp(topdirList[i], lib) == 0) {
        return topdirServerList[i];
      }
    }


    
    printf("lib2server problem, couldn't find %s in server list index\n", lib );
    return 0;
}

set_status(s, color)
char *s;
int color;
{
    Arg args[20];
    register int n;

#ifdef DEBUG
if ((s) && (color == RED))
printf("STATUS WINDOW: %s\n", s);
#endif

    n=0;
    XtSetArg(args[n], XtNbackground, (Pixel) bgColors[color]);n++;
    if (s && strlen(s)) {
        XtSetArg(args[n], XtNlabel, s);n++;
    }
    XtSetValues(statusLabel, args, n);
}

set_netstat(s)
char *s;
{
#ifdef NETSTAT
    Arg args[5];

	XtSetArg(args[0], XtNlabel, s);
    XtSetValues(infoLabel, args, 1);

	/* I want to see this message right away */
	soak_events();
#endif
}

init_colors(w)
Widget w;
{
bgColors[WHITE] = ConvertColor(w, XtDefaultBackground);
bgColors[BLACK] = ConvertColor(w, XtDefaultForeground);
bgColors[GREEN] = app_resources.greenCol;
bgColors[RED] = app_resources.redCol;
bgColors[YELLOW] = app_resources.yellowCol;
}

Zinit_colors(w, mono, rv)
Widget w;
Boolean mono;
Boolean rv;
{

    if (rv) {
        bgColors[WHITE] = ConvertColor(w, "black");
        bgColors[BLACK] = ConvertColor(w, "white");
    } else {
        bgColors[WHITE] = ConvertColor(w, "white");
        bgColors[BLACK] = ConvertColor(w, "black");
    }

    if (mono) {
            bgColors[GREEN] = 
            bgColors[RED] = 
            bgColors[YELLOW] = bgColors[WHITE];
    } else {

        if (-1 == (bgColors[GREEN] = ConvertColor(w, app_resources.greenCol)) )
            bgColors[GREEN] = bgColors[WHITE];

        if (-1 == (bgColors[RED] = ConvertColor(w, app_resources.redCol)) )
            bgColors[RED] = bgColors[WHITE];

        if (-1 == (bgColors[YELLOW] = ConvertColor(w, app_resources.yellowCol)) )
            bgColors[YELLOW] = bgColors[WHITE];

    }

    /* if black and white can't be found give up here */
    if (    (bgColors[GREEN] == -1) || (bgColors[RED] == -1) ||
            (bgColors[YELLOW] == -1) || (bgColors[WHITE] == -1) ) {
        fprintf(stderr, "init_colors(): A serious problem, could not find white or black colors\n");
        exit(-1);
    }
}

/* ConvertColor is from the MIT Xaw examples    */
int ConvertColor(w, color_name)
Widget w;
char * color_name;
{
  XrmValue from, to;

  from.size = strlen(color_name) + 1;
  from.addr = color_name;

/*
 * This conversion accepts a colorname from rgb.txt, or a #rrrgggbbb
 * rgb color definition, or the special toolkit strings "XtDefaultForeground"
 * and "XtDefaultBackground".
 */

  XtConvert(w, XtRString, (XrmValuePtr) &from, XtRPixel, (XrmValuePtr) &to);
  if (to.addr == NULL) {
      return(-1);
  }

  return( (int) *((Pixel *) to.addr) );
}

int xtw(w, s)
Widget w;
String s;
{
/*
    Arg args[3];
    XFontStruct *font;

    XtSetArg(args[0], XtNfont, &font);
    XtGetValues(w, args, 1);


    return ( XTextWidth(font, s, strlen(s)) );
*/
    return (strlen(s) * 8);
}

add_text(w, s)
Widget w;
char *s;
{
    String ptr;
    XawTextBlock textblock;
    Arg args[4];

    textblock.firstPos = 0;
    textblock.format = FMT8BIT;
    textblock.length = strlen(s);
    textblock.ptr = s;

    XtSetArg(args[0], XtNeditType, XawtextEdit);
    XtSetValues(w, args, 1);

    XawTextReplace(w, 99999, 99999,
        &textblock);

    XawTextSetInsertionPoint(w, 99999);

    XtSetArg(args[0], XtNeditType, XawtextRead);
    XtSetValues(w, args, 1);

    if (s[ strlen(s) -1] != '\n')
        add_text(w, "\n");

    XtSetArg(args[0], XtNstring, &ptr);
    XtGetValues(w, args, 1);

}

add_text_lit(w, s)
Widget w;
char *s;
{
    XawTextBlock textblock;
    Arg args[4];

    textblock.firstPos = 0;
    textblock.format = FMT8BIT;
    textblock.length = strlen(s);
    textblock.ptr = s;

    XtSetArg(args[0], XtNeditType, XawtextEdit);
    XtSetValues(w, args, 1);

    XawTextReplace(w, 99999, 99999,
        &textblock);

    XawTextSetInsertionPoint(w, 99999);

    XtSetArg(args[0], XtNeditType, XawtextRead);
    XtSetValues(w, args, 1);

}


white_char(c)
{
    if (c == ' ')
        return 1;
    else if (c == '\n')
        return 1;
    else if (c == '\t')
        return 1;
    else if (c == '\0')
        return 1;
    else 
        return 0;
}

replace_c(s, c1, c2)
char *s;
char c1, c2;
{
    register int i = 0;

    while (s[i]) {
        if (s[i] == c1)
            s[i] = c2;
        i++;
    }
}

void
Destroy_form(widget, client_data, call_data)
Widget  widget;
XtPointer client_data, call_data;
{
    Widget popup = XtParent( (Widget) client_data);
    XtDestroyWidget(popup);
}


preen(s)
char *s;
{
    replace(s, "\n", " ");
    replace(s, "\t", "        ");
}

/* some machines don't have it so... */
char *Strstr(s1, s2)
char *s1, *s2;
{
    register int i, j;
    
  
    for (i=0; i < strlen(s1); i++) {
        for (j=0; ((s2[j] == s1[i +j]) && (j < strlen(s2))); j++)
            ;
        if (s2[j] == 0) {
            return (s1+i);
        }
    }
    return ((char*)NULL);
}


replace(line, s1, s2)
char *line, *s1, *s2;
{
    char *ptr;
    char buf[2048];

    while (ptr = (char*)Strstr(line, s1)) {
      strcpy(buf, line);
      strcpy(buf + (ptr - line), s2);
      strcpy(buf + (ptr - line) + strlen(s2), ptr + strlen(s1));
      strcpy(line, buf);
    }
}



plug_name(s, c)
char *s;
char c;
{
    register int i;
    for (i = 0; i < strlen(s); i++)
        if (s[i] == c) {
            return i;
        }

    return 0;
}





/* set state of receive button */
check_download_button()
{
    Arg args[2];

    if (SHOW_REC_ANYWAY)
        return 1;

    if (DownloadList[0]) {
        XtSetArg(args[0], XtNsensitive, True);
    } else {
        XtSetArg(args[0], XtNsensitive, False);
    }
    XtSetValues(receiveButton, args, 1);
    
    return 1;
}

/* grey in/out the button */
grey_the_button(button, state)
Widget button;
Boolean state;
{
    Arg args[2];

    XtSetArg(args[0], XtNsensitive, state);
    XtSetValues(button, args, 1);
}

/* grey in/out the top row of buttons */
grey_the_bar(state)
Boolean state;
{
    grey_the_button(helpButton, state);
    grey_the_button(indexButton, state);
    grey_the_button(libraryButton, state);
    grey_the_button(classificationButton, state);
    grey_the_button(keywordButton, state);
#ifdef CONFERENCE
    grey_the_button(databaseButton, state);
#endif
    grey_the_button(whoButton, state);
    grey_the_button(updateButton, state);
    grey_the_button(exitButton, state);
    grey_the_button(receiveButton, state);
    grey_the_button(printButton, state);
    grey_the_button(contextHelpButton, state);
    grey_the_button(newWinButton, state);
    grey_the_button(motdButton, state);

#ifdef PERFORMANCE
    grey_the_button(performanceButton, state);
#endif

    if (state)
        check_download_button();
}


int
file_is_dir(s)
char *s;
{
    char name[255];
    register int i;
    
    /* get filename part of line */
    i = 0;
    while (s[i] && (s[i] != ' ') && (s[i] != ' ')) {
        name[i] = s[i];
        i++;
    }
    name[i] = '\0';

    i = 0;
    while (List[i]) {
        if (strcmp(List[i], name) == 0) {
            return (i);
        }
        i++;
    }

    if (strncmp(s, "lib", 3) == 0)
        return 1;
    else
        return -1;
}


int
might_be_file(s)
char *s;
{
    if (strncmp(s, "file", 4) == 0)
        return 1;
    else if (strncmp(s, "lib ", 4) == 0)
        return 1;
    else if (strncmp(s, "lib\t", 4) == 0)
        return 1;
    else
        return 0;

#ifdef OLD_INDEX_STYLE
    if ((s[0] >= 'a') && (s[0] <= 'z'))
        return 1;
    else if ((s[0] >= 'A') && (s[0] <= 'Z'))
        return 1;
    else if ((s[0] >= '0') && (s[0] <= '9'))
        return 1;
    else
        return 0;
#endif
}


set_cursor(mode, w)
int mode;
Widget w;
{
    Arg args[2];

    switch (mode) {
        case CURSOR_INIT:
            busyCursor = XCreateFontCursor(XtDisplay(toplevel), 
                XC_watch);
            xtermCursor = XCreateFontCursor(XtDisplay(toplevel), 
                XC_xterm);
            XtSetArg(args[0], XtNcursor, &normalCursor);
            XtGetValues(toplevel, args, 1);
            break;
        case CURSOR_BUSY:
            if (w) {
              XtSetArg(args[0], XtNcursor, busyCursor);
              XtSetValues(w, args, 1);
            } else {
              XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel), 
                busyCursor);
            }
            break;
        case CURSOR_NORMAL_XTERM:
            if (w) {
              XtSetArg(args[0], XtNcursor, xtermCursor);
              XtSetValues(w, args, 1);
            } else {
              fprintf(stderr, "set_cursor: bogus mix, xterm cursor for toplevel\n");
            }
            break;
        case CURSOR_NORMAL:
            if (w) {
              XtSetArg(args[0], XtNcursor, normalCursor);
              XtSetValues(w, args, 1);
            } else {
              XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel), 
                normalCursor);
            }
            break;
        default:
            fprintf(stderr, "set_cursor: bogus mode %d\n", mode);
            break;
    }
}



setUsername() 
{
    struct passwd *pptr;
	char host[255];
	static char name[2550];
	struct hostent *hp;
	int i;

	if (strlen(EMAIL_ADDRESS) > 80) {
		strcpy(EMAIL_ADDRESS, "AddrTooLong");
	} else {
	  for (i=0; EMAIL_ADDRESS[i]; i++ )
		if (white_char(EMAIL_ADDRESS[i]))
			EMAIL_ADDRESS[i] = '_';
	}


    if ((pptr = getpwuid(getuid())) == NULL) {
        strcpy(username, "unknown");
    } else {
        strcpy(username, pptr->pw_name);
    }

	if ((0==gethostname(host, 250)) && (hp = gethostbyname(host))) {
		strcpy(host, hp->h_name);
		if ((0==strcmp(EMAIL_ADDRESS, "none")) || 
			(0==strcmp(EMAIL_ADDRESS, "AddrTooLong")))
		  sprintf(name, "%s@%s %s", username, host, EMAIL_ADDRESS);
		else
		  sprintf(name, "%s %s@%s", EMAIL_ADDRESS, username, host);
	}

	EMAIL_ADDRESS = name;

    return(1);
}

setBitmap(w, p)
Widget w;
Pixmap p;
{
    Arg args[2];

    XtSetArg(args[0], XtNbitmap, p);
    XtSetValues(w, args, 1);

    
}

setHome()
{
    if (getenv("HOME")) 
        strcpy(Home, getenv("HOME"));
    else
        Home[0] = '\0';
}


report(w, s)
Widget w;
String s;
{
    Arg     args[5];
    Widget  popup, dialog;
    Position    x, y;
    Dimension   width, height;
    register int n;

    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(w, args, n);
    XtTranslateCoords(w, (Position) (width / 2),
            (Position) (height / 2), &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x);         n++;
    XtSetArg(args[n], XtNy, y);     n++;

    popup = XtCreatePopupShell("report",
        transientShellWidgetClass, w, args, n);

    n = 0;
    XtSetArg(args[n], XtNlabel, s);     n++;
    dialog = XtCreateManagedWidget("reportDialog",
        dialogWidgetClass, popup, args, n);

    XawDialogAddButton(dialog, "OK", Destroy_form,
        (XtPointer) dialog);
   
    XtPopup(popup, XtGrabNone); 
}

parseServerList()
{
    register int i,j;

/*ZZZ if this is a restart then free stuff in server_list */

	/* find number of active hosts */
	i = Many_servers = 0;
	while (HostList[i]) {
		if (HostList[i][0] == '*')
			Many_servers++;
		i++;
	}

#ifdef DEBUG
	printf("Many_servers %d\n", Many_servers);
#endif

    server_list = (char**)malloc(Many_servers * sizeof(char*));

	for (j=i=0; i < Many_servers; i++,j++) {
		while (HostList[j][0] != '*')  j++;
#ifdef DEBUG
printf("added <%s>\n", HostList[j]);
#endif
		server_list[i] = XtNewString(HostList[j] +1);
	}

}


/* get line from socket, one char at a time til \n */
get_line(s, buf)
int s;
char *buf;
{
    int i, retval;

    i = -1;
    do {
        i++;
        retval = read(s, buf +i, 1);
    } while ((retval > 0) && (buf[i] != '\n'));

    while (isspace(buf[i])) i--;
    buf[i+1] = '\0';

    if (retval > 0)
        return i+1;
    else
        return 0;
}


/* commafy- convert int to char* with pretty commas in place */
char *commafy(x)
int x;
{
    static char ret[255];
    char s[255];
    register int i, j, offset;

    sprintf(s, "%d", x);

    ret[0] = '\0';

    offset = 3 - (strlen(s) % 3);

    for (i=j=0; s[i]; i++,j++) {
        if ((i) && ( ((i + offset) % 3) == 0))
            ret[j++] = ',';
        ret[j] = s[i];
    }
    ret[j] = '\0';

    return ret;
}

showFile(w, filename)
Widget w;
String filename;
{
    Widget popup, form, box, button, text;

    popup = XtVaCreatePopupShell("HotNewsFlash",
        topLevelShellWidgetClass, toplevel, 
		XtNtitle, "Hot News Flash", NULL);

    form = XtCreateManagedWidget("newWinPopupForm", panedWidgetClass,
        popup, NULL, 0);

    box = XtVaCreateManagedWidget("box", boxWidgetClass,form,
        XtNshowGrip, False, NULL);

    button = XtVaCreateManagedWidget("close", commandWidgetClass,box,
        XtNwidth, 150, NULL);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);

    text = XtVaCreateManagedWidget("text", utkasciiTextWidgetClass, form,
        XtNwidth, 400,
        XtNheight, 200,
        XtNdisplayCaret, False,
        XtNscrollVertical, XawtextScrollWhenNeeded,
        XtNscrollHorizontal, XawtextScrollWhenNeeded,
        XtNtype, XawAsciiFile,
        XtNstring, filename,
        NULL);

    XtPopup(popup, XtGrabNone);
}


