/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.resource.ResourceFinder;

public final class JavaSourceIClassLoader
extends IClassLoader {
    private static final boolean DEBUG = false;
    private final ResourceFinder sourceFinder;
    private final String optionalCharacterEncoding;
    private final Set unitCompilers;
    private UnitCompiler.ErrorHandler optionalCompileErrorHandler = null;
    private WarningHandler optionalWarningHandler = null;

    public JavaSourceIClassLoader(ResourceFinder resourceFinder, String string, Set set, IClassLoader iClassLoader) {
        super(iClassLoader);
        this.sourceFinder = resourceFinder;
        this.optionalCharacterEncoding = string;
        this.unitCompilers = set;
        super.postConstruct();
    }

    public IClass findIClass(String string) throws ClassNotFoundException {
        Object object;
        Object object2;
        String string2 = Descriptor.toClassName(string);
        if (string2.startsWith("java.")) {
            return null;
        }
        int n = string2.indexOf(36);
        String string3 = n == -1 ? string2 : string2.substring(0, n);
        Iterator iterator = this.unitCompilers.iterator();
        while (iterator.hasNext()) {
            object2 = (UnitCompiler)iterator.next();
            object = ((UnitCompiler)object2).findClass(string3);
            if (object == null) continue;
            if (!string2.equals(string3) && (object = ((UnitCompiler)object2).findClass(string2)) == null) {
                return null;
            }
            this.defineIClass((IClass)object);
            return object;
        }
        object2 = this.sourceFinder.findResource(ClassFile.getSourceResourceName(string2));
        if (object2 == null) {
            return null;
        }
        try {
            Java.CompilationUnit compilationUnit;
            object = object2.open();
            try {
                Scanner scanner = new Scanner(object2.getFileName(), (InputStream)object, this.optionalCharacterEncoding);
                scanner.setWarningHandler(this.optionalWarningHandler);
                Parser parser = new Parser(scanner);
                parser.setWarningHandler(this.optionalWarningHandler);
                compilationUnit = parser.parseCompilationUnit();
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            IClass iClass = null;
            try {
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
            UnitCompiler unitCompiler = new UnitCompiler(compilationUnit, this);
            unitCompiler.setCompileErrorHandler(this.optionalCompileErrorHandler);
            unitCompiler.setWarningHandler(this.optionalWarningHandler);
            this.unitCompilers.add(unitCompiler);
            iClass = unitCompiler.findClass(string2);
            if (iClass == null) {
                if (string2.equals(string3)) {
                    throw new Parser.ParseException("Source file \"" + object2.getFileName() + "\" does not declare class \"" + string2 + "\"", null);
                }
                return null;
            }
            this.defineIClass(iClass);
            return iClass;
        }
        catch (Scanner.ScanException scanException) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + object2 + "\"", scanException);
        }
        catch (Parser.ParseException parseException) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + object2 + "\"", parseException);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + object2 + "\"", iOException);
        }
        catch (CompileException compileException) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + object2 + "\"", compileException);
        }
    }

    public void setCompileErrorHandler(UnitCompiler.ErrorHandler errorHandler) {
        this.optionalCompileErrorHandler = errorHandler;
    }

    public void setWarningHandler(WarningHandler warningHandler) {
        this.optionalWarningHandler = warningHandler;
    }
}

