/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DecompositionIterator;
import java.text.EntryPair;
import java.text.RuleBasedCollator;
import java.util.Vector;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private DecompositionIterator text;
    private int[] buffer;
    private int expIndex;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder;
    private RuleBasedCollator ordering;

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this.ordering = ruleBasedCollator;
        if (string.length() != 0) {
            this.text = new DecompositionIterator(string, 0, string.length(), ruleBasedCollator.getDecomposition());
        }
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
        this.text.setDecomposition(this.ordering.getDecomposition());
    }

    public int next() {
        if (this.text == null) {
            return -1;
        }
        if (this.text.getDecomposition() != this.ordering.getDecomposition()) {
            this.text.setDecomposition(this.ordering.getDecomposition());
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            int n = this.swapOrder << 16;
            this.swapOrder = 0;
            return n;
        }
        char c = this.text.next();
        if (c == '\uffff') {
            return -1;
        }
        int n = this.ordering.getUnicodeOrder(c);
        if (n == RuleBasedCollator.UNMAPPED) {
            this.swapOrder = c;
            return 0x7FFF0000;
        }
        if (n < RuleBasedCollator.CHARINDEX) {
            return this.strengthOrder(n);
        }
        if (n >= RuleBasedCollator.CONTRACTCHARINDEX) {
            return this.strengthOrder(this.nextContractChar(c));
        }
        if (n >= RuleBasedCollator.EXPANDCHARINDEX) {
            this.buffer = this.ordering.getExpandValueList(c);
            this.expIndex = 0;
            return this.strengthOrder(this.buffer[this.expIndex++]);
        }
        return -1;
    }

    public static final int primaryOrder(int n) {
        return (n &= 0xFFFF0000) >>> RuleBasedCollator.PRIMARYORDERSHIFT;
    }

    public static final short secondaryOrder(int n) {
        return (short)((n &= 0xFF00) >> RuleBasedCollator.SECONDARYORDERSHIFT);
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n &= 0xFF);
    }

    static final boolean isIgnorable(int n) {
        return CollationElementIterator.primaryOrder(n) == 0;
    }

    final int strengthOrder(int n) {
        int n2 = this.ordering.getStrength();
        if (n2 == 0) {
            n &= 0xFFFF0000;
        } else if (n2 == 1) {
            n &= 0xFFFFFF00;
        }
        return n;
    }

    final void setOffset(int n) {
        if (this.text != null) {
            this.text.setOffset(n);
        }
    }

    final int getOffset() {
        if (this.text != null) {
            return this.text.getOffset();
        }
        return 0;
    }

    void setText(String string) {
        this.buffer = null;
        this.swapOrder = 0;
        if (this.text == null) {
            this.text = new DecompositionIterator(string, this.ordering.getDecomposition());
            return;
        }
        this.text.setDecomposition(this.ordering.getDecomposition());
        this.text.setText(string);
    }

    private int getEntry(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n);
            if (entryPair.entryName.equals(string)) {
                return n;
            }
            ++n;
        }
        return RuleBasedCollator.UNMAPPED;
    }

    private int nextContractChar(char c) {
        EntryPair entryPair = null;
        Vector vector = this.ordering.getContractValues(c);
        int n = 0;
        this.key.setLength(0);
        this.key.append(c);
        int n2 = 0;
        n2 = this.getEntry(vector, this.key.toString());
        if (n2 != RuleBasedCollator.UNMAPPED) {
            entryPair = (EntryPair)vector.elementAt(n2);
            n = entryPair.value;
        }
        while ((c = this.text.next()) != '\uffff') {
            this.key.append(c);
            n2 = this.getEntry(vector, this.key.toString());
            if (n2 == RuleBasedCollator.UNMAPPED) {
                c = this.text.previous();
                break;
            }
            entryPair = (EntryPair)vector.elementAt(n2);
            n = entryPair.value;
        }
        if (n - RuleBasedCollator.EXPANDCHARINDEX >= 0) {
            this.buffer = this.ordering.getExpandValueList(n - RuleBasedCollator.EXPANDCHARINDEX);
            this.expIndex = 0;
            n = this.buffer[this.expIndex++];
        }
        return n;
    }
}

