/*
 * Decompiled with CFR 0.152.
 */
package sun.net.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import sun.net.TransferProtocolClient;
import sun.net.smtp.SmtpPrintStream;
import sun.net.smtp.SmtpProtocolException;

public class SmtpClient
extends TransferProtocolClient {
    SmtpPrintStream message;

    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.closeMessage();
            this.issueCommand("QUIT\r\n", 221);
            super.closeServer();
        }
    }

    void issueCommand(String string, int n) throws IOException {
        int n2;
        this.sendServer(string);
        while ((n2 = this.readServerResponse()) != n) {
            if (n2 == 220) continue;
            throw new SmtpProtocolException(this.getResponseString());
        }
    }

    private void toCanonical(String string) throws IOException {
        this.issueCommand("rcpt to: " + string + "\r\n", 250);
    }

    public void to(String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (n5 > 0) {
                if (c == '(') {
                    ++n5;
                } else if (c == ')') {
                    --n5;
                }
                if (n5 == 0) {
                    if (n4 > n) {
                        bl = true;
                    } else {
                        n = n3 + 1;
                    }
                }
            } else if (c == '(') {
                ++n5;
            } else if (c == '<') {
                n = n4 = n3 + 1;
            } else if (c == '>') {
                bl = true;
            } else if (c == ',') {
                if (n4 > n) {
                    this.toCanonical(string.substring(n, n4));
                }
                n = n3 + 1;
                bl = false;
            } else if (c > ' ' && !bl) {
                n4 = n3 + 1;
            } else if (n == n3) {
                ++n;
            }
            ++n3;
        }
        if (n4 > n) {
            this.toCanonical(string.substring(n, n4));
        }
    }

    public void from(String string) throws IOException {
        this.issueCommand("mail from: " + string + "\r\n", 250);
    }

    private void openServer(String string) throws IOException {
        this.openServer(string, 25);
        this.issueCommand("helo " + InetAddress.getLocalHost().getHostName() + "\r\n", 250);
    }

    public PrintStream startMessage() throws IOException {
        this.issueCommand("data\r\n", 354);
        this.message = new SmtpPrintStream((OutputStream)this.serverOutput, this);
        return this.message;
    }

    void closeMessage() throws IOException {
        if (this.message != null) {
            this.message.close();
        }
    }

    public SmtpClient(String string) throws IOException {
        if (string != null) {
            try {
                this.openServer(string);
                return;
            }
            catch (Exception exception) {}
        }
        try {
            String string2 = System.getProperty("mail.host");
            if (string2 != null) {
                this.openServer(string2);
                return;
            }
        }
        catch (Exception exception) {}
        try {
            this.openServer("localhost");
            return;
        }
        catch (Exception exception) {
            this.openServer("mailhost");
            return;
        }
    }

    public SmtpClient() throws IOException {
        this(null);
    }
}

