/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.CertParseError;

class RDN {
    protected AVA[] assertion;

    RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new CertParseError("X500 RDN");
        }
        int n = 1;
        this.assertion = new AVA[n];
        int n2 = 0;
        while (n2 < n) {
            this.assertion[n2] = new AVA(derValue.data);
            ++n2;
        }
    }

    RDN(int n) {
        this.assertion = new AVA[n];
    }

    boolean equals(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n = 0;
        while (n < this.assertion.length) {
            if (!this.assertion[n].equals(rDN.assertion[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        int n = 0;
        while (n < this.assertion.length) {
            if (this.assertion[n].oid.equals(objectIdentifier)) {
                return this.assertion[n].value;
            }
            ++n;
        }
        return null;
    }

    void emit(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n = 0;
        while (n < this.assertion.length) {
            this.assertion[n].emit(derOutputStream2);
            ++n;
        }
        derOutputStream.write((byte)49, derOutputStream2);
    }

    public String toString() {
        String string = null;
        int n = 0;
        while (n < this.assertion.length) {
            string = string == null ? this.assertion[n].toString() : String.valueOf(string) + " + " + this.assertion[n];
            ++n;
        }
        return string;
    }
}

