# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    metadata: Optional[Dict[str, str]] = None,
    quota: Optional[int] = None,
    access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
    enabled_protocols: Optional[str] = None,
    root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    if quota is not None:
        _headers["x-ms-share-quota"] = _SERIALIZER.header("quota", quota, "int", minimum=1)
    if access_tier is not None:
        _headers["x-ms-access-tier"] = _SERIALIZER.header("access_tier", access_tier, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if enabled_protocols is not None:
        _headers["x-ms-enabled-protocols"] = _SERIALIZER.header("enabled_protocols", enabled_protocols, "str")
    if root_squash is not None:
        _headers["x-ms-root-squash"] = _SERIALIZER.header("root_squash", root_squash, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_properties_request(
    url: str,
    *,
    sharesnapshot: Optional[str] = None,
    timeout: Optional[int] = None,
    lease_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    url: str,
    *,
    sharesnapshot: Optional[str] = None,
    timeout: Optional[int] = None,
    delete_snapshots: Optional[Union[str, _models.DeleteSnapshotsOptionType]] = None,
    lease_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if delete_snapshots is not None:
        _headers["x-ms-delete-snapshots"] = _SERIALIZER.header("delete_snapshots", delete_snapshots, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_acquire_lease_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    duration: Optional[int] = None,
    proposed_lease_id: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
    action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "acquire"))  # type: str
    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    if duration is not None:
        _headers["x-ms-lease-duration"] = _SERIALIZER.header("duration", duration, "int")
    if proposed_lease_id is not None:
        _headers["x-ms-proposed-lease-id"] = _SERIALIZER.header("proposed_lease_id", proposed_lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_release_lease_request(
    url: str,
    *,
    lease_id: str,
    timeout: Optional[int] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
    action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "release"))  # type: str
    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_change_lease_request(
    url: str,
    *,
    lease_id: str,
    timeout: Optional[int] = None,
    proposed_lease_id: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
    action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "change"))  # type: str
    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if proposed_lease_id is not None:
        _headers["x-ms-proposed-lease-id"] = _SERIALIZER.header("proposed_lease_id", proposed_lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_renew_lease_request(
    url: str,
    *,
    lease_id: str,
    timeout: Optional[int] = None,
    sharesnapshot: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
    action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "renew"))  # type: str
    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_break_lease_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    break_period: Optional[int] = None,
    lease_id: Optional[str] = None,
    request_id_parameter: Optional[str] = None,
    sharesnapshot: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
    action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "break"))  # type: str
    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)
    if sharesnapshot is not None:
        _params["sharesnapshot"] = _SERIALIZER.query("sharesnapshot", sharesnapshot, "str")

    # Construct headers
    _headers["x-ms-lease-action"] = _SERIALIZER.header("action", action, "str")
    if break_period is not None:
        _headers["x-ms-lease-break-period"] = _SERIALIZER.header("break_period", break_period, "int")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_snapshot_request(
    url: str, *, timeout: Optional[int] = None, metadata: Optional[Dict[str, str]] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "snapshot"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_permission_request(url: str, *, timeout: Optional[int] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "filepermission"))  # type: str
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_permission_request(
    url: str, *, file_permission_key: str, timeout: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "filepermission"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-file-permission-key"] = _SERIALIZER.header("file_permission_key", file_permission_key, "str")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_properties_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    quota: Optional[int] = None,
    access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
    lease_id: Optional[str] = None,
    root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "properties"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if quota is not None:
        _headers["x-ms-share-quota"] = _SERIALIZER.header("quota", quota, "int", minimum=1)
    if access_tier is not None:
        _headers["x-ms-access-tier"] = _SERIALIZER.header("access_tier", access_tier, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if root_squash is not None:
        _headers["x-ms-root-squash"] = _SERIALIZER.header("root_squash", root_squash, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_metadata_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    metadata: Optional[Dict[str, str]] = None,
    lease_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "metadata"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    if metadata is not None:
        _headers["x-ms-meta"] = _SERIALIZER.header("metadata", metadata, "{str}")
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_access_policy_request(
    url: str, *, timeout: Optional[int] = None, lease_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "acl"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_set_access_policy_request(
    url: str, *, timeout: Optional[int] = None, lease_id: Optional[str] = None, content: Any = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "acl"))  # type: str
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, content=content, **kwargs)


def build_get_statistics_request(
    url: str, *, timeout: Optional[int] = None, lease_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "stats"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if lease_id is not None:
        _headers["x-ms-lease-id"] = _SERIALIZER.header("lease_id", lease_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_restore_request(
    url: str,
    *,
    timeout: Optional[int] = None,
    request_id_parameter: Optional[str] = None,
    deleted_share_name: Optional[str] = None,
    deleted_share_version: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
    comp = kwargs.pop("comp", _params.pop("comp", "undelete"))  # type: str
    version = kwargs.pop("version", _headers.pop("x-ms-version", "2021-12-02"))  # type: str
    accept = _headers.pop("Accept", "application/xml")

    # Construct URL
    _url = kwargs.pop("template_url", "{url}/{shareName}")
    path_format_arguments = {
        "url": _SERIALIZER.url("url", url, "str", skip_quote=True),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["restype"] = _SERIALIZER.query("restype", restype, "str")
    _params["comp"] = _SERIALIZER.query("comp", comp, "str")
    if timeout is not None:
        _params["timeout"] = _SERIALIZER.query("timeout", timeout, "int", minimum=0)

    # Construct headers
    _headers["x-ms-version"] = _SERIALIZER.header("version", version, "str")
    if request_id_parameter is not None:
        _headers["x-ms-client-request-id"] = _SERIALIZER.header("request_id_parameter", request_id_parameter, "str")
    if deleted_share_name is not None:
        _headers["x-ms-deleted-share-name"] = _SERIALIZER.header("deleted_share_name", deleted_share_name, "str")
    if deleted_share_version is not None:
        _headers["x-ms-deleted-share-version"] = _SERIALIZER.header(
            "deleted_share_version", deleted_share_version, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


class ShareOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.fileshare.AzureFileStorage`'s
        :attr:`share` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def create(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        quota: Optional[int] = None,
        access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
        enabled_protocols: Optional[str] = None,
        root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
        **kwargs: Any
    ) -> None:
        """Creates a new share under the specified account. If the share with the same name already
        exists, the operation fails.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param quota: Specifies the maximum size of the share, in gigabytes. Default value is None.
        :type quota: int
        :param access_tier: Specifies the access tier of the share. Known values are:
         "TransactionOptimized", "Hot", and "Cool". Default value is None.
        :type access_tier: str or ~azure.storage.fileshare.models.ShareAccessTier
        :param enabled_protocols: Protocols to enable on the share. Default value is None.
        :type enabled_protocols: str
        :param root_squash: Root squash to set on the share.  Only valid for NFS shares. Known values
         are: "NoRootSquash", "RootSquash", and "AllSquash". Default value is None.
        :type root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_create_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            quota=quota,
            access_tier=access_tier,
            enabled_protocols=enabled_protocols,
            root_squash=root_squash,
            restype=restype,
            version=self._config.version,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    create.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def get_properties(  # pylint: disable=inconsistent-return-statements
        self,
        sharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Returns all user-defined metadata and system properties for the specified share or share
        snapshot. The data returned does not include the share's list of files.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_properties_request(
            url=self._config.url,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            lease_id=_lease_id,
            restype=restype,
            version=self._config.version,
            template_url=self.get_properties.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-meta"] = self._deserialize("{str}", response.headers.get("x-ms-meta"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-ingress-mbps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-ingress-mbps")
        )
        response_headers["x-ms-share-provisioned-egress-mbps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-egress-mbps")
        )
        response_headers["x-ms-share-next-allowed-quota-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-quota-downgrade-time")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-lease-duration"] = self._deserialize("str", response.headers.get("x-ms-lease-duration"))
        response_headers["x-ms-lease-state"] = self._deserialize("str", response.headers.get("x-ms-lease-state"))
        response_headers["x-ms-lease-status"] = self._deserialize("str", response.headers.get("x-ms-lease-status"))
        response_headers["x-ms-access-tier"] = self._deserialize("str", response.headers.get("x-ms-access-tier"))
        response_headers["x-ms-access-tier-change-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-access-tier-change-time")
        )
        response_headers["x-ms-access-tier-transition-state"] = self._deserialize(
            "str", response.headers.get("x-ms-access-tier-transition-state")
        )
        response_headers["x-ms-enabled-protocols"] = self._deserialize(
            "str", response.headers.get("x-ms-enabled-protocols")
        )
        response_headers["x-ms-root-squash"] = self._deserialize("str", response.headers.get("x-ms-root-squash"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    get_properties.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self,
        sharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        delete_snapshots: Optional[Union[str, _models.DeleteSnapshotsOptionType]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Operation marks the specified share or share snapshot for deletion. The share or share snapshot
        and any files contained within it are later deleted during garbage collection.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param delete_snapshots: Specifies the option include to delete the base share and all of its
         snapshots. Known values are: "include" and "include-leased". Default value is None.
        :type delete_snapshots: str or ~azure.storage.fileshare.models.DeleteSnapshotsOptionType
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_delete_request(
            url=self._config.url,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            delete_snapshots=delete_snapshots,
            lease_id=_lease_id,
            restype=restype,
            version=self._config.version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def acquire_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or negative one (-1) for a
         lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease
         duration cannot be changed using renew or change. Default value is None.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "acquire". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
        action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "acquire"))  # type: str
        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_acquire_lease_request(
            url=self._config.url,
            timeout=timeout,
            duration=duration,
            proposed_lease_id=proposed_lease_id,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            template_url=self.acquire_lease.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    acquire_lease.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def release_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "release". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
        action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "release"))  # type: str
        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_release_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            template_url=self.release_lease.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    release_lease.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def change_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "change". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
        action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "change"))  # type: str
        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_change_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            proposed_lease_id=proposed_lease_id,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            template_url=self.change_lease.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    change_lease.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def renew_lease(  # pylint: disable=inconsistent-return-statements
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "renew". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
        action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "renew"))  # type: str
        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_renew_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            template_url=self.renew_lease.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    renew_lease.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def break_lease(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        break_period: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param break_period: For a break operation, proposed duration the lease should continue before
         it is broken, in seconds, between 0 and 60. This break period is only used if it is shorter
         than the time remaining on the lease. If longer, the time remaining on the lease is used. A new
         lease will not be available before the break period has expired, but the lease may be held for
         longer than the break period. If this header does not appear with a break operation, a
         fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease
         breaks immediately. Default value is None.
        :type break_period: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword comp: comp. Default value is "lease". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword action: Describes what lease action to take. Default value is "break". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype action: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp = kwargs.pop("comp", _params.pop("comp", "lease"))  # type: str
        action = kwargs.pop("action", _headers.pop("x-ms-lease-action", "break"))  # type: str
        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_break_lease_request(
            url=self._config.url,
            timeout=timeout,
            break_period=break_period,
            lease_id=_lease_id,
            request_id_parameter=request_id_parameter,
            sharesnapshot=sharesnapshot,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            template_url=self.break_lease.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-time"] = self._deserialize("int", response.headers.get("x-ms-lease-time"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    break_lease.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def create_snapshot(  # pylint: disable=inconsistent-return-statements
        self, timeout: Optional[int] = None, metadata: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """Creates a read-only snapshot of a share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "snapshot". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "snapshot"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_create_snapshot_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.create_snapshot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-snapshot"] = self._deserialize("str", response.headers.get("x-ms-snapshot"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    create_snapshot.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @overload
    def create_permission(  # pylint: disable=inconsistent-return-statements
        self,
        share_permission: _models.SharePermission,
        timeout: Optional[int] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Required.
        :type share_permission: ~azure.storage.fileshare.models.SharePermission
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "filepermission". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_permission(  # pylint: disable=inconsistent-return-statements
        self,
        share_permission: IO,
        timeout: Optional[int] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Required.
        :type share_permission: IO
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "filepermission". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_permission(  # pylint: disable=inconsistent-return-statements
        self, share_permission: Union[_models.SharePermission, IO], timeout: Optional[int] = None, **kwargs: Any
    ) -> None:
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Is either a
         model type or a IO type. Required.
        :type share_permission: ~azure.storage.fileshare.models.SharePermission or IO
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "filepermission". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype comp: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "filepermission"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(share_permission, (IO, bytes)):
            _content = share_permission
        else:
            _json = self._serialize.body(share_permission, "SharePermission")

        request = build_create_permission_request(
            url=self._config.url,
            timeout=timeout,
            restype=restype,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            json=_json,
            content=_content,
            template_url=self.create_permission.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-file-permission-key"] = self._deserialize(
            "str", response.headers.get("x-ms-file-permission-key")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)

    create_permission.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def get_permission(
        self, file_permission_key: str, timeout: Optional[int] = None, **kwargs: Any
    ) -> _models.SharePermission:
        """Returns the permission (security descriptor) for a given key.

        :param file_permission_key: Key of the permission to be set for the directory/file. Required.
        :type file_permission_key: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "filepermission". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SharePermission or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.SharePermission
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "filepermission"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SharePermission]

        request = build_get_permission_request(
            url=self._config.url,
            file_permission_key=file_permission_key,
            timeout=timeout,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.get_permission.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("SharePermission", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_permission.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def set_properties(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        quota: Optional[int] = None,
        access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
        root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Sets properties for the specified share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param quota: Specifies the maximum size of the share, in gigabytes. Default value is None.
        :type quota: int
        :param access_tier: Specifies the access tier of the share. Known values are:
         "TransactionOptimized", "Hot", and "Cool". Default value is None.
        :type access_tier: str or ~azure.storage.fileshare.models.ShareAccessTier
        :param root_squash: Root squash to set on the share.  Only valid for NFS shares. Known values
         are: "NoRootSquash", "RootSquash", and "AllSquash". Default value is None.
        :type root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "properties". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "properties"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_set_properties_request(
            url=self._config.url,
            timeout=timeout,
            quota=quota,
            access_tier=access_tier,
            lease_id=_lease_id,
            root_squash=root_squash,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.set_properties.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_properties.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def set_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        """Sets one or more user-defined name-value pairs for the specified share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "metadata". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "metadata"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_set_metadata_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            lease_id=_lease_id,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.set_metadata.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_metadata.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def get_access_policy(
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> List[_models.SignedIdentifier]:
        """Returns information about stored access policies specified on the share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "acl". Note that overriding this default value may result
         in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of SignedIdentifier or the result of cls(response)
        :rtype: list[~azure.storage.fileshare.models.SignedIdentifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "acl"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[List[_models.SignedIdentifier]]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_access_policy_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.get_access_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("[SignedIdentifier]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_access_policy.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def set_access_policy(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        share_acl: Optional[List[_models.SignedIdentifier]] = None,
        **kwargs: Any
    ) -> None:
        """Sets a stored access policy for use with shared access signatures.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :param share_acl: The ACL for the share. Default value is None.
        :type share_acl: list[~azure.storage.fileshare.models.SignedIdentifier]
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "acl". Note that overriding this default value may result
         in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "acl"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", "application/xml"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        serialization_ctxt = {"xml": {"name": "SignedIdentifiers", "wrapped": True}}
        if share_acl is not None:
            _content = self._serialize.body(
                share_acl, "[SignedIdentifier]", is_xml=True, serialization_ctxt=serialization_ctxt
            )
        else:
            _content = None

        request = build_set_access_policy_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            restype=restype,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            content=_content,
            template_url=self.set_access_policy.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_access_policy.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def get_statistics(
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> _models.ShareStats:
        """Retrieves statistics related to the share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "stats". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ShareStats or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ShareStats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "stats"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareStats]

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        request = build_get_statistics_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.get_statistics.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("ShareStats", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_statistics.metadata = {"url": "{url}/{shareName}"}  # type: ignore

    @distributed_trace
    def restore(  # pylint: disable=inconsistent-return-statements
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        deleted_share_name: Optional[str] = None,
        deleted_share_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Restores a previously deleted Share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param deleted_share_name: Specifies the name of the previously-deleted share. Default value is
         None.
        :type deleted_share_name: str
        :param deleted_share_version: Specifies the version of the previously-deleted share. Default
         value is None.
        :type deleted_share_version: str
        :keyword restype: restype. Default value is "share". Note that overriding this default value
         may result in unsupported behavior.
        :paramtype restype: str
        :keyword comp: comp. Default value is "undelete". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype comp: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype = kwargs.pop("restype", _params.pop("restype", "share"))  # type: str
        comp = kwargs.pop("comp", _params.pop("comp", "undelete"))  # type: str
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_restore_request(
            url=self._config.url,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            deleted_share_name=deleted_share_name,
            deleted_share_version=deleted_share_version,
            restype=restype,
            comp=comp,
            version=self._config.version,
            template_url=self.restore.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    restore.metadata = {"url": "{url}/{shareName}"}  # type: ignore
