/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLObject;
import adql.query.ClauseADQL;
import adql.query.constraint.ADQLConstraint;
import java.util.Vector;

public class ClauseConstraints
extends ClauseADQL<ADQLConstraint> {
    public static final String OR = "OR";
    public static final String AND = "AND";
    protected final String defaultSeparator;
    private Vector<String> vSeparators = new Vector();

    public ClauseConstraints(String name) {
        super(name);
        this.defaultSeparator = OR;
    }

    public ClauseConstraints(String name, String logicalSep) {
        super(name);
        this.defaultSeparator = ClauseConstraints.checkSeparator(logicalSep);
    }

    public ClauseConstraints(ClauseConstraints toCopy) throws Exception {
        super(toCopy);
        this.defaultSeparator = ClauseConstraints.checkSeparator(toCopy.defaultSeparator);
    }

    public final String getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public static final String checkSeparator(String sepToCheck) {
        if (sepToCheck != null && sepToCheck.equalsIgnoreCase(AND)) {
            return AND;
        }
        return OR;
    }

    @Override
    public boolean add(ADQLConstraint constraint) throws NullPointerException {
        return this.add(this.defaultSeparator, constraint);
    }

    @Override
    public void add(int index, ADQLConstraint constraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this.add(index, this.defaultSeparator, constraint);
    }

    public boolean add(String logicalSep, ADQLConstraint constraint) throws NullPointerException {
        boolean added = super.add(constraint);
        if (added && this.size() > 1) {
            this.vSeparators.add(ClauseConstraints.checkSeparator(logicalSep));
        }
        return added;
    }

    public void add(int index, String logicalSep, ADQLConstraint constraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        super.add(index, constraint);
        if (index > 0) {
            this.vSeparators.add(index - 1, ClauseConstraints.checkSeparator(logicalSep));
        }
    }

    @Override
    public ADQLConstraint set(int index, ADQLConstraint constraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        return this.set(index, null, constraint);
    }

    public ADQLConstraint set(int index, String logicalSep, ADQLConstraint constraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        ADQLConstraint replaced = super.set(index, constraint);
        if (replaced != null && logicalSep != null && index > 0) {
            this.vSeparators.set(index - 1, logicalSep);
        }
        return replaced;
    }

    @Override
    public void clear() {
        super.clear();
        this.vSeparators.clear();
    }

    @Override
    public ADQLConstraint remove(int index) throws ArrayIndexOutOfBoundsException {
        ADQLConstraint removed = (ADQLConstraint)super.remove(index);
        if (removed != null) {
            if (index > 0) {
                this.vSeparators.remove(index - 1);
            } else if (index == 0) {
                this.vSeparators.remove(index);
            }
        }
        return removed;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ClauseConstraints(this);
    }

    @Override
    public String[] getPossibleSeparators() {
        return new String[]{AND, OR};
    }

    @Override
    public String getSeparator(int index) throws ArrayIndexOutOfBoundsException {
        if (index <= 0 || index > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Impossible to get the logical separator between the item " + (index - 1) + " and " + index + "!");
        }
        return this.vSeparators.get(index - 1);
    }
}

