/* The <string.h> header contains prototypes for the string handling 
 * functions. */

#ifndef _STRING_H
#define _STRING_H

#ifndef NULL
#define NULL      (void *) 0
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;	  /* type returned by sizeof */
#endif

/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
void *memcpy(void *__s1, const void *__s2, size_t __n);
void *memmove(void *__s1, const void *__s2, size_t __n);
char *strcpy(char *__s1, const char *__s2);
char *strncpy(char *__s1, const char *__s2, size_t __n);
char *strcat(char *__s1, const char *__s2);
char *strncat(char *__s1, const char *__s2, size_t __n);
int memcmp(const void *__s1, const void *__s2, size_t __n);
int strcmp(const char *__s1, const char *__s2);
int strcoll(const char *__s1, const char *__s2);
int strncmp(const char *__s1, const char *__s2, size_t __n);
size_t strxfrm(char *__s1, const char *__s2, size_t __n);
void *memchr(const void *__s, int __c, size_t __n);
char *strchr(const char *__s, int __c);
size_t strcspn(const char *__s1, const char *__s2);
char *strpbrk(const char *__s1, const char *__s2);
char *strrchr(const char *__s, int __c);
size_t strspn(const char *__s1, const char *__s2);
char *strstr(const char *__s1, const char *__s2);
char *strtok(char *__s1, const char *__s2);
void *memset(void *__s, int __c, size_t __n);
char *strerror(int __errnum);
size_t strlen(const char *__s);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
void *memcpy();
void *memmove();
char *strcpy();
char *strncpy();
char *strcat();
char *strncat();
size_t strxfrm();
void *memchr();
char *strchr();
size_t strcspn();
char *strpbrk();
char *strrchr();
size_t strspn();
char *strstr();
char *strtok();
void *memset();
char *strerror();
size_t strlen();
#endif

#endif /* _STRING_H */
