/* The <sys/wait.h> header contains macros related to wait(). */

#define WNOHANG            1	/* do not wait for child to exit */
#define WUNTRACED          2	/* for job control; not implemented */

#define WIFEXITED(stat_val) 	(stat_val == 0)	/* true for normal exit */
#define WEXITSTATUS(stat_val)	((stat_val>>8) & 0377)	/* child's status */
#define WIFSIGNALED(stat_val)	(stat_val & 0177)	/* signal value */
#define WTERMSIG(stat_val)	(stat_val & 0177)	/* signal value */
#define WIFSTOPPED(stat_val)	0			/* job control */
#define WSTOPSIG(stat_val)	0			/* job control */


/* Declare ANSI or K&R prototypes (except when compiling kernel).*/
#ifndef _ANSI_H
#include <ansi.h>
#endif

#if _USE_ANSI_PROTOTYPES	/* function prototypes required by ANSI C */
pid_t wait(int *__stat_loc);
pid_t waitpid(pid_t __pid, int *__stat_loc, int __options);
#endif

#if _USE_OLD_PROTOTYPES		/* Kernighan and Ritchie C prototypes */
pid_t wait();
pid_t waitpid();
#endif
