--------------------------------------------------------------------
-- xwear.i  - alpha 3
-- library version 0.3
-- 0.3 (extended version of original file)
-- This version much extended to deal with layered clothing and
-- differences in clothes between the sexes by A.G. Bampton.
--------------------------------------------------------------------

-- by default all objects and actors are 'unisex' (sex 0. ). The 
-- idea is that objects set as 'sex 0.' and 'wearable.' are clothes
-- that can be worn by either sex, T-Shirts or jeans for example. 
-- Set individual objects / actors / the hero as 'male' by using
-- 'sex 1.' or female by using 'sex 2.' This prevents inappropriate
-- clothing from being worn.
-- By default nothing is 'wearable', and is referred to as 'it', by
-- setting plural for an object it will be called 'them'.
-- By default objects are not assumed to be clothing and so have no
-- 'coverage' effect, so all five 'cover' attributes are zero.
--------------------------------------------------------------------
DEFAULT ATTRIBUTES
	sex 0.

OBJECT ATTRIBUTES
	headcover 0.
	handscover 0.
	feetcover 0.
	topcover 0.
	botcover 0.
	NOT wearable.
	NOT plural.

--------------------------------------------------------------------
-- These attributes are used internally in the library - ignore! 
--------------------------------------------------------------------

ACTOR ATTRIBUTES
	tempcovered 0.
	wear_flag 0.
	
--------------------------------------------------------------------
-- A container used to provide a temporary storage space - ignore! 
--------------------------------------------------------------------

CONTAINER tempworn
	HEADER "You're already wearing"
END CONTAINER tempworn.

--------------------------------------------------------------------
-- The syntax statement for the various 'wear' verbs 
--------------------------------------------------------------------

SYNTAX 
	wear = wear (obj)
		WHERE obj ISA OBJECT
			ELSE "You can't wear that."
		put_o_on = put (obj) 'on'
		WHERE obj ISA OBJECT
			ELSE "You can't wear that." 
	put_on_o = put 'on' (obj)
		WHERE obj ISA OBJECT
			ELSE "You can't wear that." 

--------------------------------------------------------------------
-- The 'wear' verb, making various checks for 'wearable', 'worn',
-- 'takeable' and a check to make sure clothing is appropriate to 
-- the sex of the player character.
--------------------------------------------------------------------

verb wear, put_o_on, put_on_o
	CHECK obj IS wearable			
		ELSE 
			"You can't wear"
			IF obj IS named THEN
				SAY obj.
			ELSE
				"the $o"
			END IF.
			"$$." 
	AND obj NOT IN worn 
		ELSE
			"You are already wearing"
			IF obj IS named THEN
				SAY obj.
			ELSE
				"the $o"
			END IF.
			"$$." 
	AND obj IS takeable
		ELSE
			"You can't pick"
			IF obj IS named THEN
				SAY obj.
				"up." 
			ELSE
				"the $o up."
			END IF.
	AND sex OF obj = sex OF hero OR sex OF obj = 0
		ELSE
			"On second thoughts you decide"
			IF obj IS named THEN
				SAY obj.
				"really won't suit a"
				IF sex OF hero =1 THEN
					"man"
				ELSE
					"woman"
				END IF.
			ELSE
				"the $o really won't suit a"
				IF sex OF hero =1 THEN
					"man"
				ELSE
					"woman"
				END IF.
				"like you at all."
			END IF.

--------------------------------------------------------------------
-- This section will only be run if all the checks were O.K., so to
-- pass here the item MUST be an unworn, appropriate clothes item.
--------------------------------------------------------------------

	DOES

--------------------------------------------------------------------
-- 'wear_flag' is a multi-purpose flag used for several purposes in 
-- this library, here it is reset to 0 before proceeding as a matter
-- of 'housekeeping' for the code.
--------------------------------------------------------------------

	SET wear_flag OF hero TO 0.

--------------------------------------------------------------------
-- First check to see if the player is carrying the item already, if
-- not, set the 'wear_flag' to 1 to indicate the item was picked up
-- in this turn.
--------------------------------------------------------------------

	IF obj NOT IN inventory THEN
		SET wear_flag OF hero TO 1.
	END IF.
	
--------------------------------------------------------------------
--  Now see if the player can put this item on by testing 
--  all of its coverage attributes against the player's state.
--------------------------------------------------------------------

--------------------------------------------------------------------
-- First check the 'topcover' attributes, if 'obj' fails this test
-- then it means the hero is already wearing clothes that cover the
-- topcover area and those clothes are of the same layer or a layer 
-- that belongs on top of the 'obj' item. In either case it would 
-- NOT be possible to put on the 'obj'. To 'flag' this condition add
-- 5 to the 'wear_flag' attribute as an indicator this test failed.
--------------------------------------------------------------------
	IF topcover OF obj <> 0 AND topcover OF obj <= SUM OF topcover IN worn THEN
		INCREASE wear_flag OF hero BY 5.
	END IF.
	
--------------------------------------------------------------------
-- Perform a similar test for the 'handscover' attribute.
--------------------------------------------------------------------

--	IF obj IN tempworn THEN
	IF handscover OF obj <> 0 AND handscover OF obj <= SUM OF handscover IN worn THEN
		INCREASE wear_flag OF hero BY 5.
	END IF.
	
--------------------------------------------------------------------
-- Perform a similar test for the 'feetcover' attribute.
--------------------------------------------------------------------

	IF feetcover OF obj <> 0 AND feetcover OF obj <= SUM OF feetcover IN worn THEN
		INCREASE wear_flag OF hero BY 5.	
	END IF.

--------------------------------------------------------------------
-- Perform a similar test for the 'headcover' attribute.
--------------------------------------------------------------------
	
	IF headcover OF obj <> 0 AND headcover OF obj <= SUM OF headcover IN worn THEN
		INCREASE wear_flag OF hero BY 5.	
	END IF.

--------------------------------------------------------------------
--  botcover is a special case, adjust the 'tempcovered OF hero' 
--  attribute so that the code rejects non sensible options.
--  First of all, discount any coatlike clothes as these never 
--  affect ability to put on other lower body only garments.
--------------------------------------------------------------------

		SET tempcovered OF hero TO SUM OF botcover in worn.
		IF tempcovered OF hero >63 and botcover OF obj < 33 THEN 
			SET tempcovered OF hero TO tempcovered OF hero -64.
		END IF.

--------------------------------------------------------------------
-- Now discount any dress/ skirt coverall like clothes as these do 
-- not technically affect ability to put on lower body only clothes.
-- Special clause here excludes the full body coverage 'teddy' type
-- garment - as a skirt WOULD prevent that from being removed. 
-- ( dress/coat garments automatically prevent this by virtue of 
-- having higher 'topcover' settings than the teddy )
--------------------------------------------------------------------

		IF tempcovered OF hero >31 and botcover OF obj < 16 and botcover OF obj <> 4 THEN
			SET tempcovered OF hero TO tempcovered OF hero -32.
		END IF.
--------------------------------------------------------------------
-- IF tempcovered OF hero is still > 15 then must have trousers 
-- type clothing on - therefore disallow wearing dress type clothing
-- because, although technically possible, it is not very sensible. 
--------------------------------------------------------------------

		IF tempcovered OF hero >15 and botcover OF obj > 16 THEN
			SET tempcovered OF hero TO tempcovered OF hero +16.
		END IF.

--------------------------------------------------------------------
--  From here down, clothes DO work as they do for other areas.
--------------------------------------------------------------------

	IF botcover OF obj <> 0  AND botcover OF obj <= tempcovered OF hero THEN
		INCREASE wear_flag OF hero BY 5.		
	END IF.
	
--------------------------------------------------------------------
-- At this point, 'wear_flag' will be 0 if the obj was held by the
-- player and can be put on, or l if he picked it up this turn and 
-- it can be put on. Any higher value means one or more of the 
-- tests failed and the player cannot put on these clothes. 
--------------------------------------------------------------------

	IF wear_flag OF hero >1 THEN
		IF obj NOT IN inventory THEN
			"You pick up the $o.$n"
		END IF.
		LOCATE obj IN inventory.
		EMPTY worn IN tempworn.	
		LIST tempworn.
		"Trying to put " 
		IF obj IS named THEN
			SAY obj.
		ELSE
			"the $o "
		END IF.
		"on isn't very sensible.$n"
		EMPTY tempworn IN worn.
	ELSIF wear_flag OF hero = 1 THEN
		LOCATE obj IN worn.
		"You pick up the $o"
		IF obj IS plural THEN
			" and put them on.$n"
		ELSE
			" and put it on.$n"
		END IF.
	ELSE
		LOCATE obj IN worn.
		"You put on"
		IF obj IS named THEN
			SAY obj.
			".$n"
		ELSE
			"the $o.$n"
		END IF.
	END IF.

END VERB.


--------------------------------------------------------------------
-- The remove / take off verbs syntax definition.
--------------------------------------------------------------------

SYNTAX 
	remove = remove (obj)
		WHERE obj ISA OBJECT
			ELSE "You can't remove that." 
	take_o_off = take (obj) off
		WHERE obj ISA OBJECT
			ELSE "You can't remove that." 
	take_off_o = take off (obj) 
		WHERE obj ISA OBJECT
			ELSE "You can't remove that." 

--------------------------------------------------------------------
-- The remove / take off verb, including checking for legal moves.
--------------------------------------------------------------------

VERB remove, take_o_off, take_off_o
	CHECK obj IN worn
		ELSE 
			"You are not wearing"
			IF obj IS named THEN
				SAY obj.
			ELSE
				"the $o"
			END IF.
			"$$." 

--------------------------------------------------------------------
-- To pass here, the 'obj' must be an item of worn clothing.
--------------------------------------------------------------------

	DOES
	
--------------------------------------------------------------------
-- 'wear_flag' is a multi-purpose flag used for several purposes in 
-- this library, here it is reset to 0 before proceeding as a matter
-- of 'housekeeping' for the code.
--------------------------------------------------------------------

	SET wear_flag OF hero TO 0.
	
--------------------------------------------------------------------
-- Check the total 'topcover' of items worn. Because of the number
-- sequence used, by dividing the sum of the worn attributes by two 
-- and then comparing the result to the individual 'topcover' of the
-- obj in question, ( the former can only ever be greater than the 
-- latter if an article of clothing is worn that goes over 'obj' ) 
-- it's easy to tell if the obj ought to be removable. A temporary
-- attribute is used here because it needs to be manipulated. Once
-- again 'wear_flag' is used to indicate the results.
--------------------------------------------------------------------

	SET tempcovered OF hero TO SUM OF topcover IN worn /2.
	IF topcover OF obj <> 0 AND topcover OF obj < tempcovered OF hero THEN
		INCREASE wear_flag OF hero BY 1.
	END IF.
		
--------------------------------------------------------------------
-- Perform a similar test for the 'handscover' attribute.
--------------------------------------------------------------------

	SET tempcovered OF hero TO SUM OF handscover IN worn /2.
	IF handscover OF obj <> 0 AND handscover OF obj < tempcovered OF hero THEN
		INCREASE wear_flag OF hero BY 1.
	END IF.		

--------------------------------------------------------------------
-- Perform a similar test for the 'feetcover' attribute.
--------------------------------------------------------------------

	SET tempcovered OF hero TO SUM OF feetcover IN worn /2.
	IF feetcover OF obj <> 0 AND feetcover OF obj < tempcovered OF hero THEN
		INCREASE wear_flag OF hero BY 1.		
	END IF.		

--------------------------------------------------------------------
-- Perform a similar test for the 'headcover' attribute.
--------------------------------------------------------------------

	SET tempcovered OF hero TO SUM OF headcover IN worn /2.
	IF headcover OF obj <> 0 AND headcover OF obj < tempcovered OF hero THEN
		INCREASE wear_flag OF hero BY 1.
	END IF.		

--------------------------------------------------------------------
-- botcover is a special case - first discount any coatlike clothes
-- as these do not affect ability to take off other lower garments.
--------------------------------------------------------------------

	SET tempcovered OF hero TO SUM OF botcover in worn.
	IF tempcovered OF hero >63 THEN 
		SET tempcovered OF hero TO tempcovered OF hero -64.
	END IF.

--------------------------------------------------------------------
-- Now discount any dress/ skirt coverall like clothes as these do 
-- not affect ability to take off other lower garments.	The 'teddy'
-- type garment is expressly NOT included in the exclusion here.
--------------------------------------------------------------------

	IF tempcovered OF hero >31 and botcover OF obj <>4 THEN
		SET tempcovered OF hero TO tempcovered OF hero -32.
	END IF.

--------------------------------------------------------------------
-- Now process the manipulated value just as was done for the others
--------------------------------------------------------------------

	SET tempcovered OF hero TO tempcovered OF hero /2.
	IF botcover OF obj <> 0 AND botcover OF obj < tempcovered OF hero THEN
		INCREASE wear_flag OF hero BY 1.
	END IF.

--------------------------------------------------------------------
-- Depending on the value of 'wear_flag' print and process the obj
-- as needed. If 'wear_flag' is NOT 0 then the clothes cannot be 
-- removed.
--------------------------------------------------------------------

	IF wear_flag OF hero >0 THEN
		LIST worn.
		"Trying to take " 
			IF obj IS named THEN
				SAY obj.
			ELSE
				"the $o "
			END IF.
		"off isn't very sensible.$n"
	ELSE
		LOCATE obj IN inventory.
		"You take off"
		IF obj IS named THEN
			SAY obj.
		ELSE
			"the $o"
		END IF.
		"$$." 
	END IF.
END VERB.

--------------------------------------------------------------------
-- The 'undress' verb & syntax 
--------------------------------------------------------------------
SYNTAX undress = undress.

VERB undress
	DOES
		IF COUNT IN worn > 0 THEN
			EMPTY worn IN INVENTORY.
			"You remove all the items you were wearing."
		 ELSE
			"You're not wearing anything you can remove."
		END IF.
		
END VERB.
