"Jason and Medea" by Victor Gijsbers

Include Basic Help Menu by Emily Short.

Release along with cover art.

Use the serial comma.

The print final score rule is not listed in any rulebook.

When play begins:
	say "... daß der Zuschauer von Euripides auf die Bühne gebracht worden ist.[line break]       -– Friedrich Nietzsche, [italic type]Die Geburt der Tragödie[roman type], 11[paragraph break][paragraph break][bold type]First time players should type 'about'.[roman type][paragraph break][paragraph break][paragraph break]"


Section - Room and scenery

There is a room called On the street. "The stage represents the street in front of your house. Almost fourteen thousand Athenians look down on you from the ascending, semi-circular rows of seats."

The house is scenery in On the street. The description of the house is "Wealthy, but no palace.". Instead of entering the house: say "You have an argument to win first.".

The stage is scenery in On the street. Instead of examining the stage: try looking.

The fourteen thousand Athenians are scenery in On the street. They are plural-named. Instead of doing anything with the Athenians: say "You're not here to please the crowd.". Instead of examining the Athenians: say "It is evident Euripides is going to finish third again this year.". Understand "crowd" as the Athenians.

The rows of seats are scenery in On the street. Instead of doing anything with the rows of seats: say "You should focus on your quarrel with Jason." instead.



After looking for the first time:
	say "Before you can do anything, Jason addresses you in a loud voice.";
	try Jason attacking verbally instead.


Section - The actors


Jason is a man in On the street. "Jason stands before you, calm and self-possessed as ever." The description of Jason is "Your love tears you apart. You would rather die than have him know this.".

Sympathy is a number that varies. Sympathy is 0.

The choir is a person in On the street. The indefinite article is "the". "The choir of Corinthian women is waiting expectantly. They seem to be [choir-sympathy]." The description of the choir is "A large number of women has gathered to talk to you and hear your argument with Jason.".

To say choir-sympathy:
	if sympathy is less than -6:
		say "very sympathetic to Jason's cause[run paragraph on]";
	otherwise if sympathy is less than 0:
		say "somewhat sympathetic to Jason's cause[run paragraph on]";
	otherwise if sympathy is 0:
		say "neutral[run paragraph on]";
	otherwise if sympathy is less than 7:
		say "somewhat sympathetic to your cause[run paragraph on]";
	otherwise:
		say "very sympathetic to your cause[run paragraph on]".





Medea is a woman in On the street.

When play begins:
	change player to Medea;
	remove yourself from play.

The description of Medea is "You are Medea, daughter of kings.".

Instead of singing:
	say "Your hymn to Hecate comes later.".

Instead of attacking Jason:
	say "This is a time for words.".

Instead of kissing Jason:
	say "Absolutely not.".


Section - Inventory

The love letters [to Glauke ]are a thing. They are carried by Medea. The indefinite article is "some". The description of the love letters is "In these letters, intercepted and given to you by a loyal slave, Jason professes his eternal love for Glauke. 'The light of the sun is nothing compared to the faintest trace of your smile' -- that kind of thing.".

[The lock of black hair is a thing. It is carried by Medea. The description of the lock of black hair is "A lock of black hair you cut from the head of your brother Absyrtus just before you threw it into the sea. It once was the most potent symbol of your love. Now it only reminds you of what you have lost.".]


Section - Showing

A thing is either shown or not shown. Things are usually not shown.

Showing is an action applying to one thing. Understand "show [thing]" as showing.

Instead of showing something to:
	try showing the noun.
	
Carry out showing:
	say "You have little reason to exhibit [the noun].".

Instead of showing the love letters:
	if the love letters are shown:
		say "You pull out the love letters Jason wrote to Glauke. 'Yes, yes; we have seen them already', Jason he remarks irritably. Seeing that nobody is interested in reading them again, you put them back in your pocket.[paragraph break]";
	otherwise:
		if previous quip is 106:
			say "'All you do is for their safety and their profit? My friends, I here have the letters Jason wrote to his new wife. Please, peruse them and see how he talks about her beauty and her youth, how he claims that only she can make him happy. Are these the writings of a man who thinks only of his children?'[paragraph break]The women flip through the pages indignantly before returning them to you. Jason looks very uncomfortable.[paragraph break]";
			now current quip is 103;
			now previous quip is 103;
			now last talker is Medea;
			increase medea-win-bonus by 3;
			increase sympathy-at-stake by 2;
		otherwise if previous quip is 107:
			say "'You were not smitten with desire? Then how do you explain these letters I have here, with all their talk of Glauke's beauty and how you cannot wait to be with her? With all your protestations of undying love? Here, friends, look at them, and judge: are these the words of a smitten man or not?'[paragraph break]The women flip through the pages indignantly before returning them to you. 'Liar!', someone in the back shouts at Jason, who looks very uncomfortable indeed.[paragraph break]";
			now current quip is 0;
			now previous quip is 0;
			now last talker is Medea;
			increase medea-win-bonus by 4;
			increase sympathy-at-stake by 4;
			conclude the argument;
		otherwise:
			say "'I here have the letters Jason wrote to his new wife. Please, my friends, peruse them. See how he talks about her beauty and her youth, how he claims that only she can make him happy -- and judge whether there is an unluckier woman than I.'[paragraph break]The choir studies the letters with some interest, but Jason does not seem perturbed. 'As if my love for one proves that I do not love the other,' he remarks as the women return the letters to you. 'If I had married her without some show of love, [italic type]then[roman type] I would have been a villain.'[paragraph break]";
			increase medea-win-bonus by 1;
		now the love letters are shown.


Chapter - No usual conversation

Check asking someone about:
	say "Please type 'about' to learn about the conversation commands used in this piece." instead.

Check telling someone about:
	say "Please type 'about' to learn about the conversation commands used in this piece." instead.

Check answering someone that:
	say "Please type 'about' to learn about the conversation commands used in this piece." instead.

Check asking someone for:
	say "Please type 'about' to learn about the conversation commands used in this piece." instead.

Chapter - Arguing

The current arguer is a person that varies. The current arguer is Jason.
The current counter-arguer is a person that varies. The current counter-arguer is Medea.
Last talker is a person that varies.

Previous quip is a number that varies. Previous quip is 0.
[Previous counter-quip is a number that varies. Previous counter-quip is 0.]
Current quip is a number that varies. Current quip is 0. 

Argument is a kind of value.
The arguments are placeholder, how it is all your fault, your sacrifice, that you were just a tool of the gods, how you saved Jason, that Jason did it all for you, how Colchis is better than Corinth, his lust for a young wife.

Understand "sacrifice" as your sacrifice. Understand "saved" and "life" and "saved life" and "saved Jason" and "how you saved" and "you saved Jason" and "how you saved Jason" and "how I saved" and "how I saved Jason" and "I saved Jason" as how you saved Jason. Understand "lust" and "his lust" and "young" and "wife" and "young wife" and "his lust for a young wife" as his lust for a young wife. Understand "Colchis" and "Corinth" and "Colchis is better" and "better than Corinth" and "Colchis better than Corinth" and "how Colchis is better" and "Colchis is better than Corinth" and "how Colchis is better than Corinth" as how Colchis is better than Corinth.


The current argument is an argument that varies. The current argument is how it is all your fault.


A person has a list of arguments called the attacking-arguments.

The attacking-arguments of Jason is {how it is all your fault, that you were just a tool of the gods, that Jason did it all for you}.
The attacking-arguments of Medea is {[your sacrifice, ]how you saved Jason, how Colchis is better than Corinth, his lust for a young wife}.

Misarguing is an action applying to nothing. Understand "argue" and "argue about" as misarguing.

Check misarguing:
	if the attacking-arguments of the player is empty:
		say "You have exhausted your supply of arguments." instead.
		
Check misarguing:
	if the current argument is not placeholder:
		say "You cannot start a new argument until you have stopped arguing about [current argument]. While in an argument, you can attack and defend." instead.		

Carry out misarguing:
	say "To start an argument, use the 'argue about [italic type]topic[roman type]' grammar. The topics you could argue about are [attacking-arguments of Medea]."


Arguing is an action applying to one argument. Understand "argue about [argument]" and "argue [argument]" and "talk about [argument]" as arguing.

Check arguing:
	if the current argument is not placeholder:
		say "You cannot start a new argument until you have stopped arguing about [current argument]." instead.

Check arguing:
	if the attacking-arguments of the player is empty:
		say "You have exhausted your supply of arguments." instead.

Check arguing:
	if the argument understood is not listed in attacking-arguments of the player:
		say "That is not a topic you can start an argument about; you can argue about [attacking-arguments of Medea]." instead.

Carry out an actor arguing:
	now the current argument is the argument understood;
	now the current arguer is the actor;
	if the current arguer is Medea:
		now the current counter-arguer is Jason;
	if the current arguer is Jason:
		now the current counter-arguer is Medea;
		say "Jason starts a new argument: [run paragraph on]";
	now the previous quip is 0;
	now sympathy-at-stake is 2;
	try the actor attacking verbally.

Table of Arguments
Argument	Starting-quip
placeholder							0
how it is all your fault					1
your sacrifice							21
that you were just a tool of the gods		41
how you saved Jason				61
that Jason did it all for you				81
his lust for a young wife				101
how Colchis is better than Corinth			121


Stance is a kind of value. The stances are offensive, defensive and passive. A person has a stance. A person is usually offensive.


Section - Combat variables and rules

Sympathy-at-stake is a number that varies. Sympathy-at-stake is 1.
Jason-win-bonus is a number that varies. Jason-win-bonus is 0.
Medea-win-bonus is a number that varies. Medea-win-bonus is 0.
Victorious actor is a person that varies.

To say Jason-bonus:
	increase Jason-win-bonus by 1.
	
To say Medea-bonus:
	increase Medea-win-bonus by 1.	

To conclude the argument:
	[say "J: [Jason-win-bonus]; M: [Medea-win-bonus];";[test]]
	if Jason-win-bonus plus 3 is less than Medea-win-bonus:
		now victorious actor is Medea;
	otherwise if Medea-win-bonus plus 3 is less than Jason-win-bonus:
		now victorious actor is Jason;
	otherwise:
		now sympathy-at-stake is sympathy-at-stake times 3;
		now sympathy-at-stake is sympathy-at-stake divided by 5;
		decrease Medea-win-bonus by Jason-win-bonus;
		let m be a random number between -3 and 3;
		increase m by Medea-win-bonus;
		if sympathy greater than 0:
			increase m by 1;
		if sympathy less than 0:
			decrease m by 1;
		[say "rol: [m]";[test]]
		if m is greater than 0:
			now victorious actor is Medea;
		otherwise:
			now victorious actor is Jason;
	if victorious actor is Jason:
		decrease sympathy by sympathy-at-stake;
		have the choir laud Jason;
	if victorious actor is Medea:
		increase sympathy by sympathy-at-stake;
		have the choir laud Medea;
	state the choir's new sympathy;
	now score is sympathy;
	now sympathy-at-stake is 0;
	now Jason-win-bonus is 0;
	now Medea-win-bonus is 0;
	if current arguer is Jason:
		remove current argument from attacking-arguments of Jason;
	if current arguer is Medea:
		remove current argument from attacking-arguments of Medea;
	now current argument is placeholder;.

To have the choir laud Jason:
	if current argument is how it is all your fault:
		say "'He does have a point,' murmurs one of the Corinthian women.[paragraph break]'How many times did we tell Medea that she should stop cursing her betters?', asks another. 'But would she listen?'[paragraph break]";
	if current argument is how Colchis is better than Corinth:
		if sympathy-at-stake is less than two:
			say "'She's out of her mind if she cannot see how beautiful and grand our Corinth is!', says one of the women. The others nod in agreement.[paragraph break]";
		otherwise:
			say "'This city has clothed and fed her for years. Is this her gratitude?', remarks an old woman sourly. Many of her friends look either hurt or angry.[paragraph break]";
	if current argument is that you were just a tool of the gods:
		say "'It is true that we are often mere tools of the immortals,' says a woman you know to be active in the cult of Aphrodite. 'We should not attempt to usurp their fame.' The rest of the choir nods solemnly.[paragraph break]";
	if current argument is how you saved Jason:
		say "'He looks like he can take care of himself,' a young woman remarks. Her friends admire Jason's bulging muscles, and come to the same conclusion.[paragraph break]";
	if current argument is his lust for a young wife:
		say "'If Jason had been driven by base motives, our king would never have agreed to take him as his son-in-law,' opines a tall woman in the back.[paragraph break]Another nods. 'We Greeks are not motivated by pleasure, like barbarians.'[paragraph break]";
	if current argument is that Jason did it all for you:
		say "'It is clear to me that the noble lord Jason sought the best for his family. If only Medea had let herself be ruled!', exclaims one of the women. The choir murmurs approvingly.[paragraph break]".

To have the choir laud Medea:
	if current argument is how it is all your fault:
		say "'Punishing a woman for her grief... it does not sound right to me.' murmurs one of the Corinthians. Her fellow citizens agree, casting dark glances at Jason.[paragraph break]";
	if current argument is how Colchis is better than Corinth:
		say "'Home always seems like the best place in the world,' remarks a bend old woman. 'You can't expect anyone to love a foreign country.' The others nod in agreement.[paragraph break]";
	if current argument is that you were just a tool of the gods:
		say "Shouts of 'Shameless!' and 'Such ingratitude!' come from the crowd.[paragraph break]";
	if current argument is how you saved Jason:
		say "'Lord Jason, you should acknowledge the debts you owe to your friends', one of the women admonishes him.[if a random chance of 1 in 5 succeeds][paragraph break]'I wonder what kind of spear that was,' another mutters darkly.[end if][line break]";
	if current argument is his lust for a young wife:
		say "'Not only does he leave his lawful wife for younger pleasures, but he even lacks the decency to be ashamed!', someone in the middle of the choir shouts. The other women concur angrily.[paragraph break]";
	if current argument is that Jason did it all for you:
		say "'And why was living in poverty not a small price for [italic type]him[roman type]?', asks one of the women. 'Hypocrite.'[paragraph break]".

To state the choir's new sympathy:
	say "The choir is now [choir-sympathy].[line break][paragraph break]"


Chapter - Verbal Attacking

Attacking verbally is an action applying to nothing. Understand the command "attack" as something new. Understand "attack" and "attack Jason" and "a" as attacking verbally.

Check attacking verbally:
	if the current argument is placeholder:
		say "You cannot attack before starting an argument. [if the attacking-arguments of the player is empty]Unfortunately, you have exhausted your supply of arguments[otherwise]You can argue about [attacking-arguments of the player][end if]." instead.

First carry out an actor attacking verbally (this is the set the right quip rule):
	now the actor is offensive;
	if the previous quip is 0:
		choose a row with an argument of the current argument in the Table of Arguments;
		now current quip is the starting-quip entry;
	otherwise:
		choose a row with an ID of previous quip in the Table of Verbal Combat;
		now current quip is Counter entry.		

Carry out an actor attacking verbally:
	choose a row with an ID of current quip in the Table of Quips;
	say quip entry.

Carry out an actor attacking verbally:
	now previous quip is current quip.

Carry out an actor attacking verbally:
	choose a row with an ID of previous quip in the Table of Verbal Combat;
	increase sympathy-at-stake by Dam-bon entry;
	if actor is Jason:
		increase Jason-win-bonus by At-bon entry;
	if actor is Medea:
		increase Medea-win-bonus by At-bon entry.

Carry out an actor attacking verbally:
	increase Jason-win-bonus by 1;
	increase Medea-win-bonus by 1;
	increase sympathy-at-stake by 1;
	if the actor is Jason:
		increase Jason-win-bonus by 1;
	if the actor is Medea:
		increase Medea-win-bonus by 1.
		
Carry out an actor attacking verbally:
	now last talker is the actor.
		
Last carry out an actor attacking verbally:
	if the actor is the current arguer:
		choose a row with an ID of previous quip in the Table of Verbal Combat;
		if Counter entry is 0:
			conclude the argument.
		



Chapter - Defending

Defending is an action applying to nothing. Understand "defend" as defending.

Check defending:
	if the current argument is placeholder:
		say "You cannot defend before an argument has been started. [if the attacking-arguments of the player is empty]Unfortunately, you have exhausted your supply of arguments[otherwise]You can argue about [attacking-arguments of the player][end if]." instead.

First carry out an actor defending (this is the other set the right quip rule):
	now the actor is defensive;
	if the previous quip is 0:
		choose a row with an argument of the current argument in the Table of Arguments;
		now current quip is the starting-quip entry;
	otherwise:	
		choose a row with an ID of previous quip in the Table of Verbal Combat;
		now current quip is Defense entry.	

Carry out an actor defending:
	choose a row with an ID of current quip in the Table of Quips;
	say quip entry.

Carry out an actor defending:
	now previous quip is current quip.

Carry out an actor defending:
	choose a row with an ID of previous quip in the Table of Verbal Combat;
	increase sympathy-at-stake by Dam-bon entry;
	if actor is Jason:
		increase Jason-win-bonus by At-bon entry;
	if actor is Medea:
		increase Medea-win-bonus by At-bon entry.

Carry out an actor defending:
	if sympathy-at-stake is greater than 3:
		decrease sympathy-at-stake by 1.

Carry out an actor defending:
	now last talker is the actor.
		
Last carry out an actor defending:
	if the actor is the current arguer:
		choose a row with an ID of previous quip in the Table of Verbal Combat;
		if Counter entry is 0:
			conclude the argument.




Chapter - AI for Jason

Every turn:
	if last talker is Medea:
		if current argument is not placeholder:
			try Jason attacking verbally.

Every turn:
	if current argument is placeholder:
		if attacking-arguments of Jason is not empty:
			if the number of entries in attacking-arguments of Medea is not greater than the number of entries in attacking-arguments of Jason:
				sort attacking-arguments of Jason in random order;
				now current argument is entry 1 of attacking-arguments of Jason;
				try Jason arguing the current argument.

First every turn:
	follow the notify score changes rule.



Instead of waiting:
	say "[one of]'Have you lost your tongue, woman?', Jason asks.[or]Jason purses his lips. 'I thought you were so smart, but you are already out of arguments?'[or]Jason taps his foot impatiently.[at random]".



Chapter - Status

Showing status is an action out of world. Understand "status" and "stats" and "stat" as showing status.

Carry out showing status:
	if the current argument is placeholder:
		say "No argument is going on. ";
	otherwise:
		say "The current argument is about [bold type][current argument][roman type]. There is [bold type][sympathy-at-stake in words][roman type] sympathy at stake. Jason has a bonus of [bold type][Jason-win-bonus in words][roman type], while Medea has a bonus of [bold type][Medea-win-bonus in words][roman type].[paragraph break]";
	say "The choir's current sympathy is [bold type][sympathy in words][roman type]. (Positive numbers are in favour of Medea, negative numbers in favour of Jason.)".




Chapter - Ending the game

First every turn:
	check whether the game ends.
	
Last every turn:
	check whether the game ends.

To check whether the game ends:
	if sympathy is greater than 10:
		say "The crowd shouts abuse at Jason. He opens his mouth to calm them with cool eloquence, but they drown his words with their angry clamour. At last, he is forced to retreat, his head bright red with shame.";
		end the game saying "The choir loves you!";
	otherwise if sympathy is less than -10:
		say "The crowd shouts abuse at you. You open your mouth to deliver an impassioned plea, but they drown your words with their angry clamour. There is nothing you can do but retreat back into the house.";
		end the game saying "Now you are truly friendless.";
	otherwise if attacking-arguments of Jason is empty:
		if sympathy is greater than 0:
			say "'That is all I had to say,' states Jason. 'If you do not wish to see reason, I cannot force to you.' As he walks away, the choir hisses at him.";
			end the game saying "You have won their sympathy.";
		if sympathy is less than 0:
			say "'That is all I had to say,' states Jason. 'If you do not wish to see reason, I cannot force to you.' As he walks away, the choir follows him, casting disdainful glances back at you.";
			end the game saying "You have lost their sympathy.";
		if sympathy is 0:
			say "'That is all I had to say,' states Jason. 'If you do not wish to see reason, I cannot force to you.' As he walks away, you look at the crowd for support -- but it seems they still have not made up their mind.";
			end the game saying "The matter remains undecided.".






Section - J It is your own fault




Table of Quips
ID	Quip
1	"'Not for the first time do I see that a harsh temper can ruin a man -- or a woman. You, had you but patiently endured the will of your superiors, could have remained here in this land and house. But now for your idle words you will be banished!'[paragraph break]"
2	"[if Medea is offensive]Jason does not budge. 'Cease not to call Jason the basest of men! I still will seek the best for you. [otherwise]The lines in Jason's brow soften. 'So you are calming down at last? I wish that you had done so sooner. [end if]Think back on the words you spoke against our rulers, and you will see it is pure gain that exile is your only punishment. I did all I could to check the outbursts of the angry king, who was calling for your death. He finally agreed to do no more than banish you.'[paragraph break]"
3	"'[if Medea is defensive]Impossible! His mind has been made up. Truly, [otherwise]In time, you will see that exile is preferable to death. What is more, [end if]I did all I could to save you from banishment. It is your own temper that has ruined you.' Jason looks at the choir for approval.[paragraph break]"
4	"'You are right: my temper got the best of me, and I said things I should not have. But is that a reason to exile me? Women will always be ruled by their emotions. Banish all who are unreasonable when grief strikes them, and never will a child again be born in Corinth!'[paragraph break]The choir nods in agreement. 'It is true,' remarks an older woman. 'Even the great wife of Zeus is known for jealous fits.'[paragraph break]"
5	"You confront Jason. 'How dare you come here and insult me! It is no proof of courage or hardihood to confront your friends after injuring them, Jason. It is that worst of all human diseases -- loss of shame.'[paragraph break]"
6	"'You speak about my words as if it matters what a woman mad with grief exclaims. When passion carries us along, we all speak words we do not mean. Go tell the king I never meant him harm.'[paragraph break]"
7	"'No more than banish me? Alone, with two small children, cast out into a friendless world? If that is our ruler's mercy, I would he let his wrath descend on me!'[paragraph break]"

Table of Verbal Combat
ID	Defense	Counter	At-bon	Dam-bon
1	4		5		0		0
2	6		7		0		0
3	0		0		0		0
4	2		2		0		-1		
5	2		2		0		0
6	3		3		0		0
7	3		3		0		0



[
Section - M I sacrificed everything for you


Table of Quips (continued)
ID	Quip
21	"Att1."
22	"Def2."
23	"Att2."
24	"Def3."
25	"Att3."
26	"Jas1."
27	"Jas2."


Table of Verbal Combat (continued)
ID	Defense	Counter	At-bon	Dam-bon
21	26		26		0		0
22	27		27		0		0
23	27		27		0		0
24	0		0		0		0		
25	0		0		0		0
26	22		23		0		0
27	24		25		0		0]




Section - J The Gods helped me, not you



Table of Quips (continued)
ID	Quip
41	"'It is well known that you helped me when I set out to gain the golden fleece. But it is my firm belief that to Cypri, alone of gods or men, I owe the safety of my voyage.'[paragraph break]"
42	"'It were a hateful thing for me to say that the Love-god, instructed by his mother, forced you by his resistless shaft to save my life -- but it is true. However, I will not reckon this too nicely; it was kindly done, and I am grateful, even if someone else was acting through you.'[paragraph break]"
43	"'The fact remains that it is the Cytherean goddess who helped me, and that it is to her that my eternal gratitude must be directed.'[paragraph break]"
44	"'It is true that the great goddess Aphrodite smiled upon your undertaking. But why would you deny that your friends were great helps as well -- mighty Heracles; young Nestor; Castor and Pollux, those divine brothers; and, yes, in her small way your own Medea?'[paragraph break]"
45	"'So you took Heracles and Nestor, Castor and Pollux, and all the finest heroes in the lands along... not for help, but just for company? And when you made pretty faces to me, and seduced me with sweet words, and finally convinced me to help you get the golden fleece -- a decision I will always rue! -- you were just being nice?'[paragraph break]"
46	"'Deep down in my maiden's bosom burned his arrow like a flame, and my soul... melted, in pain and rapture as I contemplated the image of Jason. Love the Destroyer had found me and blazed around my heart; my mind's keen anguish now flushed my soft cheeks, now drained them of all color...'. Tears fall from your eyes.[paragraph break]"
47	"'Truly your shamelessness is without limits. Will you also blame your own lack of faith on Aphrodite? But you had better be careful. Perhaps the next god who will choose to act through me is Nemesis.'[paragraph break]"

Table of Verbal Combat (continued)
ID	Defense	Counter	At-bon	Dam-bon
41	44		45		0		0
42	46		47		0		0
43	0		0		0		0
44	42		42		0		0		
45	42		42		0		0
46	43		43		2		-1
47	43		43		0		0




Section - M I saved your life

Table of Quips (continued)
ID	Quip
61	"'I saved your life, Jason, as every Hellene knows who sailed with us aboard the good ship Argo. When you were sent to tame and yoke fire-breathing bulls, and to sow the deadly earth -- [italic type]I[roman type] saved you.'[paragraph break]"
62	"'Jason, I do not doubt your prowess. But remember: I slew the dragon which guarded the golden fleece, keeping sleepless watch over it with many a wreathed coil. When Pelias tried to cheat you of your throne, it was [italic type]I[roman type] that caused his death by a doom most grievous, yes, even by his own children's hand. Can you be sure you would have succeeded everywhere without me?'[paragraph break]"
63	"'You boastful windbag! I slew the dragon which guarded the golden fleece, keeping sleepless watch over it with many a wreathed coil. How would you have defeated it alone? When Pelias tried to cheat you of your throne, you could think of no solution; it was [italic type]I[roman type] that caused his death by a doom most grievous, yes, even by his own children's hand. You could have done that too?'[paragraph break]"
64	"'Brave deeds, Jason. Think of them, think of the honour you have gained through them, and think of how much you therefore stand to lose when you break the heavy oaths you swore to me! Surely you do not believe that the gods of old no longer rule to punish, or that fresh decrees are now in vogue amongst mankind?'[paragraph break]"
65	"'All this have I done for you, you traitor! and you have cast me over, taking to yourself another wife, though children have been born to us... I cannot even understand whether you think that the gods of old no longer rule to punish oath-breaking, or that fresh decrees are now in vogue amongst mankind.'[paragraph break]"
66	"'I will not deny that your little tricks of sorcery were of some help against those bulls and skeletons, yes. But as to saving my life... Jason does not succumb easily. No doubt I would have conquered even without your help.'[paragraph break]"
67	"'[if Medea is offensive]And did I not perform many deeds of heroism before the Argo ever reached cursed Colchis?[otherwise]Well, I did perform many deeds of heroism before the Argo ever reached your home city of Colchis.[end if] Like, like... killing Amycus in a boxing match, defeating the bird of Ares, and, and... uhm, I conquered Hypsipyle with my bronze-tipped spear.' Jason looks around nervously.[paragraph break]"


Table of Verbal Combat (continued)
ID	Defense	Counter	At-bon	Dam-bon
61	66		66		0		0
62	67		67		0		0
63	67		67		0		0
64	0		0		0		0		
65	0		0		0		0
66	62		63		0		0
67	64		65		-2		0




Section - J I do it all for you

Table of Quips (continued)
ID	Quip
81	"'I have always had our best interests in mind, Medea. I have sought union with the princess so that we -- and this is most important -- may dwell in comfort, instead of suffering want; for well I know that every former friend avoids the poor.'[paragraph break]"
82	"'[if his lust for a young wife is listed in attacking-arguments of Medea]I was seeking honour for our children; for my aim was but[otherwise]I have already said that I was thinking of our children, and my aim was but[end if] to rear my sons as does befit my house. And further, that I might father brothers for these children you have borne, and thereby raise our heirs to the same high rank of princes, uniting the two families in one -- to all our lasting bliss.'[paragraph break]"
83	"'You still profit well enough from our association, woman: all the Hellenes recognize your cleverness, and you have gained a name; whereas, if you had dwelt upon the confines of the earth, no tongue had mentioned you. In my opinion, nothing is greater than such fame, and exile a small price for it.'[paragraph break]"
84	"'We did live friendless and in poverty -- that much I grant. But how will it help our children if their father marries a princess, and leaves their mother and themselves behind? Even if the king had not banished us, I cannot see how they would profit from your plans.'[paragraph break]"
85	"'So to get rich you broke your vows? And you are trying to appease me by telling me you lusted after gold, and believed attracting sycophants was more important than caring for your family?'[paragraph break]"
86	"'Of you and of our children -- perhaps! But look at me, alone, rejected and forever shamed. Whoever sings your praise will laugh at my misfortune.'[paragraph break]"
87	"'How noble does that sounds, Jason; and also, how naive. I expect the future kings would love their older brothers dearly, and not see them as rivals? And their new mother will love my sons as if they were their own? Sweet fantasies -- but such is not the way of men. And for your fantasies, my life now lies in ruins!'[paragraph break]"

Table of Verbal Combat (continued)
ID	Defense	Counter	At-bon	Dam-bon
81	84		85		0		0
82	86		87		0		0
83	0		0		0		0
84	82		82		0		0		
85	82		82		0		0
86	83		83		0		0
87	83		83		0		0




Section - M You just want a young wife


Table of Quips (continued)
ID	Quip
101	"'You have found yourself a nice young wife, and now you have come to justify your base lust with grand words. A child could see the truth behind your lies[if letters are shown], even if those disgusting letters were no further proof[end if].'[paragraph break]"
102	"'I understand your reasons, although I wish you would have shared them sooner. But surely you must see that it is hard for a wife to believe that, when her husband marries another, he has not stopped loving her?'[paragraph break]"
103	"'Our fortune? You advanced our fortune by having us cast out of the city while you enjoy your marriage night with a sixteen-year-old girl?'[paragraph break]"
104	"'Why didn't you tell me so before? Now all your plans are ruined, because the king no longer loves us! You acted for our children's safety, but they will die as beggars.' You bury your face in your hands.[paragraph break]"
105	"'Had you not had a villain's heart, you should have gained my consent, then made this match, instead of hiding it from those who loved you.'[paragraph break]"
106	"'And yet what I speak is true. Since I fled from Iolcos with many a hopeless trouble at my back, what happier device could I, unhappy exile, frame than marriage with the daughter of the king? It was the only way I could advance your fortune, and mine, and most especially that of our children. All I do, I do for their safety and their profit.'[paragraph break]"
107	"'Truly, it is not because I loathe you for my wife; and not because I am smitten with desire for a new bride. It was not for the woman's sake I wedded the king's daughter; but, as I have already told you, I wished to insure our children's safety and to be the father of royal sons bound by blood to our own -- a bulwark to our house.'[paragraph break]"


Table of Verbal Combat (continued)
ID	Defense	Counter	At-bon	Dam-bon
101	106		106		0		0
102	107		107		0		0
103	107		107		0		0
104	0		0		0		-1		
105	0		0		1		0
106	102		103		0		0
107	104		105		0		0


Section - M Colchis better than Corinth
	
Table of Quips (continued)
ID	Quip
121	"'And to think that I left the beautiful city of Colchis to follow you to this miserable place, this mud-built city of Corinth! You told me your country was the most beautiful in the world. Quite! A serving woman in my father's palace has more jewels than a princess in Greece.'[paragraph break]The choir grumbles: they resent your criticism of their city.[paragraph break]"
122	"'I will admit it: I did love Greece for the virtues that you mention. But no longer. My banishment has taught me that gold, not justice, is a woman's friend.'[paragraph break]"
123	"'Would any farmer in the world trade the fertile soil that feeds his children for just laws and a piece of barren Hellas? I think not, Jason. And you speak of freedom? I have seen what freedom means: continuous war against one's neighbours.'[paragraph break]"
124	"'Oh Gods, bear witness! Have I not tried to be a Greek? Banished from home and taken to a foreign country, have I not tried to learn and to adapt? But not a second home is Corinth to me -- alas, it casts me out!'[paragraph break]"
125	"'I see you will not stop flattering your countrymen. But know this, Jason: three thousand years from now, the fame of Asia's empires will still be sung across the world; and Greece will be forgotten!'[paragraph break]"
126	"'Aren't you all the same, you Asians?' Jason asks. 'Gold and comfort -- that is all you think about. This is Hellas, woman, a country of free men, where you have seen what justice means and how to live by law, not by the dictates of brute force.'[paragraph break]"
127	"'If only you had had a noble mind, Medea, you would have shown a better appreciation of our ways. A true Greek would rather die than lose his freedom.'[paragraph break]"


Table of Verbal Combat (continued)
ID	Defense	Counter	At-bon	Dam-bon
121	126		126		-2		1
122	127		127		0		0
123	127		127		-1		0
124	0		0		1		-1		
125	0		0		-1		0
126	122		123		0		0
127	124		125		0		0




Section - Help

The help request rule is not listed in any rulebook.

Carry out asking for help:
	now the current menu is the Table of Jason Help;
	carry out the displaying activity;
	clear the screen;
	if previous quip is not 0 and current argument is not placeholder:
		choose a row with an ID of current quip in the Table of Quips;
		say "[italic type]You recall Jason's last words...[roman type][paragraph break][quip entry]";
	otherwise:
		try looking.	
	
	

Table of Jason Help
title		subtable		description		toggle
"The Demo"	--	"[italic type]Jason and Medea[roman type] was written as an interactive fiction demo for the IF Demo Fair at PAX East 2011. I wanted to look at 'novel ways to interact with in-game characters', specifically, at ways to treat conversation as combat.[paragraph break]Using a combination of simple topic selection, combat commands, and randomisation that can be influenced through tactics and puzzle solving, [italic type]Jason and Medea[roman type] presents what is either a new or at least an underexplored mode of conversation."	--
"The Story"	--	"Since the game starts [italic type]in media res[roman type], a little background may help the player who is unfamiliar with the source material.[paragraph break]You play Medea, an Asian princess who helped the Greek hero Jason to get the golden fleece. Since her father was the previous owner, she had to leave her city with Jason -- but she would have done so anyway, being madly in love with him. Unfortunately for Jason, his uncle Pelias did not give him the throne of Iolcos when he returned with the golden fleece. Medea killed Pelias, but she and Jason had to flee the city and sought refuge in Corinth.[paragraph break]Our game starts when Medea has learned that Jason plans to leave her and marry the princess of Corinth. Half-mad with anger, she has threatened to destroy him and his bride. The king of Corinth takes this threat very seriously, and has decided to banish Medea and the two children she has borne to Jason. Medea is, understandably, upset.[paragraph break]Now Jason has come to justify himself. It is up to you to gain the sympathy of the women of Corinth."	--
"The Commands"	--	"Conversation in [italic type]Jason and Medea[roman type] is divided into arguments about a certain topic. You can start an argument with 'argue about [italic type]topic[roman type]'. Simply type 'argue' to see a list of available topics (they can be abbreviated to one word when you type them). Note that Jason can also start arguments, and indeed has started one just before your first move.[paragraph break]While an argument is going on, you can 'attack' or 'defend'. Attacking gives you a greater probability of winning, but it also raises the stakes. In general, you should attack if you believe you can win the current argument, and defend if you believe you cannot.[paragraph break]You can see some of the underlying numbers by typing 'status'.[paragraph break]Finally, make sure to check your inventory. Using the 'show [italic type]topic[roman type]' command can be incredibly useful -- especially if you time your revelation just right!"	--
"The Lessons"	--	"Of course, it is [italic type]you[roman type] who must think about what lessons can be drawn from this demonstration. But let me point out some things that I found interesting.[paragraph break]1. My original plan was to use my Inform ATTACK combat system as the underlying mechanics of the game. But I quickly came to realise that such a combat system -- which involves tactical actions that can be repeated an unlimited number of times -- is not useful when you want to implement those tactical actions as verbal actions. There is nothing wrong with someone swinging a sword ten times; but there is something very wrong with someone saying the exact same phrase ten times. So while ATTACK-style combat can be easily [italic type]combined[roman type] with conversation, it is not easy to [italic type]reinterpret[roman type] this combat [italic type]as[roman type] conversation.[paragraph break]2. The system I did devise is much simpler. It's up to you to decide how well it works; but one of its advantages is that writing up the conversations takes relatively little time. (Not more and probably less than using traditional topic-based or menu-based conversations.)[paragraph break]3. Another thing I would like to point is how easy it is to combine this system with puzzles. Finding the right moment to use the love letters is a puzzle; and finding the love letters, or stopping Jason from finding some compromising material, could have been an earlier puzzle. In addition, these puzzles are [italic type]optional[roman type]: you might still win if you fail to solve them. I like the idea of optional but useful puzzles, so this gets me excited.[paragraph break]4. The current system injects some randomness into the outcomes, but this is not at all essential. One can remove the randomness, and the system will still function."	--
"Thanks & Copyright"	--	"I would like to thank Euripides, Apollonius of Rhodes and Friedrich Nietzsche, from whose works I have taken fragments of text. A significant portion of my text is based on Euripides' play [italic type]Medea[roman type], in the translation of E. P. Coleridge (which I have, however, modernised and changed where I saw fit). I would have preferred to use the Philip Vellacott translation, but that is still under copyright.[paragraph break]I would also like to thank Emily Short for organising the IF Demo Fair; Michiel Hermes, Eva Deinum and Annette van de Kraats for providing some preliminary testing; and Eva Deinum for help with the cover art.[paragraph break]This game is released under the GPL version 3 or any later version. Please send feedback to victor@lilith.cc."	--


		




