! definition of the class MazeClass
! by Ricardo Dague

class	MazeClass
 has	light
 with	short_name "In a Maze",
	initial [;
	    give self ~visited;
	],
	description [ x y n;
	    objectloop(x in compass && x ~= in_obj or out_obj)
		if(self provides x.door_dir)
		{
		    y = x; n++;
		}
	    if(self provides desc)
	    {
		PrintOrRun(self,desc);
		if(n ~= 0) print "^";
	    }
	    if(n == 0)
 		return;
	    if(n == 1)
		"An exit is ",(DirectionName)y,".";
	    print "Exits are ";
	    objectloop(x in compass && x ~= in_obj or out_obj)
		if(self provides x.door_dir)
		{
		    print (DirectionName)x;
		    if(--n == 1) break;
		    print ", ";
		}
	    " and ",(DirectionName)y,".";
	];

[ DirectionName x;
    switch(x)
    {
     n_obj: print "north";
     s_obj: print "south";
     e_obj: print "east";
     w_obj: print "west";
     ne_obj: print "northeast";
     se_obj: print "southeast";
     nw_obj: print "northwest";
     sw_obj: print "southwest";
     u_obj: print "up";
     d_obj: print "down";
     in_obj: print "in";
     out_obj: print "out";
     default: print "[",x,"]";
    }
];
