/*
	HCEMXOS2.C

	Non-portable functions specific to EMX/OS2:

		hugo_splitpath
		hugo_makepath
		hugo_closefiles

	for the Hugo Compiler

	Copyright (c) 1995-1998 by Kent Tessman

*/


#include "hcheader.h"


/*
    FILENAME MANAGEMENT:

    Different operating systems will have their own ways of naming
    files.  The following routines are simply required to know and
    be able to dissect/build the components of a particular filename,
    storing/restoring the components via the specified char arrays.

    For example, in OS/2:

    	hugo_splitpath("C:\HUGO\FILES\HUGOLIB.H", ...)
        	becomes:  C:, HUGO\FILES, HUGOLIB, H

    and

    	hugo_makepath(..., "C:", "HUGO\FILES", "HUGOLIB", "H")
		becomes:  C:\HUGO\FILES\HUGOLIB.H

    The appropriate equivalent nomenclature should be used for the
    operating system in question.
*/

void hugo_splitpath(char *path, char *drive, char *dir, char *fname, char *ext)
{
    char *c;

    strcpy(drive, path);
    c = strchr(drive, ':');
    if (c == NULL) {
        if (strchr(drive, '\\') == drive)
            strcpy(dir, drive + 1);
        else
            strcpy(dir, drive);
        strcpy(drive, "");
    }
    else {
        c = strchr(drive, '\\');
        strcpy(dir, ++c);
        strcpy(--c, "");
    }
    c = strrchr(dir, '\\');
    if (c == NULL) {
        strcpy(fname, dir);
        strcpy(dir, "");
    }
    else {
        strcpy(fname, ++c);
        strcpy(--c, "");
    }
    c = strrchr(fname , '.');
    if (c == NULL)
        strcpy(ext, "");
    else {
        strcpy(ext, ++c);
        strcpy(--c, "");
    }
}

void hugo_makepath(char *path, char *drive, char *dir, char *fname, char *ext)
{
    char *c;
    strcpy(path, "");
    if (strcmp(drive, "")) {
        strcat(path, drive);
        c = strchr(path, 0);
        *c++ = '\\';
        *c = '\0';
    }
    if (strcmp(dir, "")) {
        strcat(path, dir);
        c = strchr(path, 0);
        *c++ = '\\';
        *c = '\0';
    }
    strcat(path, fname);    /* a filename must be provided */
    if (strcmp(ext, "")) {
        strcat(path, ".");
        strcat(path, ext);
    }
}

/* hugo_closefiles

    Closes all open files.  NOTE:  If the operating system automatically
    closes any open streams upon exit from the program, this function may
    be left empty.
*/

void hugo_closefiles()
{
	fcloseall();			/* non-ANSI EMX library function */
/*
	fclose(sourcefile);
	fclose(objectfile);
	fclose(textfile);
	fclose(allfile);
	fclose(listfile);
*/
}
