/* Note:  This is an old version of hevideo.c, which exhibits
   problems with COM/DirectX/DirectShow.  Use hevideo.cpp instead.

	HEVIDEO.C

	AVI and MPEG video player for Win32:

		hugo_playvideo

	for the Hugo Engine

	Copyright (c) 1999 by Kent Tessman

	Remember that hugo_playvideo() is called with the file hot--
	i.e., opened and positioned to the start of the resource.
	It must be closed before returning.
*/

#include <windows.h>
#undef GetProp		// from windows.h
#include <mmsystem.h>
#include <dsound.h>
#include <control.h>
#include <strmif.h>
#include <uuids.h>
#include <evcode.h>
#include <math.h>

#include "heheader.h"
#include "hewin32.h"

int PlayVideo_DirectShow(HUGO_FILE infile, long reslength,
	char loop_flag, int volume);

char video_tempfile[MAX_PATH];
HWND wndVideo;
WNDCLASS wcVideo;
char video_running;
char video_is_looping;
long initial_video_volume;

// If we're calling the video player in a thread
DWORD WINAPI VideoThread(LPVOID);
HANDLE video_thread;
DWORD thread_id;
HUGO_FILE thread_infile;
long thread_reslength;
char thread_loop_flag;
int thread_volume;

// DirectShow interfaces:
static IGraphBuilder *pigb = NULL;
static IMediaControl *pimc = NULL;
static IMediaEvent *pime = NULL;
static IVideoWindow *pivw = NULL;
static IMediaPosition *pimp = NULL;
static IBasicAudio *piba = NULL;


/* hugo_hasvideo */

int hugo_hasvideo(void)
{
	if (!reg_DisplayGraphics) return false;
	return true;
}


/* hugo_stopvideo */

void hugo_stopvideo(void)
{
	if (video_thread)
	{
		DWORD exitcode;
		MSG msg;

		video_running = 0;
		GetExitCodeThread(video_thread, &exitcode);
		while (exitcode==STILL_ACTIVE)
		{
			/* Check Windows messages while we're waiting,
			   since we're going to be closing the video
			   playback window
			*/
			if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{
				if (msg.message==WM_QUIT)
				{
					exit(msg.wParam);
				}
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			GetExitCodeThread(video_thread, &exitcode);
		}
	}
}


/* hugo_playvideo

	The actual call(s) to PlayVideo_*() get dispatched from here.
*/

int hugo_playvideo(HUGO_FILE infile, long reslength,
	char loop_flag, char background, int volume)
{
	if (!reg_DisplayGraphics)
	{
		fclose(infile);
		return false;
	}
	
	hugo_stopvideo();
	
	if (!background)
	{
		video_thread = NULL;
		return PlayVideo_DirectShow(infile, reslength, loop_flag, volume);
	}

	/* If we're playing the video in the background, we have to
	   start the player as a thread
	*/
	else
	{
		thread_infile = infile;
		thread_reslength = reslength;
		thread_loop_flag = loop_flag;
		thread_volume = volume;
		video_thread = CreateThread(NULL, 1024, VideoThread, 0, 0, &thread_id);
		return video_thread?1:0;
	}
}


/* VideoThread

	Called if we're playing the video in the background, in
	which case we need to launch another thread.
*/

DWORD WINAPI VideoThread(LPVOID param)
{
	int r;
	CoInitialize(NULL);
	r = PlayVideo_DirectShow(thread_infile, thread_reslength, thread_loop_flag, thread_volume);
	CoUninitialize();
	ExitThread(r);
	return r;
}


/* VideoWndProc

	The callback for wndVideo, used to monitor messages during
	DirectShow video playback, below.
*/

LRESULT CALLBACK VideoWndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	switch (iMsg)
	{
		case WM_CREATE:
			return 0;

		/* Double-clicking video window stops playback.
		   Pressing Esc does, too, but that's handled in
		   VideoControl
		*/
		case WM_LBUTTONDBLCLK:
			video_running = 0;
			return 0;
	}

	return DefWindowProc(hwnd, iMsg, wParam, lParam);
}


/* VideoControl

	Here, just for clarity, is the loop that runs while the
	video resource is playing.  Control is not returned to the
	engine until the video is done (unless, we call VideoControl
	from a thread).
*/

void VideoControl(void)
{
	MSG msg;
	long lEventCode;
	long lParam1;
	long lParam2;
	static char suspended = false;
	static int last_reg_PlaySounds = 1,
		last_reg_DisplayGraphics = 1;

	video_running = true;

	while (video_running)
	{
		/* Silence this baby if the main window loses focus */
		if (GetForegroundWindow()!=wndMain)
		{
			pimc->lpVtbl->Pause(pimc);
			suspended = true;
		}
		else if (suspended)
		{
			pimc->lpVtbl->Run(pimc);
			suspended = false;
		}

		/* In case we change menu settings for audio/video */
		if (reg_PlaySounds!=last_reg_PlaySounds)
		{
			if (!reg_PlaySounds)
				piba->lpVtbl->put_Volume(piba, -10000);
			else
				piba->lpVtbl->put_Volume(piba, initial_video_volume);
			last_reg_PlaySounds = reg_PlaySounds;
		}
		if (reg_DisplayGraphics!=last_reg_DisplayGraphics)
		{
			if (!reg_DisplayGraphics) video_running = 0;
			last_reg_DisplayGraphics = reg_DisplayGraphics;
		}

		/* Check to see if the video resource is finished */
		pime->lpVtbl->GetEvent(pime, &lEventCode, &lParam1, &lParam2, 20);
		if (lEventCode==EC_COMPLETE)
		{
			if (video_is_looping)
			{
				pimp->lpVtbl->put_CurrentPosition(pimp, 0);
				pimc->lpVtbl->Run(pimc);
			}
			else
			{
				video_running = 0;
				break;
			}
		}
		pime->lpVtbl->FreeEventParams(pime, lEventCode, lParam1, lParam2);

		// Only allow the user to break playback if we're
		// not running in the background (i.e., a thread)
		if ((video_thread==NULL) && PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message==WM_QUIT)
			{
				exit(msg.wParam);
			}
				
			// Disallow keypress messages during video
			if (msg.message!=WM_KEYDOWN and msg.message!=WM_CHAR)
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			else if (msg.wParam==VK_ESCAPE)
			{
				video_running = 0;
			}
		}
	}

	pimc->lpVtbl->Stop(pimc);	// in case it's still running
}


/* PlayVideo_DirectShow

	For playing video resources.  Returns true on success, 
	false on failure.  Uses the same calling architecture as 
	PlayMusic_DirectShow in hesound.c.

- AddRef()s added to prevent misrendering of wndMain after a
few plays.
*/

int PlayVideo_DirectShow(HUGO_FILE infile, long length, char loop_flag, int volume)
{
	HRESULT hr;
	WCHAR wFile[MAX_PATH];
	int x, y, width, height;
	float ratio;
	long ws;
	HWND hasfocus;

	/* If we're running on Windows NT (which doesn't support
	   DirectShow), NT_sound_system will be true
	*/
	if (NT_sound_system)
	{
		fclose(infile);
		goto DirectShowError;
	}

	video_is_looping = loop_flag;

	/* See first if resourcefile is a standalone resource, or
	   if we need to copy the resource into a standalone tempfile.
	   Either way, the file gets closed.
	*/
	if (ftell(infile)!=0)
	{
		/* Change resource_file to the temp cache file */
		if (!CreateResourceCache(loaded_resname, infile, length))
			return false;
		strcpy(loaded_filename, "");
		strcpy(video_tempfile, loaded_resname);
	}
	else
	{
		strcpy(video_tempfile, "");
		fclose(infile);
	}

	/* Create the control window */
	wcVideo.lpszClassName = "HugoVideoWindow";
	wcVideo.lpfnWndProc = VideoWndProc;
	RegisterClass(&wcVideo);
	wndVideo = CreateWindow(wcVideo.lpszClassName, "",
		WS_CHILD, 0, 0, 10, 10,
		wndMain, NULL, AppInstance, NULL);

	/* DirectShow speaks Unicode */
	MultiByteToWideChar(CP_ACP, 0, loaded_resname, -1, wFile, MAX_PATH);

	/* Instantiate the filter graph manager, asking for the 
	   IGraphBuilder interface
	*/
	hr = CoCreateInstance(&CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER, &IID_IGraphBuilder, (void **)&pigb);
	if (FAILED(hr))
	{
		pigb = NULL;
		goto DirectShowError;
	}
	pigb->lpVtbl->AddRef(pigb);

	/* Get the IMediaControl interface */
	pigb->lpVtbl->QueryInterface(pigb, &IID_IMediaControl, (void **)&pimc);
	pimc->lpVtbl->AddRef(pimc);

	/* Get the IMediaEvent interface */
	pigb->lpVtbl->QueryInterface(pigb, &IID_IMediaEvent, (void **)&pime);
	pime->lpVtbl->AddRef(pime);

	/* Get the IMediaPosition interface */
	pigb->lpVtbl->QueryInterface(pigb, &IID_IMediaPosition, (void **)&pimp);
	pimp->lpVtbl->AddRef(pimp);

	/* Render the file */
	hr = pigb->lpVtbl->RenderFile(pigb, wFile, NULL);
	if (FAILED(hr)) goto ReleaseAll;

	/* Get the IVideoWindow interface and set up the window */
	pigb->lpVtbl->QueryInterface(pigb, &IID_IVideoWindow, (void **)&pivw);
	pivw->lpVtbl->AddRef(pivw);
	pivw->lpVtbl->put_Owner(pivw, (OAHWND)wndMain);
	pivw->lpVtbl->put_MessageDrain(pivw, (OAHWND)wndVideo);
	pivw->lpVtbl->get_WindowStyle(pivw, &ws);
	ws &= ~WS_CAPTION;	// remove the title bar
	ws &= ~WS_THICKFRAME;	// remove frame
	pivw->lpVtbl->put_WindowStyle(pivw, ws);

	/* Get the IBasicAudio interface */
	pigb->lpVtbl->QueryInterface(pigb, &IID_IBasicAudio, (void **)&piba);
	piba->lpVtbl->AddRef(piba);
	piba->lpVtbl->put_Volume(piba,
		// This formula is from hesound.c:
		volume?(long)((log10(volume)-2)*5000):-10000);
	piba->lpVtbl->get_Volume(piba, &initial_video_volume);
	/* Turn volume off if audio disabled */
	if (!reg_PlaySounds) piba->lpVtbl->put_Volume(piba, -10000);

	/* Position the video window */
	pivw->lpVtbl->GetWindowPosition(pivw, &x, &y, &width, &height);

	// For some goofy reason, when we put_WindowStyle() it doesn't
	// adjust the window size to remove the title bar and frame
	width -= GetSystemMetrics(SM_CXSIZEFRAME)*2;
	height -= (GetSystemMetrics(SM_CYSIZEFRAME)*2 +
		GetSystemMetrics(SM_CYMENUSIZE));

	ratio = (float)width/(float)height;
	if (width > physical_windowwidth)
	{
		width = physical_windowwidth;
		height = (int)((float)width / ratio);
	}
	if (height > physical_windowheight)
	{
		height = physical_windowheight;
		width = (int)((float)height * ratio);
	}
	x = physical_windowleft+physical_windowwidth/2 - width/2;
	y = physical_windowtop+physical_windowheight/2 - height/2;
sprintf(line, "(%d, %d, %d, %d)", x, y, width, height);
MessageBox(NULL, line, "pivw->SetWindowPosition()", MB_OK);
	pivw->lpVtbl->SetWindowPosition(pivw, x, y, width, height);

	/* Play the video resource */
	hr = pimc->lpVtbl->Run(pimc);
	if (FAILED(hr)) goto ReleaseAll;

	/* Let VideoControl() handle all Windows messaging, etc. while
	   the resource is playing
	*/
	VideoControl();

ReleaseAll:
	hasfocus = GetFocus();
	pivw->lpVtbl->put_Visible(pivw, 0);
	pivw->lpVtbl->put_Owner(pivw, (OAHWND)NULL);
	// Do this to avoid the titlebar flicker when focus shifts
	// due to the put_Owner() call:
	if (hasfocus==wndMain) SetFocus(wndMain);
	pivw->lpVtbl->Release(pivw);
	DestroyWindow(wndVideo);
	piba->lpVtbl->Release(piba);
	pimp->lpVtbl->Release(pimp);
	pime->lpVtbl->Release(pime);
	pimc->lpVtbl->Release(pimc);
	pigb->lpVtbl->Release(pigb);

DirectShowError:
	if (strcmp(video_tempfile, ""))
{
LPVOID lpMsgBuf;
 
BOOL r =
		DeleteFile(video_tempfile);
FormatMessage( 
    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    NULL,
    GetLastError(),
    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
    (LPTSTR) &lpMsgBuf,
    0,
    NULL 
);

// Display the string.
MessageBox(wndMain, lpMsgBuf, "GetLastError", MB_OK|MB_ICONINFORMATION );

// Free the buffer.
LocalFree( lpMsgBuf );
}

	if (FAILED(hr))
	{
#if defined (DEBUGGER)
		DebugMessageBox("Video Playing Error",
			"Unable to play video via DirectShow.");
#endif
		return false;
	}
	else
		return true;
}
