# hewin.exe makefile
# for lcc

TARGET=hewin.exe

# PORT_NAME is for file-naming:
PORT_NAME=lcc
COMPILE=lcc
LINK=lcclnk

# Instead of specifying directories, we'll use a make.bat to
# copy all source files to the current directory--lcc doesn't
# seem to want to put .$(OBJ_EXT) files where it's told
#SOURCE_DIR=c:/hugo/source
SOURCE_DIR=.
#NONPORTABLE_DIR=c:/hugo/source/lcc
NONPORTABLE_DIR=.

OBJ_EXT=obj
NONPORTABLE_OBJS=he$(PORT_NAME).$(OBJ_EXT) hejpeg.$(OBJ_EXT) hesound.$(OBJ_EXT) \
hewin.obj hewin.res hesound_nt.obj
DEFINES=-DLCCWIN32 -DCOMPILE_V25 -DUSE_NT_SOUND_ONLY
#DFLAGS=-g4
CFLAGS=-Ic:/hugo/source -Ic:/lcc/include -Ic:/lcc/mikmod/source $(DFLAGS) $(DEFINES) -errout=output.txt
#CFLAGS=-Ic:/hugo/source -Ic:/lcc/include -Ic:/lcc/mikmod/source $(DFLAGS) $(DEFINES)
LFLAGS=-subsystem windows
LIBS=c:\lcc\jpeg\libjpeg.lib c:\lcc\mikmod\source\libmik.lib winmm.lib \
shell32.lib

OBJS=he.$(OBJ_EXT) heexpr.$(OBJ_EXT) hemisc.$(OBJ_EXT) heobject.$(OBJ_EXT) \
heparse.$(OBJ_EXT) heres.$(OBJ_EXT) herun.$(OBJ_EXT) heset.$(OBJ_EXT) \
stringfn.$(OBJ_EXT) \
$(NONPORTABLE_OBJS)

# hclcc.$(OBJ_EXT) is included to steal hugo_makepath() and hugo_splitpath()

$(TARGET).exe: $(OBJS)
	$(LINK) $(LFLAGS) -o $(TARGET) $(OBJS) $(LIBS)


# Portable sources:

he.$(OBJ_EXT): $(SOURCE_DIR)/he.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/he.c

heexpr.$(OBJ_EXT): $(SOURCE_DIR)/heexpr.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heexpr.c

hemisc.$(OBJ_EXT): $(SOURCE_DIR)/hemisc.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/hemisc.c

heobject.$(OBJ_EXT): $(SOURCE_DIR)/heobject.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heobject.c

heparse.$(OBJ_EXT): $(SOURCE_DIR)/heparse.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heparse.c

heres.$(OBJ_EXT): $(SOURCE_DIR)/heres.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heres.c

herun.$(OBJ_EXT): $(SOURCE_DIR)/herun.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/herun.c

heset.$(OBJ_EXT): $(SOURCE_DIR)/heset.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/heset.c

stringfn.$(OBJ_EXT): $(SOURCE_DIR)/stringfn.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/stringfn.c


# Non-portable sources:

helcc.$(OBJ_EXT): $(NONPORTABLE_DIR)/helcc.c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/helcc.c

hclcc.$(OBJ_EXT): $(NONPORTABLE_DIR)/hclcc.c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/hclcc.c

hejpeg.$(OBJ_EXT): $(SOURCE_DIR)/hejpeg.c
	$(COMPILE) $(CFLAGS) -Ic:/lcc/jpeg $(SOURCE_DIR)/hejpeg.c

hesound.$(OBJ_EXT): $(SOURCE_DIR)/hesound.c
	$(COMPILE) $(CFLAGS) -Ic:/lcc/mikmod/source $(SOURCE_DIR)/hesound.c

hewin.obj: $(SOURCE_DIR)/hewin.c
	$(COMPILE) $(CFLAGS) -Ic:/lcc/mikmod/source $(SOURCE_DIR)/hewin.c
