/*
	hewince.h

	Additional header for compiling with eMbedded VC++ 4.0
	for Windows CE

	Copyright (c) 2003 by Kent Tessman
*/

#define DEVICE_SCREEN_HEIGHT 320
#define MENU_HEIGHT 26
#define CLEARTYPE_QUALITY 5

#define CE_SETTINGS_FILE "PocketHugo.settings"

// #defines that CE doesn't have:
#define WM_INITMENU WM_INITMENUPOPUP
#define WS_OVERLAPPEDWINDOW WS_OVERLAPPED
#define SM_CXSIZEFRAME SM_CXFIXEDFRAME
#define SM_CYSIZEFRAME SM_CYFIXEDFRAME
#define TPM_RIGHTBUTTON 0

// Because of a collision with FindResource() with WinCE's SDK:
#ifdef UNDER_CE
#undef DialogBoxParamW
#define DialogBoxParamW(hInstance, lpszDlgName, hwndOwner, lpfnDialog, lParam)    \
    DialogBoxIndirectParamW(hInstance,   \
        (LPCDLGTEMPLATEW)LoadResource(hInstance, FindResourceW(hInstance, lpszDlgName, RT_DIALOG)), \
        hwndOwner, lpfnDialog, lParam)
#endif

// CE uses a different function (or version of a function):
#define SleepEx(ms, alert) Sleep(ms)

// Functions CE doesn't have:
#define CharToOemBuff(src, dest, len) strncpy(dest, src, len)
#define IsZoomed(wnd) (1)
#define IsIconic(wnd) (0)
#define GetCurrentDirectory(len, buf) (0)
#define SetCurrentDirectory(a) (0)
#define SetEnvironmentVariable(var, val) (0)
#define LockWindowUpdate(wnd) (0)

#define MulDiv(x, y, z) (DWORD)(((LONGLONG)((LONG)(x)) * (LONGLONG)((LONG)(y)))\
                        / (LONGLONG)((LONG)(z)))


// Now the actual prototypes, etc.:

extern HWND menubar;
extern int reg_MinimalWindows, reg_NoBlankLines, reg_UseColors;

LRESULT CALLBACK WinCEWndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);
void SetupCEWindow(HINSTANCE hInstance, HWND wnd);
void CheckSIPStatus(void);
void EnableInputButtons(BOOL on);
BOOL LoadDefaultCESettingsFile(void);
BOOL LoadCESettingsFile(char *filename);
BOOL SaveDefaultCESettingsFile(void);
BOOL SaveCESettingsFile(char *filename);
