!***************************************************************************
!**
!** Not Just A Game - Copyright (c) 1999 by John Menichelli
!** 
!**                  Part 3 - Elemental Rooms
!**
!***************************************************************************

Object steps1 "steep steps"
   with name "steep" "narrow" "stone" "steps" "stairs",
   with description
           "The steep stone steps ascend back to the connected series of 
            rooms.",
        found_in Room1 Room2 Room3 Room4 Room5,
   has  scenery;

!***************************************************************************
!**
!**   RoomX is the first room the player enters after coming down the stairs.
!**
!**   RoomXN = the room to the north, RoomXS = the room to the south, etc.
!**
!**   Each group of five rooms in arranged as follows:
!**
!**             +++++
!**             +   +
!**             +   +
!**             +++++
!**               |
!**     +++++   +++++   +++++
!**     +   +___+   +___+   +
!**     +   +   +   +   +   +
!**     +++++   +++++   +++++
!**               |
!**             +++++
!**             +   +
!**             +   +
!**             +++++
!**
!***************************************************************************

!***************************************************************************
!**
!**  "Water" Area
!**
!***************************************************************************

Object Room1 "Damp Chamber"
   with description
          "This chamber is carved out of solid rock. It is very damp; the 
           walls are dripping with condensation and slimy with moss. There 
           are steps leading up, and exits to the north, south, east and 
           west.",
        u_to [; virtual_loc = 20; PlayerTo(Maze); return 1; ],
        n_to Room1N,
        s_to Room1S,
        e_to Room1E,
        w_to Room1W,
   has  light;

Object condensation "condensation"
   with name "dripping" "condensation",
        description
           "The condensation covers the walls, making the place 
            wet and dreary.",
        found_in Room1 Room1N Room1S Room1E Room1W,
   has  scenery;

Object moss "moss"
   with name "cracks" "slimy" "moss",
        description
           "The moss grows in the cracks in the walls.",
        before [;
           Take:
              "The moss is growing in the cracks and is difficult to reach.";
        ],
        found_in Room1 Room1N Room1S Room1E Room1W,
   has  scenery;

Object Room1N "Cube Chamber"
   with description
          "This chamber is carved out of solid rock. It is very damp; the 
           walls are dripping with condensation and slimy with moss. The 
           room is featureless except for a block of marble which occupies 
           the center of the room. There is an exit to the south.",
        s_to Room1,
   has  light;

pedestal -> pedestal_1n "block of marble";

cube black_cube "black cube" pedestal_1n
   with name "jet" "black" "cube",
        number 1;

Object Room1S "Waterwheel Room"
   with description [;
           print "This chamber is carved out of solid rock. It is very damp; 
                  the walls are dripping with condensation and slimy with 
                  moss. ";

           print "A large waterwheel, which is currently ";

           if (water_valve has open)
              print "rotating";
           else
              print "stationary";
           
           print ", occupies the center of the room. The waterwheel's axle is 
                  connected to a generator. A metal pipe is mounted over the 
                  waterwheel. The only exit from this room is to the north.";

           if (self hasnt general) {
              give self general;
              "^^You have to admit, this isn't something you see every 
               day."; }
           else
              new_line; rtrue;
        ],
        before [;
           Listen: if (water_valve has open)
                      "Aside from the sound of the water gushing out of the 
                       pipe, you hear nothing.";
        ],
        n_to Room1,
   has  light;

Object -> waterwheel "waterwheel"
   with name "wooden" "wood" "paddle" "paddles" "paddlewheel" "waterwheel" 
             "wheel",
        description [;
           print "The ";

           if (water_valve has open)
              print "spinning";
           else
              print "stationary";

           " wooden waterwheel is approximately ten feet in diameter.";
        ],
        before [;
           Turn, Push, Pull:
              "The waterwheel is too big for you to move - you'll have to 
               find another way.";
        ],
   has  scenery;

Object -> pipe "pipe"
   with name "metal" "pipe",
        description [;
           print "The metal pipe comes out of the floor, continues up the 
                  wall and discharges directly onto the waterwheel's paddles. 
                  Water coming out of the pipe causes the waterwheel to turn. 
                  A valve controls the flow of water through the pipe.
                  Currently, ";

           if (water_valve has open)
              "water is pouring out of the pipe onto the waterwheel's
               paddles.";
           else
              "there is no water coming out of the pipe.";
        ],
        before [;
           Search:
              if (water_valve has open)
                 "You can't see inside the pipe because there's water
                  gushing out of it.";
              else rfalse;
        ],
   has  scenery;

Object -> water_valve "valve"
   with name "large" "valve",
        description
           "A large valve controls the flow of water through the pipe. 
            The valve is opened and closed by turning the valve's 
            handwheel, which is attached to the stem. ",
        before [;
           Receive:
              if (noun == steel_rod) {
                 "Try putting that into the hole instead."; }
              else
                 "That doesn't go there.";

           Take: 
              "It's attached to the pipe.";

           Turn: <<Turn handwheel>>;
           
           Open: <<Open handwheel>>;
           
           Close: <<Close handwheel>>;
        ],
   has  scenery ~open;

Object -> handwheel "handwheel"
   with name "handwheel" "stem",
        description [;
           print "The handwheel is the part of the valve that you grab to 
                  open and close the valve. It is attached to a valve stem, 
                  which is the part that turns to open and close the valve. 
                  A hole runs through the handwheel and the stem. ";

           if (steel_rod in valve_hole)
              "A steel rod is in the hole.";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              if (noun == steel_rod) {
                 "Try putting that into the hole instead."; }
              else
                 "That doesn't go there.";

           Take: "It's attached to the valve.";

           Turn:
              if (water_valve hasnt general)
                 "The handwheel spins but nothing happens.";

              if (water_valve has open) {
                 give water_valve ~open;
                 "You turn the handwheel, which shuts the valve and stops 
                 the flow of water from the pipe. The waterwheel slowly 
                 spins to a stop."; }
              else {
                 Achieved(4);
                 give water_valve open;
                 "You turn the handwheel, which opens the valve. A torrent 
                 of water gushes from the pipe and the waterwheel slowly 
                 spins up to full speed."; }

           Open:
              if (water_valve hasnt general)
                 <<Turn self>>;

              if (water_valve has open)
                 "The valve is already open.";
              else
                 <<Turn self>>;

           Close:
              if (water_valve hasnt general)
                 <<Turn self>>;

              if (water_valve hasnt open)
                 "The valve is already closed.";
              else
                 <<Turn self>>;         
        ],
   has  scenery;

Object -> valve_hole "small hole"
   with name "small" "hole",
        description [;
           print "The hole runs perpendicularly through the handwheel and 
                  the valve stem. ";

           if (steel_rod in self)
              "A steel rod is in the hole.";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              if (noun == steel_rod) {
                 give water_valve general;
                 move steel_rod to self;
                 "The rod fits snugly into the hole."; }
              else
                 "That doesn't fit.";
           LetGo:
              give water_valve ~general;
              rfalse;
        ],
   has  scenery container open ~openable;

Object -> pipe_water "water"
   with name "water" "drain",
        description [;
           if (water_valve has open)
              "The water gushes out of the pipe, onto the waterwheel, then
               into a drain located underneath the waterwheel.";
           else
              "There's no water coming out of the pipe.";
        ],
        before [;
           Take:
              if (water_valve has open)
                 "You can't get to the water without being hit by the 
                  waterwheel.";
              else
                 "There's no water here.";
        ],
   has  scenery;

Object -> generator "generator"
   with name "axle" "electrical" "electric" "generator",
        description
           "The large electrical generator is attached to the 
            waterwheel's axle. When the waterwheel turns, so does 
            the generator.",
   has  scenery;

Object Room1E "Sculpture Chamber"
   with description
          "This chamber is carved out of solid rock. It is very damp; the 
           walls are dripping with condensation and slimy with moss. A 
           crystal sculpture occupies the center of the room. You may exit 
           this room by going west.",
        w_to Room1,
   has  light;

Object -> sculpt_water "water"
   with name "crystal" "clear" "water",
        description
           "The water is crystal clear.",
        before [;
           Receive:
              if (noun ~= handful_salt)
                 "That doesn't fit in the cylinder.";
              else
                 <<Insert noun glass_cylinder>>;
           Take:
              "Not possible.";

           Taste, Drink:
              print "The water is hard to reach, but you manage to get a 
                     little on your finger. ";

              if (glass_cylinder hasnt general)
                 "It's very pure and has no taste.";
              else
                 "It tastes salty.";
        ],
   has  scenery;

Object -> sculpture "crystal sculpture"
   with name "roots" "twisted" "tubes" "crystal" "sculpture",
        description [;
           print "The crystal sculpture is about three feet tall and looks 
                  like it is actually growing out of the rock. It consists 
                  of a series of intricately twisted tubes resembling the 
                  roots of a large plant. Near the floor, the tubes are 
                  extremely thin, almost invisible. They thicken the farther 
                  up they are from the floor, finally merging into a single 
                  glass cylinder at the top of the sculpture. ";

           if (red_ball in glass_cylinder)
              print "There appears to be something in the cylinder.";

           if (self hasnt general) {
              give self general;
              "^^Seeing this sculpture reminds you of the time you accidentally
               broke one of your teacher's blown glass figurines. She told you
               not to worry about it, but you could see the pain in her eyes."; }
           else
              new_line; rtrue;
        ],
        before [;
           Attack, AttackWith:
              deadflag = 1;
              "The sculpture literally explodes as you strike it. Millions of
               glass shards effortlessly slice through your body. You fall
               to the ground even before you realize... ";
        ],
   has  scenery;

Object -> glass_cylinder "glass cylinder"
   with name "trunk" "glass" "cylinder",
        description [;
           print "The long, thin cylinder, which is open at the top and 
                  filled with water, forms the ~trunk~ at the top of the 
                  ~roots.~ The top of the cylinder is approximately three 
                  feet above the floor. ";

           if (self hasnt general)
              "A red ball rests at the bottom of the cylinder.";
      
           if (self has general && red_ball in self)
              "A red ball floats near the top of the cylinder.";

           new_line; rtrue;
        ],
        before [;
           Receive:
              if (noun == handful_salt && self hasnt general) {
                 remove handful_salt;
                 give self general;
                 "The salt quickly dissolves in the water. As it does, ", 
                  (the) red_ball, " rises to the top of ", (the) self, "."; }

              if (noun == handful_salt && self has general)
                 "You've already put enough salt in there.";

              if (noun == red_ball) {
                 move red_ball to self;
                 print_ret "You put ", (the) noun, " in ", (the) self, "."; }

              else
                 "That won't fit in there.";

           Take, Empty, EmptyT:
              "You can't - it's part of the sculpture.";
        ],
   has  scenery transparent container open;

Object -> -> red_ball "red ball"
   with name "red" "ball" "seam" "circumference",
        description [;
           if (self has open)
              "The deformed red ball has seen better days.";
           else
              "The red ball has a seam around its circumference.";
        ],
        before [;
           if (glass_cylinder hasnt general) {
              if (action == ##Examine)
                 rfalse;
              else
                 "You can't do that to ", (the) self, " because it's at
                  the bottom of ", (the) glass_cylinder, "."; }

           Take:
              if (glass_cylinder hasnt general)
                 "You can't reach it - it's at the bottom of the cylinder.";
              else {
                 Achieved(5);
                 rfalse; }

           Receive:
              "Opening the ball has deformed it - you can't put anything in
               it now.";

           Open:
              if (self hasnt open) {
                 give self open;
                 <<Search self>>; }
              else
                 "It's already open.";

           Close:
              if (self has open)
                 "Opening the ball has deformed it - you can't close it 
                  again.";
              else
                 "It's already closed.";

           Bounce:
              "Whee!";
        ],
   has  container ~open;

Object gum "piece of chewing gum" red_ball
   with name "piece" "of" "chewing" "gum",
        description
           "A piece of chewing gum.",
        before [;
           Taste:
              "It tastes sweet.";

           Eat:
              remove self;
              SetPronoun('it', gooey_gum);
              move gooey_gum to player;
              "After several minutes of chewing, all the sugar is gone.
               All that's left is a gooey blob, which you take out of 
               your mouth.";
        ];

Object gooey_gum "piece of chewed gum"
   with name "piece" "of" "gooey" "blob" "chewed" "gum",
        description [;
           print "A gooey blob of chewed gum. ";

           if (self in steel_rod)
              "It is permanently attached to the steel rod.";
           else
              new_line; rtrue;
        ],           
        before [;
           Taste, Eat:
              "You'd rather not.";

           Drop:
              "You'll only make a mess.";

           PutOn:
              if (second ~= steel_rod)
                 "You'll only make a mess.";
              else {
                 move self to steel_rod;
                 "You put the gooey gum on the steel rod."; }
        ];

Object Room1W "Salt Chamber"
   with description
          "This chamber is carved out of solid rock. It is very damp; the 
           walls are dripping with condensation and slimy with moss. At 
           one time this room must have been filled with salt water, because 
           a layer of salt crystals cover the floor. The only exit is to the 
           east.",
        e_to Room1,
   has  light;

Object -> salt_crystals "salt crystals"
   with name "salt" "crystals",
        description
           "The salt crystals cover the floor.",
        before [;
           Taste, Eat:
              "It tastes salty.";

           Take:
              if (handful_salt notin player) {
                 move handful_salt to player;
                 SetPronoun('it', handful_salt);
                 "You pick up ", (a) handful_salt, " from the floor."; }
              else
                 "You already have ", (a) handful_salt, ".";
        ],
   has  scenery pluralname;

Object handful_salt "handful of salt crystals"
   with name "handful" "of" "salt" "crystals",
        description
           "A handful of salt crystals.",
        before [;
           Taste, Eat:
              "It tastes salty.";

           Drop:
              if (location ofclass House)
                 "You'd only get the carpet dirty.";
              else {
                 remove self;
                 SetPronoun('it', salt_crystals);
                 "You toss the salt, which scatters and is lost."; }
        ];

!***************************************************************************
!**
!**  "Wood" Area
!**
!***************************************************************************

Object Room2 "Plank Room"
   with description
          "The walls of this room are solidly braced with thick planks, while 
           the floor is made of smoothly planed hardwood. There are steps 
           leading up, and exits to the north, south, east and west.",

        u_to [; 
           if (wood_log in player)
              print_ret (The) wood_log, " is too heavy to lug up the steps.";
           else {
                virtual_loc = 24; 
           	PlayerTo(Maze); 
           	return 1; }
        ],
        n_to Room2N,
        s_to Room2S,
        e_to Room2E,
        w_to Room2W,
   has  light;

Object planks "planks"
   with name "walls" "walls" "floor" "ceiling" "room" "chamber" "smoothly" 
             "planed" "wood" "hardwood" "thick" "planks",
        description
           "The hardwood planks are very thick and strong.",
        found_in Room2 Room2N Room2S Room2E Room2W,
   has  scenery;

Object Room2N "Cube Room"
   with description
          "The walls of this room are solidly braced with thick planks, while 
           the floor is made of smoothly planed hardwood. There is a block of
           marble in the center of the room. There is an exit to the south.",
        s_to Room2,
   has  light;

pedestal -> pedestal_2n "block of marble";

cube green_cube "green cube" pedestal_2n
   with name "dark" "green" "cube",
   number 2;

Object Room2S "Wood Storage"
   with description
          "The walls of this room are solidly braced with thick planks, while 
           the floor is made of smoothly planed hardwood. A wrought iron rack 
           occupies one corner of the room. There is an exit to the north.",
        n_to Room2,
   has  light;

Object -> log_rack "log rack"
   with name "bolt" "bolted" "rack" "wrought" "iron" "storage",
        description [;
           if (wood_log in self)
              print "A wrought iron storage rack, which contains a single 
                     log, ";
           else
              print "An empty wrought iron storage rack ";
              
           "is bolted to the floor. ";
     ],
     before [;
        Receive:
           if (noun ~= wood_log)
              "That doesn't go there.";
     ],
has  scenery supporter;

Object -> -> wood_log "log"
   with name "section" "log" "tree" "branch",
        description [;
           print "A well-aged section of an ash tree, approximately four 
                  feet long and one foot in diameter. ";

           if (self hasnt general) {
              give self general;
              "^^About a year ago, the ash tree in your teacher's back yard 
               was struck by lightning and fell over. She was very excited
               when that happened, but she wouldn't say why. Maybe this 
               section of log came from that tree."; }
           else
             new_line; rtrue;
        ],
        before [;
           Burn:
              if (second == match && match has light)
                 "It's flame-resistant.";
        ];

Object baseball_bat "baseball bat"
   with name "baseball" "bat",
        description
           "A high-quality baseball bat. It looks very new.",
        before [;
           Swing:
              "Batter up!";

           Burn:
              if ((second == match && match has light) ||
                  (second ofclass HotIngot) ||
                  (second == asbestos_cup && asbestos_cup has general))
                 "It's flame-resistant.";
        ];

Object Room2E "Workshop"
   with description
          "The walls of this room are solidly braced with thick planks, 
           while the floor is made of smoothly planed hardwood. The 
           centerpiece of this room is a large lathe. The only exit 
           lies to the west.",
        w_to Room2,
   has  light;

Object -> lathe "lathe"
   with name "well" "worn" "well-worn" "industrial-sized" "industrial" "sized" 
             "lathe" "blade",
        description [;
           print "This in a well-worn, industrial-sized lathe. It is used to 
                  shape wood, metal and other materials. The item to be 
                  shaped is placed in the lathe; the lathe then rapidly spins 
                  the item and cuts it by holding a cutting blade against the 
                  material. This particular lathe has a clamp to hold the 
                  item being worked, a light and a green button marked 
                  ~Start.~ ";
      
           if (children(lathe_clamp) ~= 0)
              print_ret (The) lathe_clamp, " holds ", (a) 
              child(lathe_clamp), ".";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              "Try putting that in ", (the) lathe_clamp, " instead.";
        ],
   has  scenery;

Object -> lathe_clamp "clamp"
   with name "clamp",
        description [;
           print "The clamp is designed to automatically close around 
                  any item placed in it. ";

           if (children(self) ~= 0)
              "It currently holds ", (a) child(lathe_clamp), ".";
           else
              new_line; rtrue;
        ],
        before [;
           Open, Close:
              "The clamp opens and closes automatically. All you have to do
               is place an object in or remove it from the clamp.";

           Receive:
              if (children(self) ~= 0)
                 print_ret (The) self, " can only hold one thing at a time.";

              if (water_valve hasnt open)
                 "Nothing happens when you put ", (the) noun, " in ", 
                 (the) self, " so you take it back.";

              else {
                 if (noun has stone)
                    print_ret (The) lathe_clamp, " attempts to close onto the
                    Go stone but it's too small.";

                 if (noun == gloves or matchbook or match or gum or gooey_gum)
                    print_ret (The) lathe_clamp, " makes several attempts 
                    to close onto ", (the) noun, ", but can't seem to get 
                    a good grip.";

                 else {
                    move noun to self;
                    print_ret "You place ", (the) noun, " in ", (the) self, 
                    ", which automatically closes and locks it in place."; }}

           LetGo:
              if (children(self) == 0)
                 "It's not holding anything.";

              if (water_valve hasnt open)
                 "You can't - ", (the) self, " won't open.";

              if (water_valve has open) {
                 move noun to player;
                 print_ret (The) self, " automatically releases ", 
                           (the) noun, " as you take it."; }
        ],
   has  supporter scenery;

Object -> lathe_power_light "available power light"
   with name "dull" "orange" "available" "power" "light",
        description [;
           print "The light, which is ";

           if (water_valve has open)
              print "glowing a dull orange,";
           else
              print "off,";

           " shows if electrical power is available to ", (the) lathe, ".";
        ],
   has  scenery;

Object -> green_button "green button"
   with name "green" "start" "button",
        description
           "The green button has the word ~Start~ printed on it.",
        before [;
           Push:
              if (water_valve hasnt open)
                 "'Click'. I think it needs electricity to work.";

              if (water_valve has open && children(lathe_clamp) == 0)
                 "You hear a 'Beep', but nothing else happens.";

              if (water_valve has open && children(lathe_clamp) ~= 0) {
                 if (child(lathe_clamp) == wood_log) {
                    remove wood_log;
                    move baseball_bat to lathe_clamp;
                    Achieved(6);
                    "With a 'beep' the lathe spins to life and begins 
                     automatically shaping the log. Within a few 
                     minutes, the log is shaped into a baseball bat. 
                     You hear a second 'beep' and the lathe slows to a 
                     stop."; }

                 if (child(lathe_clamp) == baseball_bat)
                    "You just made that.";

                 if (child(lathe_clamp) ofclass cube) {
                    deadflag = 1;
                    "Bad idea. The cube begins to glow as the lathe attempts
                    to shape it. Suddenly, the universe (or at least the 
                    part you occupy) begins to fold in on itself. 
                    Unfortunately, you get folded along with it..."; }

                 else
                    "With a 'beep' the lathe spins to life. The blade begins
                     to move towards ", (the) child(lathe_clamp), " but stops 
                     before it actually touches it. You hear a second 'beep' 
                     and the lathe slows to a stop.";
              }
        ],
   has  scenery;

Object Room2W "Drum Room"
   with description
           "The walls of this room are solidly braced with thick planks, 
            while the floor is made of smoothly planed hardwood.
            A single 55 gallon drum sits in one corner of the room. You
            may leave this room by going east.",
        e_to Room2,
   has  light;

Object -> drum "large drum"
   with name "55" "fifty-five" "fifty" "five" "gallon" "steel" "drum",
        description
           "A standard 55 gallon drum (with a steel lid) rests in the 
            corner. ",
        before [;
           Beat:
              "You couldn't tell from looking at it, but this drum actually
               sounds quite good. You tap out a nice little rhythm but 
               you stop after a minute or so - you've got work to do, after 
               all.";

           Open: <<Open drum_lid>>;

           Unlock: <<Unlock drum_lid second>>;

           Push, Pull, Take:
              "It's too heavy.";

           Search:
              if (drum_lid hasnt general)
                 "The drum is shut tight.";

              if (self has general) rfalse;

              else {
                 give self general;
                 move gloves to self; 
                 "Inside ", (the) self, " you find a pair of gloves."; }
        ],
   has  scenery container ~open;

Object -> drum_lid "lid"
   with name "lid" "cover",
        description [;
           print "The lid ";

           if (self has general)
              "has been pried open a few inches.";
           else
              "is firmly attached to the drum. It looks as though someone has
               tried to pry it open in the past without much luck.";
        ],
        before [;
           Open, Pull:
              "Try as you might, you can't get the lid to budge. Maybe if you
               had more leverage.";

           Unlock:
              if (self has general)
                 "The lid is bent back as far as you can make it.";
                 
              if (second == 0)
                 "You'll have to specify what you want to pry the lid with.";

              if (second == steel_rod && self hasnt general) {
                 give self general;
                 give drum open;
                 move gloves to drum;
                 "You wedge the end of the bar between the lid and the barrel
                  and heave with all your might. For a moment nothing happens.
                  You feel as if your head is going to explode from the effort.
                  Then, with a loud shriek, the lid bends back a few inches."; }

              if (second ~= steel_rod && self hasnt general)
                 "That's not going to work.";
        ],
   has  scenery;

Object gloves "pair of gloves"
   with name "heavy" "duty" "heavy-duty" "pair" "leather" "gloves",
        description
           "A pair of heavy-duty leather gloves.",
        article "a",
        before [ i j;
           Disrobe:
              if (self has worn) {
                 if (rect_mold in player && cooling_silver in rect_mold)
                    "You can't do that while you're holding the hot mold.";

                 if (asbestos_cup in player && asbestos_cup has general)
                 "You can't do that while you're holding the hot asbestos 
                  cup.";

                 i = 0;
                 objectloop (i in player && i ofclass HotIngot) j++;
                 if (j > 0)
                    "You can't do that while you're holding the hot ingot."; }

           Burn:
              if ((second == match && match has light) ||
                  (second ofclass HotIngot) ||
                  (second == asbestos_cup && asbestos_cup has general))
                 "The gloves are flame resistant.";
              rfalse;
        ],
   has  clothing pluralname;
