Room Hall_l "Main Hallway, Sector L"
  with description
    "   This is the station's main corridor, which continues to port and
     starboard. You detect a slight upward curve in the corridor.
     Rooms lie fore and aft.",
    before
    [;
    Look_dir:
    if (noun == fore_obj)
    {
      if (Locale(store, "You can see", "You can also see")) print ".^";
      else "You see nothing of interest.";
 
      if (Bracelet in Fussbudget)
      {
        if (Fussbudget has eating) 
          "Within the room, you can see the Fussbudget, wearing the
           bracelet, greedily devouring a whole crate of Mondoweed fruits.";
        else
          "Within the room, you can see the Fussbudget, wearing the 
           bracelet.";
      }     
 
      if (Fussbudget in Store)
        "Within the room, you can see the Fussbudget.";

      rtrue;
    }
    Examine, Search: ;
    default:
      if (inp1~=1 && noun~=0 && noun in store)
        print_ret (The) noun, " is on the far side of ", (the) Barrier, ".";
      if (inp2~=1 && second~=0 && second in store)
        print_ret (The) second, " is on the far side of ", 
                  (the) Barrier,".";
    ],
    n_to 
    [;if ((Bracelet in Player) && (Bracelet has worn))
      {
        if (Fussbudget in Store)
        {
          lf_loc = Store;
          lp_loc = Store;
        }

        if ((Fussbudget has awake) && (Fussbudget notin Cage))
        {
          give Fussbudget ~scenery;
          StartDaemon(Fussbudget);
        }

        PlayerTo(Store,2);
        Achieved(1);
        rtrue;
      }
      else if ((Bracelet in Fussbudget) || (Fussbudget in Store))
      {
        if (Bracelet in Fussbudget)
        {
          if (Fussbudget has eating) 
            "You bounce off the invisible security barrier.
             A recording says ~Restricted area - identification required.~^
             Within the room, you can see the Fussbudget, wearing the 
             bracelet, greedily devouring a whole crate of Mondoweed 
             fruits.";
          else
            "You bounce off the invisible security barrier.
             A recording says ~Restricted area - identification required.~^
             Within the room, you can see the Fussbudget, wearing the 
             bracelet.";
        }

        if (Fussbudget in Store)
          "You bounce off the invisible security barrier.
           A recording says ~Restricted area - identification required.~^
           Within the room, you can see the Fussbudget.";
     }
      else
        "You bounce off the invisible security barrier.
         A recording says ~Restricted area - identification required.~";
    ],
    s_to Office,
    e_to Hall_m,
    w_to Hall_k;

Object Barrier "invisible security barrier"
  with
    name "invisible" "security" "barrier" "force" "field" "door" "doorway"
         "frame" "hole" "holes" "sensor",
    description 
    [; print "You look at the doorway and can only see thin air. But a close
        examination of the door frame reveals some tiny holes from which 
        beams might be projected. There also seems to be a sensor of some
        kind; for what you're not sure. On the far side of ", (the) Barrier,
        ": ";
        <<SEARCH BARRIER>>;
    ],
    before
    [;Take: "A force field is not something you can carry!";
      Search: 
      if (Location == Hall_l)
      {
        if (Locale(store, "You can see", "You can also see")) print ".^";
        else "You see nothing of interest.";

        if (Bracelet in Fussbudget)
        { 
          if (Fussbudget has eating) 
            "Within the room, you can see the Fussbudget, wearing the
             bracelet, greedily devouring a whole crate of Mondoweed 
             fruits.";
          else
            "Within the room, you can see the Fussbudget, wearing the 
             bracelet.";
        }

        if (Fussbudget in Store)
          "Within the room, you see the Fussbudget.";

        rtrue;
      }
      if (Location == Store)
      {
        if (Locale(hall_l, "You can see", "You can also see")) ".";
        else "You see nothing of interest.";
      }
      ThrownAt, Receive:
      if (noun has worn)
        "You will have to remove ", (the) noun, " first.";
      if (noun == Bracelet)
      {
        if (Location==Hall_l) move Bracelet to Store;
        else move Bracelet to Hall_l;
        print "", (The) Bracelet, " sails through ", (the) Barrier, " landing
               on the deck.";
        if (Fussbudget in Location) 
          print " ", (The) Fussbudget, " moans ~And you through I was 
                 dumb!~";
        "";
      }
      move noun to Location;
      print "", (The) noun, " bounces off ", (the) Barrier, " and drops 
             uselessly on the deck.";
      if (Location == Hall_l)
        " A recording says ~Restricted area - identification required.~";
      "";
    ],
    found_in hall_l store
    has concealed transparent;

Room Store "Store Room"
  with
    name "store" "room",
    description
    "   This is a small storage room of some sort. A hallway lies aft.",
    before
    [;
    Look_dir:
    if (noun == aft_obj)
    {
      if (Locale(hall_l, "You can see", "You can also see")) ".";
      else "You see nothing of interest.";
      
    }
    Examine, Search: ;
    default:
      if (inp1~=1 && noun~=0 && noun in hall_l)
        print_ret (The) noun, " is on the far side of ", (the) Barrier, ".";
      if (inp2~=1 && second~=0 && second in hall_l)
        print_ret (The) second, " is on the far side of ", 
                  (the) Barrier,".";
    ],
    s_to leave_store,
    out_to leave_store,
    has enterable;

[ leave_store;
  if ((Bracelet in Player) && (Bracelet has worn))
  {
    PlayerTo(Hall_l,2);
    rtrue;
  }
  "You bounce off the invisible security barrier.";
];
