Bulkhead Hab_Bulkhead "habitation bulkhead" 
  with
    name "habitation",
    description
    [; if (Hab_Bulkhead hasnt open)
       {
         "Bulkheads are included on space stations and starships for safety, 
         generally they are only closed during some sort of emergency, such 
         as a hull breach. ", (The) self, 
         " is closed. Stencilled on the bulkhead
         in bright yellow letters are the words ~To Habitation Arc~.";
       }
       "Bulkheads are included on space stations and starships for safety, 
        generally they are only closed during some sort of emergency, such as
        a hull breach. ", (The) self, " is battered but open. Stencilled on
        the bulkhead
        in bright yellow letters are the words ~To Habitation Arc~.";
    ],
    before
    [; consult, read: "~To Habitation Arc~"; 
       open, break:
       if (Ram in Player) 
       {
         print "(with ", (the) Ram, ")^";       
         <<UNLOCK SELF RAM>>;
       }
       OpenBulkMsg (); rtrue;    
       unlock, breakwith:
       if (second == Ram)
       {
         if (self has open) "That's already open.";
         give self ~locked;
         give self open;
         "After much creaking and groaning ", (the) Self, " finally
          gives way; amazingly your jerry-built ", (name) Ram,
         " survived the ordeal. You easily open ", (the) Self, 
         " the rest of the way using your hands."; 

       }
       OpenBulkMsg (); rtrue;   
    ],
    with_key Ram,
    found_in Hall_j,
    has lockable locked openable ~open;

Room Hall_j "Main Hallway, Sector J"
  with 
    description
    [; "   This is the station's main corridor, which continues to starboard;
        to port is ", (a) Hab_Bulkhead , ". You detect a slight upward curve
        in the corridor. Rooms lie fore and aft. ", (The) Hab_Bulkhead, 
        " is closed. Stencilled on the bulkhead in bright yellow letters are 
        the words ~To Habitation Arc~.";
    ],
    e_to Hall_k,
    n_to MapRoom,
    s_to TeleportRoom,
    w_to 
    [; if (Hab_Bulkhead hasnt open)
         "You can't, since ", (the) Hab_Bulkhead, " is in the way."; 
 
       print "You head port expecting to find Main Hallway, Sector I 
              - but instead wander into a...^^
       Computer Room^   There are a couple of wiz kids here hacking away at a 
       terminal; next to the terminal you see a can of Quad-o-Caff
       and a monitor apparently displaying statistics acquired by
       the device attached to ", (the) Dispenser, ". It seems most colas are
       sold between 3000 and 6500, although sales are made at all chrons of 
       the day. About twice as many cans are sold on week days.
       ^   One of the wiz kids is wearing thick coke-bottle type glasses; the 
       other has chronic acne. 
       Both look rather pale even though one happens to be 
       Indian. One of them bears an amazing resemblance to Bill Gates during
       one of his all night coding sessions.^";

       if (Fussbudget in Location)
       {
         print "   ", (The) Fussbudget, " gangles into the room and bumps 
         into 'acne', who points to a big sign, which reads ~Any NPC'S 
         found in this area will be permanently REMOVED from the code.~ ", 
         (The)  Fussbudget, " makes a hasty retreat saying as it departs, 
         ~I'm a seasoned actor of 10 years standing and will not suffer the 
         indignity of being snuffed out by a bug in the computer code.~
         [FOOTNOTE: The term bug originated from archaic Sol computers, 
         which were made from relays and valves, where bugs got stuck or 
         fried, thus preventing the equipment functioning properly. The
         first bug was a moth that flew into a huge computer.]^";
         spacetime = spacetime + 20;
       }

       print "   Suddenly 'acne' spots you, 
       while at that same time murmuring to 
       'coke-bottle glasses', ~I thought you said the bulkhead couldn't 
       be opened by hand.~ 'Coke-bottle glasses' replies, ~I said it couldn't 
       be opened WITHOUT a hydraulic ram, and we haven't left one anywhere 
       in the game.~ 'Acne' suddenly twigs, ~He must have MADE one.~ He 
       turns to you, saying, ~Sorry about this NONE Non-Player Character [you 
       know how fond Implementors are of talking in Jargon]; seems to be a 
       bit of a glitch in the code";

       if (Ram in Player)
       {
         print "; you won't be needing that ram anymore.~ Turning to the 
                terminal he types REMOVE RAM; and ", (the) Ram, " instantly 
                disappears from your hands. ";
       }
       else
       {
         print ", better make sure you can't get back in here.~ Turning to 
                  the terminal he types REMOVE RAM. ";
       }

       remove RAM;
       move SpaceForm to Player;
       give Hab_Bulkhead ~open;
       location = Hall_J;
       spacetime=spacetime+33;
       achieved(7);

       print "He then says, ~Better get 
       you out of here; try again when Version 3 comes out; should be fixed 
       by then, but watch out for the Hunger-Crazed Simps; they're a real 
       tough problem to crack. Ah yes, just remembered you'll be needing ", 
       (a) SpaceForm, ", as that's found in this 'arc'.~ He shouts to his 
       companion, ~Make a Spacecraft Form.~ 'Coke-bottle glasses' takes a
       swig from his Quad-o-Caff Can, then dives for 
       the terminal and types MOVE SPACEFORM TO CokeBottleGlasses; 
       the form instantly appears in his hands. 
       He then chucks it at you, but misses even though he was only 
       a couple of feet away. You retrieve it to save him any further 
       embarrassment.";

       if (Zorkmid in Player)
       {
         give Zorkmid general;
         print " ~Wow!~, exclaims Coke-bottle glasses suddenly spotting your
                strange foreign coin, ~A real Zorkmid, they're really rare
                and worth a fortune.~";
       }

       "^   'Acne' types GIVE HAB_BULKHEAD @@126OPEN; LOCATION = 
       HALL_J; on the terminal, and you feel a sense of dislocation...";
    ];

Room TeleportRoom "Teleporter Room"
  with
    description
    "   This is the space station's teleporter room, which is
     used to transport hazardous materials and VIP's (sometimes they are
     one and the same thing). It can also be used to evacuate the crew 
     rapidly in an emergency but at great financial cost
     (due to the vast amount of energy consumed in the process). Although 
     regulations state that the teleporter room must be staffed around the 
     clock, ten chrons per day, there's no one on duty.^   Most of the 
     equipment here is too complicated for anyone without molecular 
     transport training to use. However, the red button of the teleporter 
     control panel is well-marked. There is also a transporter pad here. The
     only exit is fore.",
    n_to Hall_j;

Object -> Teleport "teleport"
  with 
    name "teleport" "teleporter",
    description 
    "   And they said it couldn't be done! Scientists said to record all the 
     information in the human body, you would need a harddisk drive that 
     stretched from the central black hole to one third of the way out to 
     the galactic rim. Clearly nonsense as you don't see too many humanoids 
     that tall, and they didn't of course count on Zeus Zip, with a 
     compression 
     ratio far greater than any previous Zip, for a start the human body is 
     symmetrical so that almost halves the data, then many of the cells are 
     identical etc... The teleport is still of course the most complex 
     object in the universe, even more so than the human brain. Contrary to 
     the opinion of pulp fiction the main use of Teleport technology is not 
     Transport related, but Medical related - the phenomenal amount of 
     energy required makes it a very inefficient means of transportation, 
     and you can't find many live forms who don't have some qualms about 
     having their bodies ripped apart, sent through the ether, and 
     (hopefully!) put back together again correctly, on a daily basis.
     Of course if you're 
     late for the office it's a very handy thing to have, not only getting 
     you there instantly, but giving you a shave, haircut, and your 
     breakfast to boot. If you have a really heavy workload you can even 
     teleport yourself twice, many hands make light work, as they say. 
     Medically, if you damage a body part, all you have to do is load your 
     old code, pop in the Teleport and you're as good as new. Even if you get 
     run over by a bus, it doesn't matter as your last copy can be reloaded.
     ^   This particular Teleporter's prominent features are a Control Panel 
     and a Transporter Pad.",
    before
    [; use: <<USE CONTROLPANEL>>; ],
    has scenery;

Object -> TransporterPad "transporter pad"
  with
    name "pad" "transport" "transporter" "circle",
    initial
    [;if (Fussbudget in TransporterPad)
      {
        print "", (The) Fussbudget, " is on ", (the) TransporterPad, 
              " eagerly awaiting transport."; 
        if (children(TransporterPad) > 1)
        {
          print " Also ";
          move Fussbudget to TeleportRoom;
          <SEARCH TRANSPORTERPAD>;
          move Fussbudget to TransporterPad;
          rtrue;
        }
        else "";
      }    
      if (children(TransporterPad) ~= 0)
        <<SEARCH TRANSPORTERPAD>>;
      "";
    ], 
    description
    [; print "This is basically just two one-metre diameter circles, one on 
              the ceiling and the other on the deck, presumably with some 
              very complex circuitry hidden behind them. All you have to do 
              is stand on the pad to get transported, once it has been 
              activated that is. ";
       self.initial ();
    ],
    before
    [; Take: "That's part of ", (the) teleport, "."; 
       Use: "You can't use that, only get on or off it."; 
       Exit: if (Player notin TransporterPad)
               "You're not on ", (the) TransporterPad, ".";
    ],
    has scenery supporter enterable open;

Object -> ControlPanel "teleport control panel"
  with
    name "control" "controls" "panel" "device" "instrument" 
         "instrumentation",
    description
    "This device controls the Teleport, as you're not a Transporter Chief the 
     only thing you know how to operate is the red button marked 
     ~Energise~.",
    before
    [; Take: "That's part of ", (the) teleport, "."; 
       Use: "You can't even work a video timer, so I don't think you want to 
             be messing with the Teleport delayed activation facility. Not 
             that is, unless you want to end up as spam and eggs. Just stick 
             to with that nice red button.";
       ThrownAt: <<THROWNAT TELEPORTBUTTON NOUN>>;
    ],
    has scenery;

Book -> TeleportButton "red button"
  with
    name "button" "buttons" "big" "red" "energise",
    description
    "It's big, red, and marked ~Energise~.",
    before
    [; Read, Consult: "~Energise~.";

       Push, Use: 
       if (Player in TransporterPad)
         "You can't reach it from ", (the) TransporterPad, ".";
       if (children(TransporterPad)==0)
         "You hear a recorded voice. ~Pad not occupied!~";
       print "You hear a recorded voice. ~Insufficient Energy to operate 
              Teleport as Main Reactor is Off Line, and all systems are 
              running on backup batteries.~";
       if ((Fussbudget in TeleportRoom) || (Fussbudget in TransporterPad))
         give self general;
       if (Fussbudget in TransporterPad) 
       {
         move Fussbudget to TeleportRoom;
         "^^", (The) Fussbudget, " tuts and says, ~Typical.~, getting 
          off ", (the) TransporterPad, ".";
       }  
       "";

       Take: "That's part of ", (the) ControlPanel, "."; 

       ThrownAt:
       if (Player notin TransporterPad)
         "", (The) TeleportButton, " is with in easy reach, why don't you
          just push it?"; 
       if (noun has worn)
         "You will have to remove ", (the) noun, " first.";
       move noun to TeleportRoom;
         "You throw ", (the) noun, " at ", (the) TeleportButton, " but miss
          as it is to far away.";

       Receive:
       if (Player in TransporterPad)
         "You can't reach ", (the) TeleportButton, " from ", 
          (the) TransporterPad, ".";
       if (noun has worn)
         "You will have to remove ", (the) noun, " first.";
       if (noun has big)
       {
         spacetime=spacetime+13;
         "You put ", (the) noun, " on ", (the) TeleportButton, " and 
          hear a recorded voice. ~Malfunction on ", (name) ControlPanel,
         ". Malfunction on ", (name) ControlPanel, ". Malfunction...~
          Infuriated to distration you remove ", (the) noun, " from ",
          (the) TeleportButton, " and the warning ceases.";
       }
       if (noun has huge)
       {
         move noun to Location;
         "", (The) noun, " is to large to stay on ", (the) TeleportButton, 
         " and falls onto the deck. Luckily it seems undamaged.";
       }
       "That's too light to activate the button.";
    ],
    has scenery;

Room MapRoom "Map Room"
  with
    description
    [;"   This appears to be a map room, with a holographic map on each free
       wall. The maps are of this space station, a planetary colony, and a
       space 'elevator'. The only exit is aft.", (note) 3; 
    ],
    s_to Hall_j,
    out_to Hall_j,
    has enterable;

Map -> Spacestation "Space Station Map"
  with 
    Name "space" "station" "spacestation" "small" "red" "flashing" "warning",
    Description 
    "This map on the fore wall looks much like what you saw during your 
     landing. The space station consists of one long corridor in a
     great circle, with the docking bay in the center. 
     The circle is divided into four arcs of roughly equal size, 
     labelled Habitation, Command/Medical, Engineering, and Diplomatic. There 
     is a small red flashing warning under the Engineering Arc, which reads 
     ~Warning. Low level radiation leak. Radiation suits must be worn in 
     this Arc, available from the Habitation Arc. Bulkheads secured.~",
    has scenery;

Map -> Colony "Colony Map"
  with 
    Name "planet" "planetary" "colony" "city" "small" "writing",
    Description
    "This plan on the port wall is for a colony on a large Gaia-Class planet.
     It is situated on the major river of the main continent where the 
     tributaries meet, close to the sea and equator, clearly a strategic 
     location for trade and development. Some small writing under it reads 
     ~Third Galactic Union Planetary Administration Center.~",
     has scenery;

Map -> Elevator "Space Elevator Map"
  with
    Name "space" "elevator" "spaceelevator",
    Description
    "This plan on the starboard wall is for a space 'elevator', this is a 
     device made from four incredibly long, thin, and strong super molecules,
     which stretch from the planetary surface to an orbiting asteroid, 
     specially shipped in to act as an anchor. If not exactly on the equator,
     the planet's rotation would rip it apart. The molecule is so sharp that
     if you passed your fingers over it they would be cut off, even though 
     you can't see it. An electric powered elevator can ascend or descend two
     'wires', with up and down 'tracks'. Much of the energy used in the
     ascent, can be regained in the descent by the use of dynamos, which also
     prevent excessive acceleration. Although this device is incredibly 
     complex and expensive to build, once built it reduces planetary shipping
     costs to a fraction of those of propulsion-powered transport, especially
     on the planet to space route, making Solar System commerce much more
     practical and economic. It also increases safety, and does not subject 
     passengers to excessive G Forces.",
    has scenery;

Room Hall_o "Main Hallway, Sector O"
  with description
    "   This is the station's main corridor, which continues to port and
     starboard. You detect a slight upward curve in the corridor. A room lies 
     fore.",
    e_to Hall_p,
    w_to Hall_n,
    n_to Lab;

Room Lab "Xeno Biology Lab"
  with
    description
    "   This is where alien life forms from the nearby planet are studied,
     for intelligence, aggression, morals and other such attributes which 
     might affect their eligibility for membership in the Third Galactic
     Union. Only planets whose live forms pass all the required tests are 
     offered provisional Xeno Membership. You recall from your boot camp 
     alien orientation module that Xeno derives from a dawn Sol history 
     language, and translates roughly as ~guest-friend~. 
     ^   There are many complicated devices in this room, which you
     wouldn't have a clue how to operate. One in the corner, however, looks
     fairly simple. It has ~Virtual Maze~ stencilled on its side. The only
     exit is aft.",
    s_to Hall_o, 
    out_to Hall_o,
    has enterable;

Object -> Device "complicated devices" 
  with 
    name "complicated" "device" "devices" "button" "buttons" "switch"
         "switches",
    description "You examine the nearest device; it contains lots of buttons,
                 switches, and displays. Unfortunately you don't know what
                 they do. It could be dangerous to play with them. The device
                 appears to have been ~mothballed~.",     
    before
    [;push, switchon, switchoff, play, playwith:
        "All the devices have been mothballed and are currently non
         functional. Only the one in the corner looks serviceable.";
      use: "You fiddle with the nearest device but can't get it to do
            anything so give up. You were never very good with 
            mechanical things."; 
    ],
    has scenery;

Book -> DeviceMonitor "monitor"
  with
    name "display" "displays" "screen" "screens" "VDU" "VDUs" "VDU^s"
         "monitor" "monitors",
    description
    [;"The blank monitors stare back at you, reminding you of your exam 
       papers for advanced astro-dynamics AFTER the exam.
       Lucky you got involved in a few adventures or you would
       never have got promoted.";
    ],
    before
    [;push, switchon, switchoff, play, playwith: <<PUSH DEVICE>>;
      use: <<USE DEVICE>>;
    ],
    has scenery;

Book -> maze "virtual maze"
  with 
    name "virtual" "maze" "black" "box" "writing" "letter" "letters"
         "yellow" "red" "comment" "corner",
    description "This device is basically a black box, with a headset 
                 attached to it. There is some writing on the box.",
    before
    [; use, play: <<USE HEADSET>>;
       playwith: "It's a cheap one player game, the programmer must have
                  been too lazy to implement two player mode.";
       consult, read: 
         "Stencilled on the side in bright yellow letters are the words 
          ~Virtual Maze~; below in smaller red letters, it reads ~Warning!!! 
          Not for human use.~ Someone has scrawled a comment underneath:
          ~Better than magic mushrooms, Man.~";
    ],
    has scenery transparent;

Object -> headset "headset"
  with 
    name "head" "set" "headset",
    description 
    [; "This looks like one of those clever devices that can scan brain 
        patterns, and convert them into signals to control a computer. It
        doesn't look as though it will fit on your head. Especially 
        considering how big it is, your head not ", (the) Headset, "."; ],
    before
    [; play, playwith: "You can't play ", (the) Headset, " but I bet you 
                        could try wearing it.";
       insert: if (second has container)
                 "You can't put ", (the) Headset, " in anything as it is
                  attached to ", (the) Maze, ".";
       puton: if (second == Fussbudget)
              { play_maze (); rtrue; }
       use, wear:
         "You try ", (the) Headset, " on. It doesn't fit! 
          Your head is DEFINITELY TOO BIG!";  
    ],
    has concealed;

Room Hall_p "Main Hallway, Sector P"
  with 
    description
    [;"   This is the station's main corridor, which continues to port; to 
       starboard is ", (a) Eng_Bulkhead, ". You detect a slight upward
       curve in the corridor. Rooms lie fore and aft. ", (The) Eng_Bulkhead,
      " is closed. Stencilled on the bulkhead in bright yellow letters are 
       the words ~To Engineering Arc~, and above it there is a red flashing 
       warning sign.";
    ],
    e_to [;"You can't, since ", (the) Eng_Bulkhead, " is in the way."; ],
    w_to Hall_o,
    n_to CM_SanFac,
    s_to Waiting_Room;

Bulkhead -> Eng_Bulkhead "engineering bulkhead" 
  with
    name "engineering",
    description
    [; "Bulkheads are included on space stations and starships for safety, 
        generally they are only closed during some sort of emergency, such as
        a hull breach. ", (The) self, " is closed. Stencilled on the bulkhead
        in bright yellow letters are the words ~To Engineering Arc~, and
        above it there is a red flashing warning sign.";
    ],
    before
    [; consult, read: "~To Engineering Arc~"; 
       open, break:
       if (Ram in Player) 
       {
         print "(with ", (the) Ram, ")^";       
         <<UNLOCK SELF RAM>>;
       }
       OpenBulkMsg (); rtrue;    
       unlock, breakwith:
       if (second == Ram)
       {
         print "After much creaking and groaning ", (the) Self, " finally
                gives way; amazingly your jerry-built ", (name) Ram,
               " survived the ordeal. As you open ", (the) Self, 
               " you are hit by a blast of radiation, most of which was 
                previously stopped by thick lead lining. You suddenly feel 
                incredibly nauseous, begin vomiting, and all your hair falls 
                out. ";
         deadflag=1;
         if (Fussbudget in Location)
           "", (The) Fussbudget, " comments, ~Now you look better, I never 
           understood why Humans have lots of hair on their heads and so 
           little else where. Or why it grows so quickly. What did you do 
           before scissors? Should be like us, we don't need hair.~ You 
           can't help thinking there are better things you could be 
           discussing during your last moments in the Universe. And to add 
           insult to injury ", (the) Fussbudget, " seems totally unaffected 
           by the Radiation, probably something to do with it's body shell, 
           which looks remarkably like a Scorpion's. You remember some dumb 
           documentary saying that they are the only animals that can 
           survive a Nuclear War, well I guess the documentary was wrong. As
           you lose consciousness the last thing you hear is ", 
           (the) Fussbudget, " complaining how it's meant to get off the 
           Station with out your help.";
         "It seems you have picked up a bad case of radiation poisoning.";
       }
       OpenBulkMsg (); rtrue;   
    ],
    with_key Ram,
    has lockable locked openable ~open;

Book -> Sign "sign" 
  with
    name "red" "flashing" "warning" "writing" "sign",
    description "It has some red flashing writing on it.",
    before
    [; consult, read: "~Warning. Low level radiation leak. Radiation suits 
                       must be worn beyond this point.~";
    ],
    has scenery;

Room CM_SanFac "Command/Medical Arc SanFac"
  with 
    description
    "   This is a moderately luxurious SanFac, with sinks and a pair of
     toilet stalls. The only exit is aft.",
    s_to Hall_p,
    out_to Hall_p,
    has enterable;

Object -> Stall "toilet stall"
  with
    name "stall" "stalls" "toilet" "toilets" "sanfac" "sanitary"
         "facility" "fixture",
    before
    [;enter, use, open, close: 
        "This story doesn't go into that sort of detail."; 
      exit:
        "You're not in ", (a) Stall, ".";
    ],
    has concealed static;

Object -> Sink "sink"
  with
    name "sink" "sinks" "sanfac" "sanitary" "facility" "fixture",
    before
    [;use, switchon, switchoff: 
        "This story doesn't go into that sort of detail."; ],
    has concealed static;

Object -> TrashCan "trash can"
  with
    name "trash" "can" "bin",
    has container openable ~open;    

Object ->-> Rubbish "rubbish"
  with 
    name "rubbish" "garbage", article "some",
    description 
    [;"Just the sort of stuff you would expect to find in a SanFac ",
       (name) TrashCan, ".";
    ],
    before
    [;Search: 
      if (toilet_roll hasnt general)
      {
        give toilet_roll general;
        move toilet_roll to player;       
        "In ", (the) Rubbish, " you find ", (a) toilet_roll, ".";
      }
      Take: "Ick!!! Best to leave all that messy stuff in ", 
             (the) TrashCan, ".";
    ];           

Object Toilet_Roll "empty toilet roll" Stall
  with 
    name "empty" "toilet" "roll", article "an";

Object Dentist_Door "dentist's door" 
  with
    Name "dentist" "dentists" "dentist^s" "door",
    before
    [;examine: print "Written on the door is the word ~Dentist~. 
                      It is currently ";
               if (dentist_door has open) "open.";
               else "closed.";
      enter: player_enter_dentist (); rtrue;
      unlock: if (self has open) "That's already open.";
              if (second == Ram)
                "You know how to open ", (the) self, ", don't you?";
    ],
    door_to
    [; player_enter_dentist (); rtrue; ],
    with_key key,
    found_in Waiting_Room,
    has scenery door openable ~open locked lockable;

[player_enter_dentist;
 if (Dentist_Door hasnt open)
   "You can't, since ", (the) Dentist_Door, " is in the way.";
 if (Location==Waiting_Room) 
 {
   give player visited_dentist;
   if (Fussbudget has visited_dentist)
     "You head port, and enter the dentist's surgery - it's a mess 
     with broken drills and other scary-looking implements, 
     scattered across the deck - and head back, double quick time.";
   else
     "You head port, and enter the dentist's surgery - then you spot 
     a load of drills, hosing, and other scary-looking implements, 
     and head back, double quick time.";
 }
];

Room Waiting_Room "Dentist's Waiting Room"
  with 
    description
    [;print "  This like most dentist's waiting rooms is permeated with an
      atmosphere of tension, anxiety, and unease. The unlucky patients get
      to wait here while a procession of people go in to the dentist, strange
      unsettling noises can be heard, and then the patient returns 
      clutching his mouth and complaining how much it hurts. There is a 
      door on the port wall leading to the dentist's surgery, which is ";
      if (dentist_door has open) print "open.^";
      else print "closed.^"; 
      "   There are chairs here, and a table to house the usual selection of
       out-of-date magazines."; 
    ],
    n_to Hall_p,
    w_to Dentist_Door;

Class_Table -> Magazine_Table "table";

Book ->-> Annual "Children's Annual"
  with
    name "children" "childrens" "children^s" "annual" "book",
    description
      "This is from a popular Children's Holo Program, it describes many
       interesting things they can do to pass their time.",
    before
    [;consult, read: 
      self.state = read;
      "There is an interesting article on how to make a toy space 
       rocket. All you need is a pair of scissors, a washing up liquid 
       bottle, an empty toilet roll, and some sticky back plastic. All 
       you have to do is gather all these components together, and 
       follow the assembly instructions, to MAKE THE SPACE ROCKET.";
    ],
    state other;

Book ->-> Popular_Mechanics "Popular Mechanics Magazine"
  with
    name "popular" "mechanics" "magazine",
    description
      "This magazine prints articles showing you how to make wonderful 
       contraptions from that pile of junk you've got rusting away in your 
       garage. Unfortunately, the items always look a lot better in the
       magazine, than when you build them.",
    before
    [;consult, read:
      self.state = read;
      "There is an interesting article on how to make a hydraulic ram. All 
       you need is some glue, a saw, some wooden boards, some hydraulic 
       fluid, a syringe, some hosing, and a couple of bars. All
       you have to do is gather all these components together, and follow 
       the assembly instructions, to MAKE THE HYDRAULIC RAM.";
    ],
    state other;

Book ->-> Galactic_Enquirer "Galactic Enquirer"
  with
    name "galactic" "enquirer" "magazine", article "The",
    description
      "This magazine takes great delight in snopping into the private lives 
       of celebrities, and politicians. It uses the word allegedly an 
       inordinate number of times, perhaps this is why not one of the 
       mountain of law suits against it has ever succeeded.",
    before
    [;consult, read:
      "There is a lurid article on the Third Galactic Union's Foreign 
       Minister. Clearly dealing with all those Barbarian Kingdoms of the 
       Outer Darkness has taken its toll. What other reason could there be 
       for such acts?";
    ];

Book ->-> SF_Book "Encyclopaedia of Science Fiction"
  with
    name "encyclopaedia" "of" "science" "fiction" "book", article "The",
    description
      "Wow an interesting book in a Dentist's Waiting Room, that's a first. 
       It's a real Gem, detailing the early history of Classic Sol Science 
       Fiction. Very rare I suspect.",
    before
    [;consult, read:
      "The book begins by saying that the genre of Science Fiction began with 
       ~Frankenstein~ by Mary Shelley in 1818. Previous stories of 
       mechanical man and resurrection go back many thousands of years, 
       but these are based in the world of myth, magic, and the gods - not 
       Science - notable examples being the Greek Legends and the story of 
       Christ. Other notable stories and authors are listed including:^^

       ~From the Earth to the Moon~ by Jules Verne in 1865.^
       ~The Time Machine~, ~The Invisible Man~ and ~The War of the Worlds~ 
       by H.G.Wells in 1895/97/98.^
       ~Rossum's Universal Robots~, a play by Karel Capek in 1921 - this is 
       when the term Robot was first used, deriving from the Czech words 
       ~robotnik~ meaning workman and ~robota~ meaning compulsory labour.^
       ~Metropolis~ by Thea von Harbou in 1926.^
       ~Amazing Stories Quarterly~, a Science Fiction magazine of short 
       stories, was first published in 1928, its most famous editor, John 
       W. Campbell, Jr., joining in 1937.^
       ~Nineteen Eighty-Four~ by George Orwell in 1949.^ 
       ~I, Robot~, and ~The Foundation Trilogy~ by Isaac Asimov in
       1950/51/52/53, where he detailed the Three Laws of Robotics. For many 
       years, only the second could be applied ~a robot must follow 
       orders~, until technology advanced enough to allow the human brain to 
       be mapped, copied, and reconstructed, thus giving robots real 
       intelligence. After all the human brain is the most complex object in
       the known universe. But the laws certainly made for interesting 
       plots.^  
       ~A Fall of Moondust~, ~2001: A Space Odyssey~, ~The City and the 
       Stars~, and ~Rendezvous with Rama~ by Arthur C. Clarke in 
       1961/68/73.^^

       You flick through the remaining pages and a couple of pictures catch 
       your eye. One is of a square-chinned super hero, with a 
       well-proportioned pouting beauty clinging to him, eyeball to eyeball 
       with an evil-looking man in Oriental garb. The caption reads, ~Flash! 
       Arh ha... he's for every one of us.~ The other is of a curly-haired
       man with a long scarf, next to a blue telephone box, facing a number
       of tank like creatures screaming ~exterminate~. The text below goes
       on to explain that TARDIS stands for ~Time and Relative Dimension in 
       Space~, that the word DA-LEK originated from looking at 
       encyclopaedia covers (DA and LEK), and that their first enemies the 
       KALED are an anagram of DALEK. It also goes on to say that it is well 
       known that the Daleks were modelled on the Nazis.";
     ];

Object hosing "hosing"
  with
    name "hose" "hosing" "tubing", article "some",
    description "This looks like it was used to suck saliva out of patients
                 mouths, or something equally unsavoury.",
    has big;

Object bits "drills and implements"
  with
    name "drill" "drills" "implement" "implements";

Object fore_obj "north wall" compass
  with name "n" "north" "f" "fore" "wall", door_dir n_to,
    before
    [;examine: if (Location == Hall_l)  <<SEARCH BARRIER>>;
               if (Location == MapRoom) <<EXAMINE SPACESTATION>>;
    ],
    has scenery;

Object port_obj "west wall" compass
  with 
    name "w" "west" "p" "port" "wall", door_dir w_to,
    before
    [;examine: if (Location == Hall_j)  <<EXAMINE BULKHEAD>>; 
               if (Location == MapRoom) <<EXAMINE COLONY>>;

    ],
    has scenery;

Object aft_obj "south wall" compass
  with name "s" "south" "a" "aft" "wall", door_dir s_to
    has scenery;

Object starboard_obj "east wall" compass
  with 
    name "e" "east" "sb" "starboard" "wall", door_dir e_to,
    before
    [;examine: if (Location == Hall_p)  <<EXAMINE BULKHEAD>>; 
               if (Location == MapRoom) <<EXAMINE ELEVATOR>>;
    ],
    has scenery;

Object floor "deck" compass
  with
    name "d" "down" "floor" "deck" "stain" "stains", door_dir d_to,
    before
    [; rub: "Didn't you have enough of doing that when you were an Ensign?";   
       examine: if (carpet in Location)
                  <<EXAMINE CARPET>>; 
                if (Location == TeleportRoom)
                  "There is ", (a) TransporterPad, " on the deck.";
                "The deck is covered in stains, some Ensign has been slacking
                 off. That WILL be going in the report, after all you spent 
                 enough time cleaning decks, it's someone else's turn now.";
    ],
    has scenery;

Object ceiling "ceiling" compass
  with
    name "u" "up" "ceiling", door_dir u_to,
    before
    [; examine: if (Location == TeleportRoom)
                  "There is ", (a) TransporterPad, " on the ceiling.";
                "Totally ordinary looking ceiling.";
    ],
    has scenery;
