!--------------------------------------------------------------------------
!
!   biplatform-mapchar.h
!
!   Version 0.02, May 6th, 2003
!   By Wouter ten Brink <wouter@elements.nl>
!
!   Maps accented letters (or textual representations of those) to their
!   corresponding internal character codes for ZSCII and Glulx.
!
!   For more information about problems with charactersets in
!   cross-platform Inform sourcecode see:
!   http://www.firthworks.com/roger/glulx/chars.html
!
!   Yes, I know it's ugly, but it's the best we have until Glulx supports
!   Inform's escape sequences :)
!
!--------------------------------------------------------------------------
!
!   CharPrint(<arg>)
!       - Will print the character code and returns true
!       - Can also be used as a print rule (thanks to Roger Firth for
!         pointing me to this)
!
!   CharFunc(<arg>)
!       - Will return the character code which you can print
!
!   You can use any supported (Windows!) accented letter as argument:
!   '', '', '', '', etc.
!
!   Other than a (Windows) accented letter as argument you can use
!   sequence-like representations of the accented letters:
!      'L:a' for  (A diaeresis)
!      'U/E' for  (E acute)
!
!   Or you can even use representation like HTML Latin-1 entities:
!      'L-iuml' for  (i diaeresis)
!      'L-ntilde' for  (n tilde)
!
!   The leading L and U mean Lowercase and Uppercase.
!
!--------------------------------------------------------------------------
!
!   Examples:
!   =========
!   print"De waard lijkt ge", (CharPrint) '', "nteresseerd.^";
!   print"De waard lijkt ge", (string)CharFunc('L:i'), "nteresseerd.^";
!   print"De waard lijkt ge"; CharPrint('L-iuml'); print"nteresseerd.^";
!
!   Will all output on all platforms and on both Z-Machine and Glulx:
!   "De waard lijkt genteresseerd.^"
!
!--------------------------------------------------------------------------

system_file;

[ MapChar letter x;
#ifdef TARGET_GLULX;
	switch(letter)
	{
		'', 'U`A', 'U-Agrave'	: x = "@@192";				!  (A grave)
		'', 'U/A', 'U-Aacute'	: x = "@@193";				!  (A acute)
		'', 'U^A', 'U-Acirc'	: x = "@@194";				!  (A circumflex)
		'', 'U~A', 'U-Atilde'	: x = "@@195";				!  (A tilde)
		'', 'U:A', 'U-Auml'	: x = "@@196";				!  (A diaeresis)
		'', 'UoA', 'U-Aring'	: x = "@@197";				!  (A ring)
		'', 'L`a', 'L-agrave'	: x = "@@224";				!  (A grave)
		'', 'L/a', 'L-aacute'	: x = "@@225";				!  (A acute)
		'', 'L^a', 'L-acirc'	: x = "@@226";				!  circumflex
		'', 'L~a', 'L-atilde'	: x = "@@227";				!  (A tilde)
		'', 'L:a', 'L-auml'	: x = "@@228";				!  (A diaeresis)
		'', 'Loa', 'L-aring'	: x = "@@229";				!  (A ring)

		'', 'UAE', 'U-AElig'	: x = "@@198";				!  (AE ligature)
		'', 'Lae', 'L-aelig'	: x = "@@230";				!  (ae ligature)

		'', 'U,C', 'U-Ccedil'	: x = "@@199";				!  (C cedilla)
		'', 'L,c', 'L-ccedil'	: x = "@@231";				!  (c cedilla)

		'', 'U`E', 'U-Egrave'	: x = "@@200";				!  (E grave)
		'', 'U/E', 'U-Eacute'	: x = "@@201";				!  (E acute)
		'', 'U^E', 'U-Ecirc'	: x = "@@202";				!  (E circumflex)
		'', 'U:E', 'U-Euml'	: x = "@@203";				!  (E diaeresis)
		'', 'L`e', 'L-egrave'	: x = "@@232";				!  (e grave)
		'', 'L/e', 'L-eacute'	: x = "@@233";				!  (e acute)
		'', 'L^e', 'L-ecirc'	: x = "@@234";				!  (e circumflex)
		'', 'L:e', 'L-euml'	: x = "@@235";				!  (e diaeresis)

		'', 'U`I', 'U-Igrave'	: x = "@@204";				!  (I grave)
		'', 'U/I', 'U-Iacute'	: x = "@@205";				!  (I acute)
		'', 'U^I', 'U-Icirc'	: x = "@@206";				!  (I circumflex)
		'', 'U:I', 'U-Iuml'	: x = "@@207";				!  (I diaeresis)
		'', 'L`i', 'L-igrave'	: x = "@@236";				!  (i grave)
		'', 'L/i', 'L-iacute'	: x = "@@237";				!  (i acute)
		'', 'L^i', 'L-icirc'	: x = "@@238";				!  (i circumflex)
		'', 'L:i', 'L-iuml'	: x = "@@239";				!  (i diaeresis)

		'', 'U~N', 'U-Ntilde'	: x = "@@209";				!  (N tilde)
		'', 'L~n', 'L-ntilde'	: x = "@@241";				!  (n tilde)

		'', 'U`O', 'U-Ograve'	: x = "@@210";				!  (O grave)
		'', 'U/O', 'U-Oacute'	: x = "@@211";				!  (O acute)
		'', 'U^O', 'U-Ocirc'	: x = "@@212";				!  (O circumflex)
		'', 'U~O', 'U-Otilde'	: x = "@@213";				!  (O tilde)
		'', 'U:O', 'U-Ouml'	: x = "@@214";				!  (O diaeresis)
		'', 'U\O', 'U-Oslash'	: x = "@@216";				!  (O slash)
		'', 'L`o', 'L-ograve'	: x = "@@242";				!  (o grave)
		'', 'L/o', 'L-oacute'	: x = "@@243";				!  (o acute)
		'', 'L^o', 'L-ocirc'	: x = "@@244";				!  (o circumflex)
		'', 'L~o', 'L-otilde'	: x = "@@245";				!  (o tilde)
		'', 'L:o', 'L-ouml'	: x = "@@246";				!  (o diaeresis)
		'', 'L\o', 'L-oslash'	: x = "@@248";				!  (o slash) 
		
		'U-OE'					: x = "OE";					! OE (OE ligature)
		'L-oe'					: x = "oe";					! oe (oe ligature)

		'', 'U`U', 'U-Ugrave'	: x = "@@217";				!  (U grave)     
		'', 'U/U', 'U-Uacute'	: x = "@@218";				!  (U acute)     
		'', 'U^U', 'U-Ucirc'	: x = "@@219";				!  (U circumflex)
		'', 'U:U', 'U-Uuml'	: x = "@@220";				!  (U diaeresis) 
		'', 'L`u', 'L-ugrave'	: x = "@@249";				!  (u grave)     
		'', 'L/u', 'L-uacute'	: x = "@@250";				!  (u acute)     
		'', 'L^u', 'L-ucirc'	: x = "@@251";				!  (u circumflex)
		'', 'L:u', 'L-uuml'	: x = "@@252";				!  (u diaeresis) 

		'', 'U/Y', 'U-Yacute'	: x = "@@221";				!  (Y acute)
		'', 'L/y', 'L-yacute'	: x = "@@252";				!  (y acute)
		'', 'L:y', 'L-yuml'	: x = "@@252";				!  (y diaeresis) 

		'', 'UEt', 'U-ETH'		: x = "@@208";				!  (Eth)
		'', 'Let', 'L-eth'		: x = "@@240";				!  (eth)
		'', 'UTh', 'U-THORN'	: x = "@@222";				!  (Thorn)
		'', 'Lth', 'L-thorn'	: x = "@@254";				!  (thorn)
		'', 'ss', 'szlig'		: x = "@@223";				!  (ss)

		'', '!!', 'iexcl'		: x = "@@161";				!  (inverted !)
		'', '??', 'iquest'		: x = "@@191";				!  (inverted ?)
		'', '<<', 'laquo'		: x = "@@171";				!  (left guillemet)
		'', '>>', 'raquo'		: x = "@@187";				!  (right guillemet)

		'-c', 'cent'			: x = "@@162";				!  (cent)
		'LL', 'pound'			: x = "@@163";				!  (pound)
		'xo', 'curren'			: x = "@@164";				!  (currency)
		'-y', 'yen'				: x = "@@165";				!  (yen) 

		'_s', 'sect'			: x = "@@167";				!  (section)
		'_p', 'para'			: x = "@@182";				!  (paragraph/pilcrow)
		'_c', 'copy'			: x = "@@169";				!  (copyright)
		'_r', 'reg'				: x = "@@174";				!  (registered) 

		default: x = "?";
	}
#ifnot;    ! TARGET_ZCODE;
	switch(letter)
	{
		'', 'U`A', 'U-Agrave'	: x = "@@186";				!  (A grave)
		'', 'U/A', 'U-Aacute'	: x = "@@175";				!  (A acute)
		'', 'U^A', 'U-Acirc'	: x = "@@196";				!  (A circumflex)
		'', 'U~A', 'U-Atilde'	: x = "@@208";				!  (A tilde)
		'', 'U:A', 'U-Auml'	: x = "@@158";				!  (A diaeresis)
		'', 'UoA', 'U-Aring'	: x = "@@202";				!  (A ring)
		'', 'L`a', 'L-agrave'	: x = "@@181";				!  (A grave)
		'', 'L/a', 'L-aacute'	: x = "@@169";				!  (A acute)
		'', 'L^a', 'L-acirc'	: x = "@@191";				!  circumflex
		'', 'L~a', 'L-atilde'	: x = "@@205";				!  (A tilde)
		'', 'L:a', 'L-auml'	: x = "@@155";				!  (A diaeresis)
		'', 'Loa', 'L-aring'	: x = "@@201";				!  (A ring)

		'', 'UAE', 'U-AElig'	: x = "@@212";				!  (AE ligature)
		'', 'Lae', 'L-aelig'	: x = "@@211";				!  (ae ligature)

		'', 'U,C', 'U-Ccedil'	: x = "@@214";				!  (C cedilla)
		'', 'L,c', 'L-ccedil'	: x = "@@213";				!  (c cedilla)

		'', 'U`E', 'U-Egrave'	: x = "@@187";				!  (E grave)
		'', 'U/E', 'U-Eacute'	: x = "@@176";				!  (E acute)
		'', 'U^E', 'U-Ecirc'	: x = "@@197";				!  (E circumflex)
		'', 'U:E', 'U-Euml'	: x = "@@167";				!  (E diaeresis)
		'', 'L`e', 'L-egrave'	: x = "@@182";				!  (e grave)
		'', 'L/e', 'L-eacute'	: x = "@@170";				!  (e acute)
		'', 'L^e', 'L-ecirc'	: x = "@@192";				!  (e circumflex)
		'', 'L:e', 'L-euml'	: x = "@@164";				!  (e diaeresis)

		'', 'U`I', 'U-Igrave'	: x = "@@188";				!  (I grave)
		'', 'U/I', 'U-Iacute'	: x = "@@177";				!  (I acute)
		'', 'U^I', 'U-Icirc'	: x = "@@198";				!  (I circumflex)
		'', 'U:I', 'U-Iuml'	: x = "@@168";				!  (I diaeresis)
		'', 'L`i', 'L-igrave'	: x = "@@183";				!  (i grave)
		'', 'L/i', 'L-iacute'	: x = "@@171";				!  (i acute)
		'', 'L^i', 'L-icirc'	: x = "@@193";				!  (i circumflex)
		'', 'L:i', 'L-iuml'	: x = "@@165";				!  (i diaeresis)

		'', 'U~N', 'U-Ntilde'	: x = "@@209";				!  (N tilde)
		'', 'L~n', 'L-ntilde'	: x = "@@206";				!  (n tilde)

		'', 'U`O', 'U-Ograve'	: x = "@@189";				!  (O grave)
		'', 'U/O', 'U-Oacute'	: x = "@@178";				!  (O acute)
		'', 'U^O', 'U-Ocirc'	: x = "@@199";				!  (O circumflex)
		'', 'U~O', 'U-Otilde'	: x = "@@210";				!  (O tilde)
		'', 'U:O', 'U-Ouml'	: x = "@@159";				!  (O diaeresis)
		'', 'U\O', 'U-Oslash'	: x = "@@204";				!  (O slash)
		'', 'L`o', 'L-ograve'	: x = "@@184";				!  (o grave)
		'', 'L/o', 'L-oacute'	: x = "@@172";				!  (o acute)
		'', 'L^o', 'L-ocirc'	: x = "@@194";				!  (o circumflex)
		'', 'L~o', 'L-otilde'	: x = "@@207";				!  (o tilde)
		'', 'L:o', 'L-ouml'	: x = "@@156";				!  (o diaeresis)
		'', 'L\o', 'L-oslash'	: x = "@@203";				!  (o slash) 
		
		'U-OE'					: x = "@@221";				! OE (OE ligature)
		'L-oe'					: x = "@@220";				! oe (oe ligature)

		'', 'U`U', 'U-Ugrave'	: x = "@@190";				!  (U grave)     
		'', 'U/U', 'U-Uacute'	: x = "@@179";				!  (U acute)     
		'', 'U^U', 'U-Ucirc'	: x = "@@200";				!  (U circumflex)
		'', 'U:U', 'U-Uuml'	: x = "@@160";				!  (U diaeresis) 
		'', 'L`u', 'L-ugrave'	: x = "@@185";				!  (u grave)     
		'', 'L/u', 'L-uacute'	: x = "@@173";				!  (u acute)     
		'', 'L^u', 'L-ucirc'	: x = "@@195";				!  (u circumflex)
		'', 'L:u', 'L-uuml'	: x = "@@157";				!  (u diaeresis) 

		'', 'U/Y', 'U-Yacute'	: x = "@@180";				!  (Y acute)
		'', 'L/y', 'L-yacute'	: x = "@@174";				!  (y acute)
		'', 'L:y', 'L-yuml'	: x = "@@166";				!  (y diaeresis) 

		'', 'UEt', 'U-ETH'		: x = "@@218";				!  (Eth)
		'', 'Let', 'L-eth'		: x = "@@216";				!  (eth)
		'', 'UTh', 'U-THORN'	: x = "@@217";				!  (Thorn)
		'', 'Lth', 'L-thorn'	: x = "@@215";				!  (thorn)
		'', 'ss', 'szlig'		: x = "@@161";				!  (ss)

		'', '!!', 'iexcl'		: x = "@@222";				!  (inverted !)
		'', '??', 'iquest'		: x = "@@223";				!  (inverted ?)
		'', '<<', 'laquo'		: x = "@@163";				!  (left guillemet)
		'', '>>', 'raquo'		: x = "@@162";				!  (right guillemet)

		'-c', 'cent'			: x = "(cent)";				!  (cent)
		'LL', 'pound'			: x = "@@219";				!  (pound)
		'xo', 'curren'			: x = "(currency)";			!  (currency)
		'-y', 'yen'				: x = "(yen)";				!  (yen) 

		'_s', 'sect'			: x = "(section)";			!  (section)
		'_p', 'para'			: x = "(paragraph)";		!  (paragraph/pilcrow)
		'_c', 'copy'			: x = "(c)";				!  (copyright)
		'_r', 'reg'				: x = "(r)";				!  (registered) 

		default: x = "?";
	}
#endif;    ! TARGET_

	return x;
];

[ CharPrint letter; print (string)MapChar(letter); rtrue; ];
[ CharFunc letter; return MapChar(letter); ];
