/* Analizador lxico de Nmesis */

cifra [0-9]
letra [a-z]
letram [A-Z]
entero {cifra}+
ident {letra}({cifra}|{letra})*
aka {letram}({cifra}|{letram})*
nonsense [ \t\n]
saltar {nonsense}+
operador "+"|"-"|";"|"*"|"/"|"("|")"|"="|"<"|">"|","

%{
int numlinea=0;
char aaa;
%}
/*

<comentario>"*""/" {BEGIN 0; }
<comentario>. {};
<comentario>" " {};
<comentario>\n {};
"/""*" { BEGIN comentario; }
*/

%Start binario comentario

                           	
%%



"/""*" { while (1) /*saltar comentario */
		{
		aaa=input();
		while (aaa!='*')
			{
			if (aaa=='\n') numlinea++;
			aaa=input();
			}
		if (input()=='/') break;
		}
       }
	

quitar {return TQUITAR;}		
ret {return TRET;}
y {return TY;}
oo {return TO;}
verbo {return TVERBO;}
sub {return TVERBO;}
usa {return TUSA;}
entero {return ENTERO;}
cadena {return CADENA;}
global {return TGLOBAL;}
cierto {return TCIERTO;}
falso {return TFALSO;}

\n {numlinea++;}
imprime {return TIMPRIME;}
si {return TSI;}
fsi {return TFINSI;}
sino {return TSINO;}

lee_entero {return TLEEENTERO;}
lee_cadena {return TLEECADENA;}
lee_salida {return TLEESAL;}
pon_salida {return TSETSAL;}
pon_desc {return TSETDESC;}
lee_desc {return TLEEDESC;}
obj_desc {return TOBJDESC;}
pon_obj_flag {return TPONOBJFLAG; }

obj_num {return TOBJNUM;}
obj_tiene {return TOBJTIENE;}
obj_esta {return TOBJESTA;}
obj_limbo {return TOBJLIMBO;}
obj_cogible { return TOBJCOGIBLE; }
lee_obj_flag { return TLEEOBJFLAG; }

cadenacontenida {return TCADENACONTENIDA;}

lleno {return TLLENO;}
obj_a_jug {return TOBJAJUG;}
obj_a_loc {return TOBJALOC;}
obj_a_limbo {return TOBJALIMBO;}
pon_obj_desc {return TSETOBJDESC;}




mientras {return TMIENTRAS;}
fmientras {return TFMIENTRAS;}
no {return TNO;}


{ident} {strcpy(yylval.cadena,yytext); return TID; }
{aka} { strcpy(yylval.cadena,yytext); return AKA; }
{entero} {yylval.entero=atoi(yytext); return TENTERO; }
{operador} { return yytext[0]; }
{nonsense} ;
"'" {
		{
		int i=0;
		char c=input();
		
		while (c!='\'')
			{
			yylval.cadena[i++]=c;
			c=input();
			}
		
		yylval.cadena[i]='\0';
		return TCADENA;
		}
	}
		
		

%%

yywrap()
{
return 1;
}