/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   JmmmConv.h: Conversation Library Header File.
 */

#ifndef JMMMCONV_H
#define JMMMCONV_H

/******************************************************************************
 *
 *   Topic Property Sets
 *   Props: Ask, Tell, Show, Give, AskFor, Greet, Recall, Before, After, Init
 *   Topic: The JmmmTopic object.
 *
 */

#define withTopic(topicName) propertyset #@topicName ## '*' (topic, issuer, actor, *)

/******************************************************************************
 *
 *   Enumerations
 */

enum Ask, Tell, Show, Give, AskFor, Greet, Recall, Before, After, Init;

/******************************************************************************
 *
 *   Topic template
 */

Topic template 'vocabWords_' 'name';

/******************************************************************************
 *
 *   DeclareTopic Macro
 *   Declares the actor property addresses to be used during conversation
 */

#define DeclareTopic(name, vocab, text) \
name##Topic: JmmmTopic vocab text \
    AskProp = &##name##Ask \
    TellProp = &##name##Tell \
    ShowProp = &##name##Show \
    GiveProp = &##name##Give \
    AskForProp = &##name##AskFor \
    GreetProp = &##name##Greet \
    RecallProp = &##name##Recall \
    BeforeProp = &##name##Before \
    AfterProp = &##name##After \
    InitProp = &##name##Init \

#endif // JMMMCONV_H
