/* FIRST THINGS FIRST - topics.t
/*  Copyright (c) 1996, 1997, 1999, 2000, 2001 by J. Robinson Wheeler. All Rights Reserved. */

/* Extra consultWords objects */

past: Topic
	sdesc = "past"
	noun = 'past'
	
	verDoChange( actor ) = 
	{
		if ( timeMachine.location ) 
		{
			if ( global.timeLoc < 3 )
				"You are likely already doing so just by being here. ";
			else
				"You will have to go to the past to do that. ";
		}
		else
			"You don't know how to do that. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
			 	"Fred says, \"The past? I dunno, I don't like to think about
				it. I didn't have too good a childhood. My dad used to drink
				and stuff. Had to get out, start my own life. I made a promise
				to myself to live a good life, you know? Not like -- ah, well.\" ";
				return( true );
			case Laura:
			 	"Laura says, \"Well, this is hardly the place to tell you all
				about my notorious past...\" She looks serious for a moment and
				then bursts into a big grin. \"I'm just kidding! I couldn't be
				more boring.\" ";
				return( true );
			case PLaura:
				"Laura says, \"When I was little, I used to dream about
				what my life would be, how far I could get if I listened
				to my heart and used my brain. It's gotten me here, but
				I'm not sure I like where it's leading. If only when I
				was just starting out, I'd -- oh, never mind. That's 
				getting a little personal. Forget I said anything.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"The past. The past...\" Her focus drifts
				far away, presumably back in time. \"Yes, that's what this
				conversation is all about, isn't it? Seizing the chance to
				change one's past?\" ";
				return( true );
			case Architect:
		 	 	"He says, \"What's past is past, as they say. I like to keep
				my mind on the present. For example, this blueprint.\" ";
			case FFred:
				"\^<<FFred.thedesc>> goes quiet for a minute, then says, 
				\"Don't talk to me about the past. You can't change the past! 
				You can't change anything. Ah, just leave me be, willya? 
				Dunno why you want to talk to an old drunk like me anyway.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

future: Topic
	sdesc = "future"
	noun = 'future'
	state = 0
	
	verDoChange( actor ) = 
	{
		"Everything you do changes the future. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"The future? Heck, I bet in ten years I'll be 
				the manager of this place. Maybe I'll even own the franchise.
				Sure, I'll have a big house, the wife and kids. Yeah.\" ";
				return( true );
			case Laura:
				"Laura says, \"Well, after I go to business school -- or maybe
				law school, I haven't decided yet -- I figure I'll be able to
				do whatever I want. But you never know what the future will
				bring!\" ";
				return( true );
			case PLaura:
				"Laura says, \"I visited a fortune teller once. She told
				me that, if I wanted it, I could reach the top of the 
				world. Then she said that I shouldn't want that. I got
				angry at her, I'm not even sure why. It just sounded 
				phony, you know? Heck, I could do worse than reaching
				the top, you know? I should have such problems.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"I have no future. Not one I can face. But
				let me tell this in my own way.\" ";
				return( true );
			case Architect:
		 		"He says, \"I always like to think ahead, but I'm always 
		 		surprised by what the future brings.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

paradoxes: Topic
	sdesc = "paradoxes"
	isThem = true
	noun = 'paradoxes'
	adjective = 'paradoxes' 'third' 'theory'
	askingAboutMe( who ) =
	{
		switch( who )
		{
			default: 
				return( nil );
		}
	}
;

freeWill: Topic
	sdesc = "free will"
	noun = 'will'
	adjective = 'free'
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				"Laura frowns. \"What a strange thing to ask about,\" she
				says. \"Free will. That would mean that when we make choices,
				we're free to make wrong ones as well as right ones.\" She
				shivers, even though it's warm, and rubs her arms. ";
				return( true );
			case FFLaura:
				"Laura says, \"If I didn't believe in our ability to make
				different choices, you wouldn't be here today.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

timeTravel: Topic
	sdesc = "time travel"
	noun = 'travel'
	adjective = 'time' 'time-travel' 'two' 'main' 'theories'
	
	verDoTime( actor ) = 
	{ 
		if ( timeMachine.location )
		{
			if ( Me.location = platform || Me.location = timeMachine.location )
				"You need to tell me how to do that. ";
			else
				"You need a time machine to do that. ";
		}
		else
			"You don't know how to do that. ";
	} 
	tellAboutMe( who ) = { return( self.askingAboutMe( who ) ); }
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Time travel, eh? I used to watch a lot of Doctor
				Who. I'm not really into science fiction stuff any more, though.\" ";
				return( true );
			case Laura:
				"Laura looks at you with a mixture of fascination and 
				cluelessness. \"Time travel, huh! Wow.\" She fiddles with her
				hair. \"Do you think that's possible? I guess maybe someday
				they could figure that out. It's over my head, though!\" ";
				Laura.askedAboutKey := true;
				return( true );
			case PLaura:
				"Laura says, \"If I could go back in time and change one
				thing, I'd -- hm.\" She stops short of answering the 
				question. ";
				return( true );
			case FFLaura: 
				"Laura looks at you carefully. \"I'm getting to that,\" 
				she says simply. ";
				return( true );
			case Architect:
				"He barely looks up. \"Sorry, what? Time travel? That's a bit
				beyond me. I like to deal with the real world.\" ";
				return( true );
			case squirrel:
				"The squirrel stares at you sagely, and then scratches his
				belly. ";
				return( true);
			case youngMan:
				"You get the feeling that he knows all about it without
				your having to say anything. ";
				return( true );
			case securityGuard:
				"You start to tell the guard about time travel and how you got
				here, but she cuts you off.\b
				\"I'm not the least bit interested,\" she says. ";
				return( true );
			case workers:
				"You fail to even get their attention. ";
				return( true );
			case teller:
				"He listens with rigid politeness, then interrupts. \"May I
				help you with a withdrawal or a deposit today, sir?\" ";
				return( true );
			case antiqueMerchant:
				"She listens, nodding with a friendly smile. \"That's 
				nice,\" she says. \"Let me know if you would like to
				sell or buy any antiques today.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

sex: Topic
	sdesc = "sex"
	noun = 'sex'
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				"Laura says, \"Sex is -- complicated. Naturally, I don't
				know you well enough to talk about it, so I'm surprised
				you brought it up. Let's just say, sometimes it's not
				worth it.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"Sex is the last thing on my mind.\" She
				regards you strangely. \"Or maybe it's what all of this
				is all about. Seduction. Favors. Sex as a tool, sex as
				a weapon. Sex as negotiation. Sex as bargaining. Sex as --
				loss.\" Her voice trails away. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

conclusion: fixedBlock, floatingItem
	sdesc = "conclusion"
	ldesc =
	{
		local s;
		
		s := global.score;
		if ( s < 20 ) 
			"The conclusion of the story is quite far away. ";
		else if ( s < 40 ) 
			"The conclusion of the story is far down the line. ";
		else if ( s < 60 ) 
			"You are nowhere near the conclusion of the story. ";
		else if ( s < 80 ) 
			"The conclusion of the story is getting closer, but 
			you still can't see it from here. ";
		else if ( s < 100 ) 
			"The conclusion of the story is getting quite near,
			but still isn't here yet. ";
		else if ( s < global.maxscore ) 
			"The conclusion of the story is almost upon you. You'll see 
			it shortly. ";
		else "You are currently experiencing the conclusion of the story, 
				as it happens. ";
	}
	noun = 'conclusion' 'conclusions'
	location = { return( Me.location ); }
	verDoLeapTo( actor ) = 
	{
		"Rash thinking will get you nowhere. ";
	}
;

fredsRent: block
	noun = 'rent'
	adjective = 'his'
	location = nil
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"We all gotta pay the rent.\" ";
				return( true );
			case Laura:
				"Laura says, \"We all have to pay the rent.\" ";
				return( true );
			case Architect:
				"He says, \"Well, of course, you won't be paying rent. You
				will have to make mortgage payments, but that's not really
				my department, is it?\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

job: fixedBlock
	sdesc = "job"
	noun = 'job' 'career'
	adjective = 'his' 'her' 'terrible'
	location = nil
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Well, there are worse jobs, I guess. This one
				pays the rent, and it's not too bad. Free sandwiches and 
				stuff. Hey, it's a living, huh? Yeah.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, this is just my summer job. I'm going to
				go back to school in the fall, and get my degree in education,
				and then go and teach somewhere. Probably back up in the city.
				My mom thinks I should go to business school, or maybe become
				a lawyer, but I'm not sure I want to do that.\" ";
				return( true );
			case PLaura:
				"Laura says, \"That's a touchy subject right now. This was
				just supposed to be a summer job, you know? When I started
				out, that's all it was. Now it's a career. I was supposed
				to go back to school -- I still plan to. It just keeps
				getting put off and put off and -- you know how that goes?
				I mean, it's ten years now, and they're talking about 
				promoting me again. It's like I have to be grateful and
				I have to accept it, because I'm getting breaks that young
				women just never get, but it's all going too fast, and --\"
				She sighs. \"And options are closing when they're supposed
				to be opening.\" ";
				return( true );
			case FFLaura: 
				"Laura goes silent. \"My career,\" she says. \"You're looking
				at the soiled fruits of it. You're looking at the shell of
				a woman, hollowed out as a result of career choices she 
				made long ago.\" ";
			case Architect:
				"He says, \"I love my job. And I'm damn good at it, too, if I
				say so myself.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

salesTax: Topic
	sdesc = "tax"
	noun = 'tax'
	adjective = 'sales'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"Sales tax. Just one of those things.\" ";
				return( true );
			default:
				return( nil );
		}
	}
;

melody: Topic
	sdesc = "melody"
	noun = 'melody'
	adjective = 'half' 'remembered' 'whistling'
	listenDesc = 'You have heard it before, you think, but you can\'t quite place it. '
	
	verDoSing( actor ) = 
	{
		"You attempt to sing a bit of the melody, but you can't place it,
		either. ";
	}
	verDoWhistle( actor ) = 
	{
		"You whistle a bit of the melody, but you can't place it, either. ";
	}
	verDoWhatIs( actor ) =
	{
		"You have heard it before, you think, but you can't quite place it. ";
	}
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Heh. I don't really remember what it is. I
				didn't even realize I was whistling it.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

keepingSandwichesHot: Topic
	sdesc = "keeping sandwiches hot"
	adjective = 'heating' 'sandwiches'
	topicDesc = { self.sdesc; }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Keeping a hot sandwich hot when you're on the
				go is a big problem in my business. I used to do deliveries
				for this place, and I'll tell you my secret. You stick the
				sandwich under the hood, and the engine keeps it hot. Works
				great as long as, um, you keep it sealed up so it doesn't 
				get polluted or anything. Now since your car's not working,
				I dunno what to tell you. Maybe you've got some other hot
				engine you can use as a heating compartment.\" ";
				return( true );
			case Laura:
				"Laura says, \"You need some kind of toaster oven if you 
				want to keep a hot sandwich hot.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

raisingMoney: Topic
	sdesc = "raising money"
	adjective = 'raising' 'money'
	topicDesc = { self.sdesc; }
	value = 1
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"What can I tell ya? If you're low on cash,
				and you know of a store that buys stuff -- hey, do I have
				to do the math? I bet you own tons of old stuff you could sell
				to make some quick money.\" ";
				return( true );
			case Laura:
				"Laura says, \"I love taking things to antique stores. You never
				know what you may own that's worth something as an antique! 
				Maybe you'd even have enough you could sell to open an account 
				here, which is what you ought to be doing instead of talking to 
				me all morning.\" 
				\bShe gives you a big smile. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

alcoholism: Topic
	sdesc = "alcoholism"
	topicDesc = { self.sdesc; }
	noun = 'alcoholism' 
	adjective = 'drinking' 'drink' 'alcoholics'
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I drink a little bit, after work. I mean, a
				couple of shots of whiskey, maybe four or five beers. I mean,
				that's not too much, right? That's normal, huh?\" 
				\bFred says, \"Sorry, I don't know why I'm telling you this.
				I guess I'm trying to tell myself I'll be all right, huh? You
				know, sometimes I wish I could see myself in the future, so
				that I knew I was going to turn out all right. I think I will,
				I mean, I hope so. I mean...\" \b
				Fred puts on a cheerful face. \"Hey, I'm just talking. Talk
				talk talk. Maybe you should tell me something I don't know.\" ";
				return( true );
			case Laura:
				"Laura says, \"If you know anyone with alcoholic tendencies,
				you really need to confront them. Hold them up to a mirror.
				Let them see what you see in their future. No one needs to
				end up miserable and sick if they can possibly change the
				way they're living their lives.\" \b
				\bLaura says, \"Sorry for the soapbox lecture. This is getting
				a little personal for me. Let's talk about something less 
				heavy.\" ";
				return( true );
			case PLaura:
				"Laura's face darkens. She says, \"I'd rather not talk 
				about that.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"I was an alcoholic for about twenty years,
				starting in my mid-twenties. For the usual reasons. It's
				a very boring subject to me now. Not that I wouldn't
				change things if I could do it over again, but I'm
				getting to that.\" ";
			default: 
				return( nil );
		}
	}
;

newFuture: Topic
	sdesc = "a new and better future"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	adjective = 'new' 'future'
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"If you can create a new and better future,
				hey -- I'd love to visit it. Maybe I'll seeya there.\" 
				\bFred shrugs his broad shoulders and gives you a wink. ";
				return( true );
			case Laura:
				"Laura says, \"A new and better future. I'd love to see
				such a thing come to pass. Maybe we'll all be better off
				in it.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"I'm less interested in a new future than
				in a new past. But I'm getting to that.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

gettingIntoFutureHouse: Topic
	sdesc = "getting into your house"
	thedesc = { self.sdesc; }
 	askingAboutMe( who ) =
	
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"It's too bad you can't get into your
				house. But I can see into the future -- I can see you
				finding a way in -- in the future!\" 
				\bHe throws his head back and laughs. \"Ah, I'm just
				kidding ya. I can't even see into my own future, much
				less yours.\" ";
				return( true );
			case Laura:
				"Laura says, \"Sorry you're locked out of your house.
				Maybe in the future you won't have this problem.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;	

laurasHair: Topic
	sdesc = "Laura's hair"
	noun = 'hair'
	adjective = 'her' 'laura\'s' 
	
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Laura: 
				"Laura says, \"Oh, I'm sorry. Was I fidgeting? I have
				a habit of playing with my hair when I'm distracted. Not
				that what you're saying isn't interesting!\" ";
				return( true );
			default: 
				return( nil );
		}
	}
	
;

RollingStones: Topic
	sdesc = "the Rolling Stones"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	noun = 'topic'
	adjective = 'rolling' 'stones'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Laura:
				"Laura says, \"Actually, I don't know much about the
				Rolling Stones, either!\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
DoctorWho: Topic
	sdesc = "Doctor Who"
	noun = 'show' 'series'
	adjective = 'doctor' 'drwho' 'dr' 'who'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred: 
				"Fred says, \"Yeah, I used to be all into that when I was
				a kid. EX-TER-MI-NATE, EX-TER-MI-NATE! But that stuff's
				just corny now.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
StarWars: Topic
	sdesc = "Star Wars"
	noun = 'wars'
	adjective = 'star'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred: 
				"Fred says, \"Cool movie.\" ";
				return( true );
			case Laura:
				"Laura says, \"I've never heard of it.\" ";
				return( true );
			case PLaura:
				"Laura says, \"What? Oh that. I don't really go to the
				movies much. I don't have the time or the energy.\" ";
				return( true );
			case Architect:
				"He says, \"To be honest, I haven't seen it. To be even
				more honest, I don't want to see it after all of the jokes
				people have made about my name.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
Chewbacca: Topic
	sdesc = "Chewbacca"
	noun = 'chewbacca'
	adjective = 'chewie' 'wookie' 'architect\'s' 'his' 'name' 'peter' 'mayhew'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred: 
				"Fred says, \"I like a Wookie.\" ";
				return( true );
			case Laura:
				"Laura says, \"Who?\" ";
				return( true );
			case PLaura:
				"Laura says, \"Who?\" ";
				return( true );
			case Architect:
				"He scowls and pretends not to know who you're talking
				about. ";
				return( true );
			default: 
				return( nil );
		}
	}
;
scienceFiction: Topic
	sdesc = "science fiction"
	noun = 'fiction'
	adjective = 'science'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"Science fiction's okay I guess. I used to
				read a lot. You know, because my Dad couldn't stand it if
				I was running around or making noise or whatever. He'd --
				well, anyway, so I read a lot of books. Don't really care
				about that any more, though. At some point you gotta grow
				up.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
France: Topic
	sdesc = "France"
	noun = 'france'
	adjective = 'trip' 'europe' 'vacation'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"France, shmance. Think you'll find a good
				sandwich in France? Think again!\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, the trip to France was just great. I 
				can't wait to go back. Just another year or so at this
				desk, and I'm out of here!\" ";
				return( true );
			case PLaura:
				"Laura says, \"Oh, I'm still planning to go back to 
				France. I've got a month of vacation days saved up, but
				I won't have a chance to use them for another six months.
				Maybe a year. But I'm definitely going.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"I remember when I started out, my goal was
				to earn enough to take a trip to Europe. It was always 
				next year, then the year after that, then the year after
				that. Now, of course, I can fly wherever I want to, but
				I no longer have the desire. Thirty years ago, thirty
				five -- that was when I should have done it. But my
				career came first.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
FredsMother: Topic
	sdesc = "Fred's mother"
	noun = 'mother' 'ma' 'mom'
	adjective = 'fred\'s' 'his'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"My mother. My mother. I tell you, she was
				a peach. Just a saint on Earth. Why she --\" He pauses. 
				\"I just don't know why she put up with --\" \b
				
				He spends a long, silent moment rubbing a cloth across
				the countertop. \"Well, it's done now.\" ";
				return( true );
			case FFred:
				"\^<<FFred.thedesc>> says, \"Don't talk about my mother!
				Don't you talk about her! I'll kiggyergoddam ass you talk
				about her again.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
FredsDad: Topic
	sdesc = "Fred's Dad"
	noun = 'dad' 'father'
	adjective = 'fred\'s' 'his'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"What a sorry sonofa-- ehh. What do you 
				wanna know? That he drank all day long, smacked around
				his family, never held down a decent job till the glorious
				fricking day he finally dropped dead? Hell, let me tell you
				about my Dad. Yeah. Tell you that if there's one thing I'm
				not going to do with this life of mine is follow in dear
				old Dad's footsteps.\" ";
				return( true );
			case FFred:
				"\^<<FFred.thedesc>> lets out a hoarse laugh that turns into
				a wet, spitting cough. \"This one's for you, Dad,\" he says,
				swilling from his bottle. ";
				return( true );
			default: 
				return( nil );
		}
	}
;
swimming: Topic
	sdesc = "swimming"
	noun = 'pool'
	plural = 'pools'
	adjective = 'swimming'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"Speaking of swimming, you know there used to
				be this great little swimming hole -- heck, I guess it wasn't
				much more than a pond, but I was a lot smaller then. It was
				back in the woods, about twenty years ago, a little creek
				that pooled in this grotto. I used to sneak off there when
				I needed to get away from home for a while. You could dive
				down, way down, but I was always afraid I wouldn't come back
				up so I never saw where it led. Then we had all those hot,
				dry summers in a row and all of it dried up and never came
				back. Ah well.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
theCity: Topic
	sdesc = "city"
	noun = 'city'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"I never go to the city much. I grew up out
				here in the boonies. Or the suburbs now, I guess you'd call
				them.\" ";
				return( true );
			case Laura:
				"Laura says, \"I guess the way things are going, someday the
				city will grow its way out here. It'll be sad to see all the
				trees cut down, but progress is progress.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
recycling: Topic
	sdessc = "recycling"
	noun = 'recycling'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Laura:
				"Laura says, \"People need to think more about preserving
				the natural state of things. There's all this beautiful
				countryside full of old trees around. The saddest thing I
				can think of is that someday they'll pave over all of this.
				I keep thinking, maybe I can get into a position where I can
				do something about that before it's too late.\" ";
				return( true );
			default: 
				return( nil );
		}
	}	
;
stockmarket: Topic;

laurasproblems: Topic
	sdesc = "problems"
	noun = 'problem' 'trouble'
	plural = 'problems' 'troubles'
	isThem = true
	adjective = 'laura\'s' 'her'
	location = PLaura
	
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case PLaura: 
				"Laura says, \"I'm just wondering about my future,
				that's all. It's a long story.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"I'm trying to tell you all about them,
				if you'll listen.\" ";
			default: 
				return( nil );
		}
	}
;

PLauras_pensiveness: Topic
	sdesc = "pensiveness"
	noun = 'pensiveness'
	adjective = 'pensive'
	location = PLaura
	
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case PLaura: 
				"Laura says, \"I'm just wondering about my future,
				that's all. It's a long story.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

devil: Topic
	sdesc = "the Devil"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	noun = 'devil' 'satan'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"Hate to meet him in a back alley.\" ";
				return( true );
			case FFred:
				"\^<<FFred.thedesc>> says, \"Yer lookin at him, baby!\" ";
				return( true );
			case Laura:
				"Laura says, \"What a weird thing to ask about! Anyway,
				gosh. I guess if there's a God there must be a Devil, 
				right? I don't think he wears red and has horns or stuff.
				I think it's more -- like, a symbol? Like the Devil stands
				for a whole bunch of stuff that bad people do, or that makes
				people do the wrong thing.\" ";
				return( true );
			case PLaura:
				"Laura says, \"I've met him. He's handsome. Rich, too.\" She
				pauses and then says, \"Just kidding,\" but she doesn't
				sound like it. ";
				return( true );
			case FFLaura:
				"Laura says, \"I'm trying to tell you all I know, dear.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

God: Topic, floatingItem
	sdesc = "God"
	thedesc = "God"
	adesc = "God"
	ldesc = "God is for the most part unexaminable. "
	noun = 'god'
	isHim = true
	location = { return( Me.location ); }
	
	verDoThank( actor ) = {}
	doThank( actor ) = 
	{
		"You thank God. ";
	}
	verDoSearch( actor ) = 
	{
		"Ineffable. ";
	}
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"If He shows up, I'll believe in Him. How
				about that?\" ";
				return( true );
			case FFred: 
				"\^<<FFred.thedesc>> says, \"Course there's a goddam God.
				You live like I do, you know. You goddam know it.\" ";
				return( true );
			case Laura:
				"Laura says, \"Well, sure, I believe in God. It's kind of
				comforting to know He's there, somewhere, looking out for
				you.\" ";
				return( true );
			case PLaura:
				"Laura says, \"That's a rather personal question.\" She
				stares down at her feet. \"You're a young girl, you have
				dreams and prayers, secret prayers, and you wait and wait
				for an answer. Where is it? Where is He?\" ";
				return( true );
			case FFLaura:
				"Laura says, \"Look around you. Do you think I know the
				first thing about knowing God? You think He's everywhere?
				I'll tell you this: there's places He doesn't go. You think
				He's here, now, in this room? I drove Him away long ago.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
	itnomdesc = { "He"; }
	itobjdesc = { "Him"; }
	itisdesc = { "He's"; }
	itselfdesc = { "Himself"; }
	thatdesc = { self.itobjdesc; }
;

hell: Topic
	sdesc = "Hell"
	noun = 'hell'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"You're fulla creepy questions tonight,
				ain'tcha?\" ";
				return( true );
			case FFred:
				"A manic look enters his eyes. \^<<FFred.thedesc>> says, \"Hell's 
				here. Hell's everywhere. Hell's moving into town. You'll see. You'll 
				see it, right here where we're sitting. Hell on Earth. I can see it 
				now. I feel the heat!\"\b
				
				You take a couple of steps back. ";
				return( true );
			case Laura:
				"Laura says, \"Oh, I don't really believe in Hell, to be honest.\" ";
				return( true );
			case PLaura:
				"Laura says, \"I'd prefer not to believe in it.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"Open your eyes, dear.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

heaven: Topic
	sdesc = "Heaven"
	noun = 'heaven'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"That's where Ma is.\" ";
				return( true );
			case FFred:
				"\^<<FFred.thedesc>> says, \"Ain't never seen it. Ain't
				never gonna see it.\" ";
				return( true );
			case Laura:
				"Laura says, \"I picture it as this beautiful city in the
				clouds, with music and singing and where everyone is happy
				and everything is pretty.\" ";
				return( true );
			case PLaura:
				"Laura says, \"I'm a little too grown up to believe in
				fairy tales.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"I've spent my whole life walking in the
				opposite direction from it.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

dibbleBitsStock: Topic, stockItem
	sdesc = "DibbleBits"
	adjective = 'dibblebits' 'dibble' 'bits' 'company'
	myMerchant = PLaura
	cost = 5000
	shares = 20000
	sayPrice = "25 cents a share"
	
	handleStockPurchase = 
	{
		local totalWealth;
		
		totalWealth := global.money + account.P;
		
		"Laura types for a moment on her computer. ";
		
		if ( self.isOwned ) 
		{
			"Laura says, \"Hang on, you're already a shareholder in <<self.sdesc>>. I
			really don't advise you to buy any more shares at this time.\" ";
			return;
		}
		else if ( self.cost <= account.P )
		{
			"\"Well, you seem to have enough money in your account now. I guess
			I was wrong about that. Still, I think investing what you have is the
			way to go.\" ";
			
			"Laura says, \"Okay, you're all set. At <<self.sayPrice>>, you now 
			own <<self.shares>> shares of <<self.sdesc>> stock. Hope it helps 
			you out down the road.\" ";
			
			account.P -= self.cost;
			self.isOwned := true;
			incscore( 5 );
			global.scoreCard[22] := 1;
			housekeeping( nil );			// hack for score notification
		}
		else if ( self.cost <= totalWealth )
		{
			"\"You only have $<<account.P>> in your account right now. If you have
			more you can deposit, you should do that so that I can handle the 
			transfer electronically. The teller should help you with that. Then
			come back and talk to me about <<self.sdesc>>.\" ";
		}
		else 
		{
			"\"I hate to break it to you, but you're going to need five thousand
			dollars before I can make any investments for you. I wish I could help
			you come up with it, but I can't.\" ";
		}
	}
		
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Too late to buy that now. Me, I don't trust
				the stock market. I like to know where my money is.\" ";
				return( true );
			case Laura:
				"Laura says, \"I'm not the best source of financial advice,
				sorry.\" ";
				return( true );
			case PLaura:
				self.handleStockPurchase;
				return( true );
			case FFLaura:
				"Laura says, \"The little tech company that made good. I 
				tried to organize a takeover of them ten years ago, and it
				blew up in my face. ";
				if ( dibbleBitsStock.isOwned )
					"Of course, you were somehow prescient enough to buy
					it long before that, as I recall. Another of your 
					little miracles of -- timing.\" ";
				else
					"Who would have known?\" She fixes a strange gaze on
					you. ";
				return( true );
			default: 
				return( nil );
		}
	}
	
	tellAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Huh. Well, what can I tell ya? If you think
				it's gonna go somewhere, buy it now. Not that I know the
				first thing about buying stock. You think I'd be selling
				sandwiches if I was some kind of financial whiz?\" ";
				return( true );
			case Laura:
				"Laura says, \"Well, if you're that sure about it,
				buy as much of it as you possibly can, is my advice.\" 
				She gives you a big smile. ";
				return( true );
			case PLaura:
				return( true );
			case FFLaura:
				return( true );
			default: return( nil );
		}
	}
;

lotharioCorp: Topic, stockItem
	sdesc = "Lothario Corporation"
	ldesc = 
	{
		switch( Me.location )
		{
		}
	}
	adjective = 'lothario' 'corp' 'corporation' 'co' 'inc' 'word'
	myMerchant = PLaura
	cost = 5000
	shares = 100
	sayPrice = "50 dollars a share"
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Too late to buy that now. Me, I don't trust
				the stock market. I like to know where my money is.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, Lothario Corp. I was thinking maybe I'd get a 
				job there once I got my business degree. That company gives me
				the creeps, though. The way they keep taking over everything.\" ";
				return( true );
			case PLaura:
				self.handleStockPurchase;
				return( true );
			case FFLaura:
				"Laura says, \"I think this place speaks for itself.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
	
	tellAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Huh. Well, what can I tell ya? If you think
				it's gonna go somewhere, buy it now. Not that I know the
				first thing about buying stock. You think I'd be selling
				sandwiches if I was some kind of financial whiz?\" ";
				return( true );
			case Laura:
				"Laura says, \"Well, if you're that sure about it,
				buy as much of it as you possibly can, is my advice.
				But gosh, isn't that stock really expensive? I could
				never afford it. Besides, that company gives me the
				creeps for some reason.\" ";
				return( true );
			case PLaura:
				return( true );
			case FFLaura:
				return( true );
			default: return( nil );
		}
	}	
;

finances: Topic
	sdesc = "finances"
	noun = 'finance' 
	plural = 'finances'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case PLaura: 
				if ( self.location != PLaurasOffice )
				{
					"Laura says, \"Your money is going to run out sooner or
					later. Now, don't panic, it's not going to be next month
					or next year. But honestly, you're going to lose everything
					unless you start making some investments. I just don't know
					that you even have the money to get started.\" ";
				}
				else
				{
				}
				return( true );
			default: 
				return( nil );
		}
	}
;

investments: Topic
	sdesc = "investments"
	noun = 'investment'
	plural = 'investments'
	isThem = true
	adjective = 'investing'
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case PLaura: 
				"Laura says, \"What you'd need is about five thousand
				dollars. I'm sorry, I know that's a lot, but if you 
				trust me with it, I could invest it for you and turn it 
				into more, a lot more. Enough to ensure that you'd never 
				lose this house, which I'm afraid is the way it'll turn 
				out if you don't take steps now.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

aboutthebank: Topic;

askingAboutLaura: Topic
	sdesc = "Laura"
	adjective = 'laura' 'remick' 'her' 'herself' 'remick-larson'
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hey, I know her. I think she still lives around
				here, because she buys sandwiches sometimes. Yeah, Laura, right?
				She seems nice. I think she's in law school now, or business 
				school, or something.\" ";
				return( true );
			case Architect:
				"He says, \"I don't know her, sorry.\" ";
				return( true );
			case teller:
				switch( global.timeLoc )
				{
					case 1:
						"He says, \"Oh, she seems nice enough, I suppose.\" ";
						break;
					case 2: 
						if ( !PLaurasOffice.changed )
							"He smiles and says, \"She's great, isn't she?\" He
							lowers his voice and says, \"Of course, she's my boss
							now, so I have to say that.\" He winks. ";
						else
							"He looks at you blankly. \"Who? I don't know
							anyone by that name here.\" ";
						break;
				}
				return( true );
//			case Carl:
//			case LaurasSecretary:
			case securityGuard:
				"The guard looks at you coldly and says, \"Ms. Remick-Larson 
				is not expecting any visitors today.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

askingTellerAboutLauraEtc: Topic;

askingFFredAboutSandwichesEtc: Topic;

laurasSister: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
laurasMom: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FLaura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
meeting: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
reportOnVistaBankMerger: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FLaura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
VistaBank: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FLaura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
merger: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FLaura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
lettersToLaurasBoyfriend: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FLaura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
LaurasBoyfriend: Topic
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FLaura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;
mortgage: Topic
;

LaurasExHusband: Topic
	adjective = 'ex-husband' 'larson' 'grant'
	askingAboutMe( who ) =
	{
		switch( who )
		{
			case PLaura:
				return( true );
			case Laura:
				return( true );
			case FLaura:
				return( true );
			case FFLaura:
				return( true );
			default:
				return( nil );
		}
	}
;

plans: Topic
	sdesc = "plans"
	noun = 'plans'
	adjective = 'his' 'her'
	isThem = true
	
	verDoMake( actor ) = 
	{
		"It's up to you to make your own plans. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"My plans? Heck, I bet in ten years I'll be 
				the manager of this place. Maybe I'll even own the franchise.
				Sure, I'll have a big house, the wife and kids. Yeah.\" ";
				return( true );
			case Laura:
				"Laura says, \"Well, after I go to business school -- or maybe
				law school, I haven't decided yet -- I figure I'll be able to
				do whatever I want. But you never know what the future will
				bring!\" ";
				return( true );
			case PLaura:
				"Laura says, \"Plans. Who has time for plans? I guess I've given
				up trying to think where I want to go, I'm too busy dealing with
				what's happening now. I keep thinking that if I just save a 
				little more, work a little harder, I'll have earned some free
				time to do what I really want to do with my life.\" ";
				return( true );
			case FFLaura:
				"Laura says, \"I'm getting to that.\" ";
				return( true );
			case Architect:
				"(the blueprint)\n";
				return( blueprint.askingAboutMe( Architect ) );
			default: 
				return( nil );
		}
	}
;

variousStock: Topic, stockItem
	sdesc = "that stock"
	adesc = "a random stock"
	thedesc = "some other stock"
	adjective = 'microsoft' 'apple' 'ibm' 'dell' 'compaq' 'gateway' 'hightech' 'high'
		'tech' 'hi-tech' 'high-tech' 'intel' 'sony' 'time' 'warner' 'time-warner'
		'aol' 'motorola' 'some' 'other' 'stock'
	myMerchant = PLaura
	cost = 5000
	shares = 20000
	sayPrice = "25 cents a share"
	
	handleStockPurchase = 
	{
		"Laura says, \"I'm sorry, I can't help you invest in <<self.sdesc>>.\" ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Me, I don't trust the stock market. I like to 
				know where my money is.\" ";
				return( true );
			case Laura:
				"Laura says, \"I'm not the best source of financial advice,
				sorry.\" ";
				return( true );
			case PLaura:
				self.handleStockPurchase;
				return( true );
			default: 
				return( nil );
		}
	}
	
	tellAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Huh. Whatever. I don't know the
				first thing about buying stock. You think I'd be selling
				sandwiches if I was some kind of financial whiz?\" ";
				return( true );
			case Laura:
				"Laura says, \"I can't really help you with investments.\" ";
				return( true );
			case PLaura:
				"Laura looks confused and says, \"Sounds like you know 
				something about that company that I don't, but I can't help 
				you invest in that stock, sorry.\" ";
				return( true );
			default: return( nil );
		}
	}
;



/* eof */
