// MARS

mars: room
	sdesc = "Alley"
	ldesc = "You are in a small alley in a city on terraformed Mars.  The air,
		while cool and dusty, is breathable.  There is a road at the head of the 
		alley to the north.  The cylinder is here, cheerfully glowing. "
	north = {mcity.moveInto(road2); return(road2);}
	in = shipin
;

mcylin:  decoration
	sdesc = "large glowing cylinder"
	isopen = true
	noun = 'cylinder' 'ship' 'craft'
	adjective = 'large' 'glowing'
	location = mars
	ldesc = "The cylinder is about 30 feet in height and width.
		It is very shiny and is glowing slightly.  There is a passage 
		leading into its interior as well."
	verDoGo(actor) = {}
	doGo(actor) = {Me.travelTo(shipin);}
	verDoEnter(actor) = {}
	doEnter(actor) = {Me.travelTo(actor);}
;

mcity: decoration
	sdesc = "martian city"
	ldesc = "The city around you looks exactly how you imagined a futuristic city to look like.  
		The buildings are all built in some deranged art decco style complete with swirling spires and 
		skyscrapers."
	noun = 'city' 'buildings' 'building'
	adjective = 'martian'
	location = mars
;

road2: room
	sdesc = "Road"
	ldesc = {
		"You are walking along a busy east-west road in a large city.  There is an entrance to an open alley to the south. ";
		if (suit.isworn or icesuit.isworn)
			"\n\tPeople are giving you strange looks.  It might be because you are 
		the only one wearing a space suit on a completely hospitable planet.";
		}
	south = {mcity.moveInto(mars); return(mars);}
	east = {mcity.moveInto(road3); return(road3);}
	west = {mcity.moveInto(road1); return(road1);}
;

road1: room
	sdesc = "Road"
	ldesc = {
		"You are walking along a busy east-west road in a large city.  There is a 
		major gathering of people to the west of here completely blocking the road.  
		Cries of \"Hallelujah!\" and \"Amen!\" burst forth from the crowd every so often.
		To the south is an open doorway into a store.  Above the doorway is a large gaudy sign. ";
		if (suit.isworn or icesuit.isworn)
			"\n\tPeople are giving you strange looks.  It might be because you are the only one wearing a space suit on a 
			completely hospitable planet.";
		}
	south = {
		if(pillsrus.beenhere)
			{
			"\bFred notices your entry. \"Ah!  A familiar face.  Good to see you again.\"\b";
			}
			return(pillsrus);
		}
	east = {mcity.moveInto(road2); return(road2);}
	west = {
		crowd.doGo(Me);
		return(nil);
		}
	
;

store: decoration
	sdesc = "store"
	ldesc = "The store looks like an old style antique store.  There is a doorway into the store to the south.  Over the 
		doorway is a large sign."
	noun = 'store' 'pills r us'
	location = road1
;

sign: decoration, readable
	sdesc = "large gaudy sign"
	ldesc = "The gaudy gold and red sign almost completely covers the store front.  It reads \"PILLS R US\""
	noun = 'sign'
	adjective = 'large' 'gaudy'
	location = road1
;

crowd: decoration
	sdesc = "large crowd"
	ldesc = "It is a large crowd of people.  Everyone seems to be paying to attention to 
		something or someone in the center of the mob."
	noun = 'crowd'
	adjective = 'large'
	location = road1
	inalrea = nil
	verDoWalkinto(actor) = {}
	doWalkinto(actor) = {self.doGo(actor);}
	verDoEnter(actor) = {}
	doEnter(actor) = {self.doGo(actor);}
	verDoGo(actor) = {}
	doGo(actor) = { if (not self.inalrea)
			{
			"You push your way through the crowd to see what the hoopla is 	
			about.\b\tIn the center of the mob, a tan, brown curly haired human 
			dressed in a Hawaiian shirt and Bermuda shorts is preaching to the crowd.\b\t
			\"Friends, at the time of ten to the minus thirty three seconds after the big bang, the heat was enormous.\"\n\t
			\"It was over ten to the thirty two degrees,\" someone in the crowd calls out.\n\t
			\"Yes! Matter and energy coexisted!\"\n\t
			\"Hallelujah!\" someone else replies.\n\t
			\"Then the universe, expanding away, started to cool...\"\b\t
			You step out of the crowd very confused.\b";
			self.inalrea := true;
			return (nil);
			}
			else
			{
			"You think about entering the crowd again, but you don't feel like hearing any more of the sermon.\b";
			return(nil);
			}
			}
	verDoListento(actor) = {}
	doListento(actor) = {
				if (not self.inalrea)
				"The crowd seems very excited about something.  You can 
				make out one voice above the rest but you cannot tell what it 
				is saying.  Maybe if you entered the crowd you could hear it	better.";
				else
				"They are really eating up what that guy is saying, aren't they?";
			}
;

pillsrus: room
	enterRoom(actor) = {
		notify(fred, &actorDaemon, 0);
		pass enterRoom;
		}
	beenhere = nil
	sdesc = "Pills R Us"
	ldesc = {
		"Every wall of the store is coved with empty glass pill bottles. A 
		small sign above the door says in friendly letters \"NO REFUNDS.\" Near the back of the store is 
		a small counter. The 
		only exit is out of the store is to the north.\n";
		if (not self.beenhere)  
			{
			"\tAs you enter, a small tone rings out and an extremely tall creature 
			that looks like a cross between an antelope and
			a aardvark steps out from the back of the store and walks behind a counter.\n\t
			\"Hello,\" it says, \"Welcome to Pills R Us.  I am Fred a Zoltarian pill merchant. 
			If you need any help just ask.\"\b";
			self.beenhere := true;
		}
		}
	north = {
		self.beenhere := true;
		return(road1);
		}
;

pcounter: fixeditem, surface
	sdesc = "store counter"
	location = pillsrus
	noun = 'counter'
	adjective = 'store'
;


fred: Actor
	noun = 'Fred' 'him' 'himself'
	sdesc = "Fred"
	adesc = "Fred"
	thedesc = "Fred"
	ldesc = "Fred is easily ten feet in height and looks like someone decided to see what 
		would happen if you crossed an antelope and an aardvark."
	location = pillsrus
	stp = nil
	isHim = true
	actorAction(v, d, p, i) =
		{
		if (v=helloVerb)
			{
			"\"Hello, to you as well.\" ";
			 exit;
			}
		if (v= attackVerb)
			{
			"Fred gives a nonchalant sigh and pushes a button under the counter.  Lasers throughout the store activate 
			and focus on you.\n\t\"Like it?  It is the latest in security devices.  They have been selling a 
			ton of these every since lethal security measures were made legal.\"\n\t With that, the lasers fire and turn you into 
			lump of charcoal.";
			die();
			}
		if (v = followVerb)
			{
			"\"Sorry I have to mind my store.\" ";
			exit;
			}
		 if(d = Me)
			{
			"Fred looks at you confused.  \"Why would I want to do that to a customer?\"";
			exit;
			}
		"Fred gives you a confused look. \"I don't understand what you are saying.\" ";
		}
	verDoAskAbout (actor, iobj)= {}
	doAskAbout (actor, iobj) =
		{
		switch(iobj)
			{
			case pstore:
			{
			"\"We have a wide variety of pills, tablets and 
				capsules for all occasions. Our most 
				popular being, ahem, libido  encouragement.  Normally
			I would have a full stock of all my pills and capsules, but this is 
			spring break for those at the university and they bought almost my 
			entire stock, especially the libido encouragement tablets.  But don't  
			fret I do have one bottle of strength enhancement capsules left.\" ";
			labpills.moveInto(pillsrus);
			exit;
			}
			case pills: 
			{
			"\"We have a wide variety of pills, tablets and 
				capsules for all occasions. Our most 
				popular being, ahem, libido  encouragement.  Normally
			I would have a full stock of all my pills and capsules, but this is 
			spring break for those at the university and they bought almost my 
			entire stock, especially the libido encouragement tablets.  But don't  
			fret I do have one bottle of strength enhancement capsules left.\" ";
			labpills.moveInto(pillsrus);
			exit;
			}
			
			case strpills:
			{
			if (not self.stp)
				{
				"\"Ah yes!\" Fred says as he get a small bottle off a high shelf and places it on the counter,
				 \"These strength capsules will enable you to lift 
				mountains.  Unfortunately they don't last very long.  But tell you what, I can sell you the 
			whole bottle of one thousand for one thousand marsmids.  That's one marsmid per capsule if 
			you wish to buy separately.\" ";
				self.stp := true;
				strpills.moveInto(pcounter);
				exit;
				}
			else
				{
				"\"One strength capsule for one marsmid, the whole bottle for a thousand.\" ";
				exit;
				}
			}
			case labpills:
				{
				if(labpills.location = pillsrus)
					"\"Well, um, as I said the ";
				else
					{
					"Well, um, the ";
						labpills.moveInto(pillsrus);
					}
			"university students bought me out of those.  I should be getting a new 
			shipment next month.\" ";
				
				exit;
				}
			case fred:
				{
				 "\"Why me?  I am just a simple Zoltarian pill merchant.\" ";
				exit;
				}
			case zoltar:
				{
				"Fred sighs, \"Ah, my homeworld. It was a very beautiful place before the sun went supernova.  
			Now my people live and make our living in this system.\" ";
				exit;
				}
			case  crowd:
			{
			"\"Oh them.  Every time that preacher comes into town he draws a 
		crowd.  He tends to be good for business since he keeps people near my shop.\"";
			exit;
			}
		default:
		"I am afraid I don't know anything about that.";
		}
		}
	actorDesc = {
			"Fred is here watching you while dusting the shelves.";
			}
	verIoGiveTo(actor) = {}
	ioGiveTo(actor, dobj) =
			{
			if (dobj = marsmid)
				{
				if(strpills.location = pcounter)
					self.doPay(actor);
				else
					"\"Why that is very nice of you to give me money.  However, wouldn't you rather buy somthing with your 
					marsmid?\"";
				}
			else
				{
				if (dobj = strengthpill and strengthpill.location = Me)
				"\"Sorry, \" Fred says, \" I cannot buy back or give refunds on bought merchandise.\" ";
				else
				"\"Why thank you, but I have no use for <<dobj.adesc>>.\" Fred gives <<dobj.thedesc>> back to you.";
				}
				}
	verDoPay(actor) = {}
	doPay(actor) = 
		{
		if(marsmid.location = Me)
			{
			if(strpills.location = pcounter)
				{
				"\"Ok, one strength capsule for one marsmid.  Here you go.\"";
				strengthpill.moveInto(Me);
				marsmid.moveInto(void);
				if (not strengthpill.bought)
				{
				incscore(5);			// 5 points for buying capsule
				strengthpill.bought := true;
				}
				}
			else
				"\"What do you wish to buy?\"";
			}
			else
				"\"Sorry, you don't have anything to pay me with.  Come 
				back when you get some money.\"";
			}
	verIoPayFor(actor) ={}
	ioPayFor(actor, dobj) = {
		if(dobj = fred)
		dobj.doPayFor(actor, self);
		else
		"How do you propose to do that?";
	}
	verDoPayFor(actor, iobj) ={}
	doPayFor(actor, iobj) = 
		{
	if(marsmid.location = Me)
		{
		switch(iobj)
		{
		case strpills:
			{
			if (strpills.location = pcounter)
			{
				"\"Let's see, one marsmid can get you one strength capsule.\"\n
				Fred takes the marsmid and gives you a strength capsule, which you pocket. ";
			strengthpill.moveInto(Me);
			marsmid.moveInto(void);
				if (not strengthpill.bought)
				{
				incscore(5);			// 5 points for buying capsule
				strengthpill.bought := true;
				}
			break;
			}
			else
			{
			"\"I'm sorry. I don't see that you are talking about.\"";
			break;
			}
			}
		case labpills:
			{
			if(labpills.location = pillsrus)
				{
				"\"As I said, I am sold out of those.  I will be getting 
				more in soon.\"";
				break;
				}
			else
				{
				"\"I'm sorry. I have sold out of those.  Come back in 
					a few weeks time and I should have more.\"";
				labpills.moveInto(pillsrus);
				break;
				}
			}
			case pstore:
				{
				"\"Sorry, my store is not for sale.\"";
				break;
					}
			case fred:
				{
				"Fred looks at you with shocked amusement.  \"Well if you 
				are really interested in THAT sort of thing I suggest you go 
				down to 5th and Main.  There you will find what you are 
				looking for.\"";
				break;
				}
			case pills:
			{
			"\"Sorry, the bottles are not for sale.\"";
			break;
			}
			defalut:
			{
			"I don't see any <<iobj.sdesc>> here.";
			}
			}
		}
		else
			"\"I will be more that happy to sell you something when you 
				have some money.\"";
		}
	
	verDoBuy(actor) ={}
	doBuy(actor) = {
		if(marsmid.location = Me)
		"Fred looks at you with shocked amusement,  \"If you are looking for a prostitute you might 
				try the corner of 5th and Maple across town.\"";
			}
	
	actorDaemon = {
		if(Me.location = pillsrus)
		switch(rand(6))
		{
		case 1:
		{
		"\bFred dusts off some bottles.";
		break;
		}
		case 2:
		{
		"\bFred hums a snappy melody.";
		break;
		}
		case 3:
		{
		"\bFred, thinking you aren't watching, pulls a flask out from under the counter and takes a swig.";
		break;
		}
		case 4:
		{
		"\bFred accidentally knocks a bottle off of a shelf which lands with a crash.  Fred, cursing to himself, 
			cleans up the mess.";
		break;
		}
		case 5:
		{
		"\b\"Nice weather we are having.\"";
		break;
		}
		case 6:
		{
		"\bFor no reason, Fred bursts out into song.";
		break;
		}
	}
}
		
;



pills: fixeditem
	pst = true
	sdesc = "pill bottles"
	ldesc = "The bottles are empty."
	noun = 'pill' 'bottle'
	plural =  'bottles'
	adjective = 'pill'
	location = pillsrus
	verDoTake(actor)={}
	doTake(actor) = {
			"As you grab a bottle a strong hand grabs your arm. \"Sorry, the bottles are not for sale,\" says Fred as 
			he puts the bottle back upon the shelf.";
			return(nil);
			}
	verDoBreak(actor) = {}
	doBreak(actor) = {
			"You hit one of the bottles and it shatters.  Fred, who has been watching you, says \"You will have to 
			replace that bottle  To bad for you that particular bottle was made of a rare glass.  I can only think 
			of one way in which to replace it.\"\n\tFred aims a pen like device at you and pushes a button on it.  
			A warm ray surrounds you and 
			your body stiffens.  To your shock you see yourself slowly turn into glass.\n\t\"There,\" Fred says, \"That 
			wasn't so bad.  I will just get you down to the glass foundry to melt you down into a new bottle to replace that 
			broken one.\"";
			die();
			}
	verDoBuy(actor) = {}
	doBuy(actor) = {
		if(not (marsmid.location = Me))
			{
				"You don't have any money!";
			}
		else
		{
		if(Me.location = pillsrus)
		"\"Sorry, the bottles are not for sale.\"";
		else "I don't see what you are talking about.";
		}
	}
	verIoPayFor(actor) = {}
	ioPayFor(actor, dobj) = {
		if(dobj = fred)
		dobj.doPayFor(actor, self);
		else
		"How do you propose to do that?";
		}
;

pstore: fixeditem
	pst = true
	isListed = nil
	sdesc = "pill store"
	ldesc = "The pill store reminds you of an old, dusty bookshop.  Empty bottles cover every inch of 
		available space."
	noun =  'store' 'shop' 'pillsrus' 'pills'
	adjective = 'pill'
	location = pillsrus
	verDoBuy(actor) = {}
	doBuy(actor) = {
		if(not (marsmid.location = Me))
			{
				"You don't have any money!";
			}
		else
		{
		if(Me.location = pillsrus)
		"\"I'm sorry, my store is not for sale.\"";
		else
		"How do you propose to do that?";
		}
	}
	verIoPayFor(actor) = {}
	ioPayFor(actor, dobj) = {
		if(dobj = fred)
		dobj.doPayFor(actor, self);
		else
		"How do you propose to do that?";
		}
;

labpills: fixeditem
	isListed = nil
	sdesc = "libido encouragement tablets"
	ldesc = "You don't see any <<self.sdesc>> in the store."
	noun = 'tablet' 'pill'
	plural = 'tablets'
	adjective = 'libido' 'encouragement'
	location = nil
	verDoTake(actor) = {}
	doTake(actor) = {"I don't see any <<self.sdesc>> here.";}
	verDoBuy(actor) = {}
	doBuy(actor) = {
		if(not (marsmid.location = Me))
			{
				"You don't have any money!";
			}
		else
		{
		if(Me.location = pillsrus)
		"\"As I said, I am out of labido tablets but I will be getting more in soon.\"";
		else
		"I don't see what you are talking about.";
		}
	}
	verIoPayFor(actor) = {}
	ioPayFor(actor, dobj) = {
		if(dobj = fred)
		dobj.doPayFor(actor, self);
		else
		"How do you propose to do that?";
		}
	;




zoltar: decoration
	isListed = nil
	ldesc = "What are you talking about?"
	noun = 'zoltar'
	location = pillsrus
	doTake(actor) ={
			"Yeah, right.";
			return(nil);
			}
;


strpills: item
	pst = true
	sdesc = "bottle of strength enhancement capsules"
	ldesc = "There is nothing remarable 
			about the bottle of strength enhancement capsules 
			except, perhaps, the capsules themselvs which are 
			colored green and purple and look as if they were ment to be 
			fed to a large animal."
	noun = 'capsule' 'tablet' 'bottle'
	plural = 'capsules' 'tablets'
	adjective = 'strength' 'green and purple' 'enhancement' 'bottle' 
	preposition = 'of'
	location = nil
	verDoBuy(actor) = {}
	doBuy(actor) = {
		if (strpills.location = pcounter)
			{
		if (marsmid.location = Me)
		{
		"\"Let's see, one marsmid can get you one strength capsule.\"\n
		Fred takes the marsmid and gives you a strength capsule, which you pocket. ";
		strengthpill.moveInto(Me);
		marsmid.moveInto(void);
			if (not strengthpill.bought)
			{
			incscore(5);			// 5 points for buying capsule
			strengthpill.bought := true;
			}
			exit;
			}
		else
			{
			"\"I'm sorry.  You have nothing to pay me with.\"";
			exit;
			}
		}
		else
		{"I don't see what you are talking about."; exit;}
		}
	verIoPayFor(actor) = {}
	ioPayFor(actor, dobj) = {
		if(dobj = fred)
		dobj.doPayFor(actor, self);
		else
		"How do you propose to do that?";
		}
	verDoTake(actor) = {}
	doTake(actor) = {
			"\"You have to pay for the pills before you can have them,\" says Fred.";
			exit;
		}
			
;
		

road3: room
	sdesc = "Road"
	ldesc = {
		"The road dead ends here at a sewer grate. A large machine is floating 
		serenely above the grate.  You can take the road back to the west.";
		if (suit.isworn or icesuit.isworn)
			"\n\tPeople are giving you strange looks.  It might be because you are 
			the only one wearing a space suit on a completely hospitable planet.";
		}
	west = {mcity.moveInto(road2); return(road2);}
;

dispmachine: fixeditem
	dmach = true
	sdesc = "dispensing machine"
	ldesc = "The dispensing machine is large, very bulky and floating a foot above the 
		sewer grate.  There are no features on it except for a striped button, 
		a spotted button and a plaid button on the front of the machine."
	noun = 'machine'
	adjective = 'dispensing'
	location = road3
;

inmachine: room			// for objects dumped into machine
;

strpbut: buttonitem, readable
	dmach = true
	sdesc = "striped button"
	ldesc = "On the black and white striped button you can faintly read the label \"Rope\"."
	noun = 'button'
	adjective = 'striped'
	location = dispmachine
	doPush(actor) = {
			if (rope.location = dispvoid)
				{
				"A hole opens up at the base of the machine and 
				<<rope.adesc>> tumbles out onto the ground.  The hole 
				then seals back up.";
				rope.moveInto(road3);
				}
			else
				{
				"A light on the machine briefly flashes the word \"Empty\".";
				}
			}
;

sptbut: buttonitem, readable
	dmach = true
	sdesc = "spotted button"
	ldesc = "On the green and yellow spotted button you can faintly read the label 
		\"Polar Pressure Suit\"."
	noun = 'button'
	adjective = 'spotted'
	location =dispmachine
	donce = nil
	doPush(actor) = {
			if (icesuit.location = dispvoid)
				{
				if (rope.location = inmachine)
					{
					"A hole opens up at the base of the machine and an 
					<<icesuit.sdesc>> tumbles out onto the ground.  The hole then seals back up.";
					icesuit.moveInto(road3);
					}
				else
					{
					if (not self.donce)
						{
						"A slot opens up under the spotted button.  ";
						spdslot.moveInto(dispmachine);
						self.donce := true;
						}
						"A loud orange light above the slot flashes a single time the message\b
						\t\t\"INSERT UMBILICAL FOR PURCHASE OF PROTECTIVE GEAR\".";
					}
				}
			else
				{
				"A light on the machine briefly flashes the word \"Empty\".";
				}
			}
;

machbodydie:function;

machbodydie:function(parm)
	{
	"As you stick your <<parm.sdesc>> into the slot something gabs hold of it and pulls it and you into the 
		machine.  Once inside, you are quickly converted to fertilizer.";
	die();}
;

spdslot: container
	sdesc = "dark slot"
	ldesc = "It looks like a dark slot."
	noun = 'slot'
	adjective = 'dark'
	ioPutIn(actor,dobj) = {
				if (dobj = rope)
					{
					"The rope slides smoothly into the slot and the hole 
				closes up behind it.  A small high pitched chime 
				rings from the machine announcing payment is accepted.";
					rope.moveInto(inmachine);
					spdslot.moveInto(void);
					if (widget.taken)
					incscore(10);		// 10 for putting rope in slot after getting widget
					}
					else
					{
					if(dobj.bpart) machbodydie(dobj);
					else
					{
					"\^<<dobj.thedesc>> falls into the slot with a loud thunk.  
					The machine vibrates angerly and spits out the 
					shredded remains of <<dobj.thedesc>> at you.  A 
				belligerent light flashes \"ITEM UNACCEPTABLE.\" ";
					if (dobj.istreasure) incscore(-20);									// -20 for putting treasure in slot
					dobj.moveInto(dvoid);
					}
					}
					}
	location = nil
;

plaidbut: buttonitem, readable
	dmach = true
	sdesc = "plaid button"
	ldesc = "On the tartan plaid button you can faintly read the label \"Ambidextrous Laser Trinketer\"."
	noun = 'button'
	adjective = 'plaid' 'tartan'
	location = dispmachine
	doPush(actor) = {
			if (wreng.location = dispvoid)
				{
				if (ambltr.location = dispvoid)
					{
					"A hole opens up at the base of the machine and an 
				<<ambltr.sdesc>> tumbles out onto the ground.  The hole then seals back up.";
					ambltr.moveInto(road3);
					}
				else
					{
					"A light on the machine briefly flashes the word \"Empty\".";
					}
				}
			else
				{
				if(gplast.location = nil)
					{
					"With a hum a large slot opens in the face of the 
				machine from which a green piece of plastic falls out of.";
					gplast.moveInto(road3);
					disphole.moveInto( dispmachine);
					}
				else
					{
					"Nothing happens.";
					}
				}
				}
;



disphole: container, fixeditem
	sdesc = "large slot"
	ldesc = "It looks like every other large slot you have seen."
	noun = 'slot'
	adjective = 'large'
	location = nil
	ioPutIn(actor, dobj) ={
				if (dobj = wreng)
					{
					"The wankle rodery engine falls into the slot with a 
					loud thunk.  A hideous grinding noise builds from 
					within machine and the slot closes.  A green light 
					flashes \"Fixed\" as the noise subsides.";
					wreng.moveInto(dispvoid);
					incscore(5);		//5 points for fixing machine
					disphole.moveInto(void);
					}
				else
					{
					if(dobj.bpart) machbodydie(dobj);
					else
					{
					"\^<<dobj.thedesc>> falls into the slot with a loud 
				thunk. A hideous grinding noise emanates from the 
				inside of the machine.  A blue light flashes \"Object alien to function.  
			Object disposed of.\" ";
				if(dobj.istreasure) incscore(-20);
						//-20 for loosing treasure
					dobj.moveInto(dvoid);
					}
					}
				}
;

grate: fixeditem, qcontainer
	hno = true
	sdesc = "sewer grate"
	ldesc = {
		if (marsmid.location = grate)
			{
			"You marvel that even in the twenty sixth century, a sewer grate 
			looks like a sewer grate.  Looking inside, you see a small ledge just 
			under the grate.  On the ledge is a marsmid coin.  Reaching into the 
			grate, you grab the coin.";
			incscore(5);			// 5 points for getting marsmid
			marsmid.moveInto(Me);
			}
		else
			"It looks like a sewer grate.";
		}
	noun = 'grate'
	adjective = 'sewer'
	location = road3
	verIoPutIn(actor) = {}
	ioPutIn(actor, dobj) = {
			"\^<<dobj.thedesc>> falls into the sewer and gets washed away.";
			dobj.moveInto(dvoid);
			}
	verDoSearch(actor) = {}
	doSearch(actor) = {
		if (marsmid.location = grate)
			{
			"You marvel that even in the twenty sixth century, a sewer grate 
			looks like a sewer grate.  Looking inside, you see a small ledge just 
			under the grate.  On the ledge is a marsmid coin.  Reaching into the 
			grate, you grab the coin.";
			incscore(5);			// 5 points for getting marsmid
			marsmid.moveInto(Me);
			}
		else
			"You find nothing of interest in the sewer grate.";
		}
;

sewer: decoration, qcontainer
	sdesc = "sewer"
	ldesc = "It is a sewer.  You know. Cold, dark, wet, smelly. A sewer."
	noun = 'sewer'
	location = road3
	ioPutIn(actor, dobj) = {grate.ioPutIn;}
;
