/*
 * 		sample.t				version 1.0
 *		by Kevin Forchione		( Lysseus@msn.com )
 *		Copyright (c) 1999. 	All Rights Reserved.
 *
 *  	This file requires HTML TADS 2.2.6 or later.
 *
 *  	You may modify and use this file in any way you want, provided that
 *		if you redistribute modified copies of this file in source form, the
 *   	copies must include the original copyright notice (including this
 *   	paragraph), and must be clearly marked as modified from the original
 *   	version.
 *
 *		This is the demonstration game for OBSERVER.T.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		99-03-21:	Creation.
 */
 
// Predefine the functions used in this file
classcnt: function;
getclass: function;

// Since this is an HTML TADS game, let's use the HTML status line
#define USE_HTML_STATUS

#include    <adv.t>         // Adventure Library
#include	<std.t>			// Standard definitions required by the system & library
#include	<observer.t>	// observer class definition

/*
 *	ventItem: openable, fixeditem
 *
 *	This class merely serves to indicate that the locations connected by
 *	the vent are communicable. The ventItem has the added bonus of being
 *	closable which means no communication should be possible, and of allowing
 *	objects to be placed into it and deposited into the adjoining room.
 */
class ventItem: openable, fixeditem
    isvent = true							// item is vent
    verDoOpen(actor) =
    {
        if (self.isopen)
            "\^<<self.itisdesc>> already open. ";
    }
    setIsopen(setting) =
    {
        /* update my status */
        self.isopen := setting;

        /* 
         *   if there's another side to this door, and its status is not
         *   already set to the new setting, update it as well (we don't
         *   update it if it's already been updated, since otherwise we'd
         *   recurse forever calling back and forth between the two sides) 
         */
        if (self.otherside != nil && self.otherside.isopen != setting)
            self.otherside.setIsopen(setting);
    }
    doOpen(actor) =
    {
        "Opened. ";
        self.setIsopen(true);
    }
    verDoClose(actor) =
    {
        if (not self.isopen)
            "\^<<self.itisdesc>> already closed. ";
    }
    doClose(actor) =
    {
        "Closed. ";
        self.setIsopen(nil);
    }
   	verIoPutIn( actor ) = 
    {
        if ( not self.isopen )
 		{
            "%You%'ll have to open << self.thedesc >> first. ";
        }
    }
    ioPutIn( actor, dobj ) =
    {
    	"<<actor.sdesc>> puts <<dobj.thedesc>> in <<self.thedesc>>. ";
        dobj.moveInto( self.otherside );
    }
;

/*
 *	We only want the observer.isactive and the validActor to return true when
 *	both the player's location and the actor's location have a vent connecting
 *	them. This check takes into consideration 
 *
 *	a. Whether the room has a ventItem.
 *	b. Whether the ventItem is open or closed.
 *	c. Whether the vents in both locations actually join to each other. 
 *	d. Additionally, the player can issue commands to actors while lying in a 
 *	   beditem (nestedroom) regardless of whether the room has a ventItem, but 
 *	   will have all the other usual restrictions of the nestedroom.
 *
 *	This routine does not handle cases of rooms with multiple vents.
 */
modify observer
	checkactive =
	{
		local p, q, v1, v2, o1, o2;
		
		p := parent( parserGetMe() );

		if ( classcnt( p.contents, ventItem ) )
		{
			v1 := getclass( p.contents, ventItem );
			
		}
		if ( v1 )
		{
			o1 := v1[ 1 ];
		}
		
		q := parent( self.myactor );
		if ( classcnt( q.contents, ventItem ) )
		{
			v2 := getclass( q.contents, ventItem );
		}
		if ( v2 )
		{
			o2 := v2[ 1 ];
		}
		
		if ( o1 and o2 and o1.isopen and o1.otherside = o2 )
			return true;
		else if ( p = q )
			return true;
		else
			return nil;
	}
;

startroom: room
	sdesc = "Cell 51"
	ldesc = "The cell has a bed in one corner of the room. It has only a narrow 
		vent connecting it and an adjoining cell."
	north = cell50
	south = cell52
;

vent51: ventItem
	location = startroom
	sdesc = "vent"
	noun = 'vent'
	otherside = vent52
;

bed: beditem
	location = startroom
	sdesc = "bed"
	noun = 'bed'
;

cell50: room
	sdesc = "Cell 50"
	ldesc = "This cell has a chair in the middle of the room and only one other
		distiguishing characteristic, it lacks a vent to any adjoining cells."
	south = startroom
;

chair: chairitem
	location = cell50
	sdesc = "chair"
	noun = 'chair'
;

bob: Actor
	location = cell50
	sdesc = "Bob"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	noun = 'bob'
	isHim = true
	myobserver = observerBob
	actorDesc = "Bob is here, looking for something to do."
	actorAction( verb, dobj, prep, iobj ) = {}
;

observerBob: observer
	myactor = bob
;

book: readable
	location = cell50
	sdesc = "book"
	noun = 'book'
	ldesc = "It's a book on bio-mechanics."
;

cell52: room
	sdesc = "Cell 52"
	ldesc = "The cell has a couch in one corner and a narrow vent 
		connecting it and an adjoining cell."
	north = startroom
;

vent52: ventItem
	location = cell52
	sdesc = "vent"
	noun = 'vent'
	otherside = vent51
;

couch: beditem
	location = cell52
	sdesc = "couch"
	noun = 'couch'
;

sam: Actor
	location = cell52
	sdesc = "Sam"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	noun = 'sam'
	isHim = true
	myobserver = observerSam
	actorDesc = "Sam is here, looking for something to do."
	actorAction( verb, dobj, prep, iobj ) = {}
;

observerSam: observer
	myactor = sam
;

harry: Actor
	location = cell52
	sdesc = "Harry"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }
	noun = 'Harry'
	isHim = true
	myobserver = observerHarry
	actorDesc = "Harry is here, looking for something to do."
	actorAction( verb, dobj, prep, iobj ) = {}
;


observerHarry: observer
	myactor = harry
;

note: readable
	location = cell52
	sdesc = "note"
	noun = 'note'
	ldesc = "The note says: <q>There will be a prison break tonight after 
		lights out.</q>"
	verIoPutIn( actor ) = {}
	verDoPutIn( actor, iobj ) = {}
;

flower: fooditem
	location = cell52
	sdesc = "flower"
	noun = 'flower'
;

/*
 *	Gives us HTML!
 */
replace commonInit: function
{
	"\H+";
}
;

/* 
 *	classcnt: function( lst, cls )
 *
 *	This function is similar to itemcnt, except that it returns a count of all
 *	objects of a certain class within the list passed. It is meant to be of use
 *	in the observer.checkactive() method.
 */
classcnt: function( lst, cls )
{
	local o, cnt := 0;
	
	o := car( lst );
	while( o )
	{
		if ( isclass( o, cls ) )
			cnt++;
		lst := cdr( lst );
		o := car( lst );
	}
	return cnt;
}
;

/*
 *	getclass: function( lst, cls )
 *
 *	This function will return a list of all objects of a certain class. If no
 *	objects were found for the class then it returns an empty list. This can be
 *	helpful in observer.checkactive() where an object of a certain class can be
 *	used to indicate whether communication with the actor and the observer can
 *	occur.
 */
getclass: function( lst, cls )
{
	local o, clst := [];
	
	o := car( lst );
	while( o )
	{
		if ( isclass( o, cls ) )
			clst += [ o ];
		lst := cdr( lst );
		o := car( lst );
	}
	return clst;
}
;
