/* The Itty Bitty Combat Module:
 *	This module does only a few things, but these are generally very
 * useful to the player.  First, it implements the two verbs 'wield' and
 * 'unwield'.  Then, it lets the player use the 'wield' verb to set a
 * default weapon for use when attacking things.  Thus, the game would behave
 * like this:
 *
 * >hit squirrel
 * With what?
 *
 * >wield sword
 * Wielded.
 *
 * >hit squirrel
 * (with sword)
 * You chop the squirrel to tiny bits, thus saving your breakfast cereal.
 *
 * Note that the object class 'weapon' should be used for any object you
 * want the player to be able to wield and attack with.
 */

modify Me
  ready = nil
;

replace attackVerb: deepverb
    verb = 'attack' 'kill' 'hit'
    sdesc = "attack"
    prepDefault = withPrep
    ioAction( withPrep ) = 'AttackWith'
    ioDefault( actor, prep ) =
       { local ret;
         ret := [];
         if (actor = Me) {
           if (Me.ready = nil) {
//           ret += Hands;  // Can be adapted to let the player punch things.
                               }
             else {
             ret := ret + Me.ready;
                  }
                         }
         else if (actor.ready <> nil ) { 
         ret := ret + actor.ready;
                                       }
         return( ret );   }
;

unwieldVerb: deepverb
    sdesc = "unwield"
    verb = 'unwield' 'unready'
    doAction = 'Unwield'
    doDefault( actor, prep, io ) =
    {
        local ret;
        ret := [];
        ret := ret + Me.ready;
        return( ret );
    }
;

wieldVerb: deepverb
    sdesc = "wield"
    verb = 'wield' 'ready'
    doAction = 'Wield'
    doDefault( actor, prep, io ) =
    {
        local ret, rem;
        ret := [];
        ret := Me.contents - Me.ready;
        return( ret );
    }
;

class weapon: item
    verIoAttackWith( actor ) = {}
    ioAttackWith( actor, dobj ) = 
    { 
      dobj.doAttackWith( actor, self ); 
    }
    verDoWield( actor ) =
    {
        if ( Me.ready = self ) "You're already wielding it. ";
        else if ( self.location <> actor ) "You should be holding it first. ";
    }
    doWield( actor ) =
    {
        if ( Me.ready <> nil ) { "(unwielding <<Me.ready.thedesc>> first)\n"; }
        Me.ready := self;
        "Wielded. ";
    }
    verDoUnwield( actor ) =
    {
      if ( Me.ready <> self )
        "Confucius say, \"What would be unwielded, must first be wielded.\" ";
    }
    doUnwield( actor ) =
    {
        Me.ready := nil;
        "Unwielded. ";
    }
    checkDrop =
    {
        if ( Me.ready = self )
        {
            "You should unwield it first. \n";
            exit;
        }
    }
;

modify class thing
    verDoUnwield( actor ) =
    {
        "Confucius say, \"What would be unwielded, must first be wielded.\" ";
    }
    verDoWield( actor ) =
    {
        "What kind of a weapon do you call that? ";
    }
;