/* The Score Notifier Module:
 *	This module does some very small, very simple things.  First, it adds
 * a thing to your game that lets your player know when his score has changed.
 * the other thing this module does is add a verb 'notify' that can turn this
 * feature off and on again.  Please note that the Score Notifier Module is
 * pre-set to work properly with the scoring methods outlined in the SCORE.T
 * file, no matter which method you are using.
 */

modify global
  notifyon = true
  warned = nil
;

notifVerb: sysverb
  verb = 'notify'
  sdesc = "notify"
  action( actor ) =
  {
     if(global.notifyon) {
       "Notify is now OFF. ";
       global.notifyon := nil;
                       }
     else {
       "Notify is now ON. ";
       global.notifyon := true;
          }
  }
;

notify2: function(amount)
{
    if (global.notifyon <> nil)
    {
      if (amount > 0)
        switch(amount)
        {
      case 1:
        "\b\([Your score just went up by 1 point.";
        break;
      default:
        "\b\([Your score just went up by <<amount>> points.";
        }
      if (amount < 0)
        switch(amount) 
        {
      case -1:
        "\b\([Your score just went down by 1 point.";
        break;
      default:
        "\b\([Your score just went down by <<amount*(-1)>> points.";
        }
      if (global.warned) 
      {
      "]\)\b";
      } else
      {
      " You can turn these notifications at any time by typing 'notify'.]\)\b";
      global.warned := true;
      }
    }
}

#ifdef PUZZLE_SCORE

replace notify2: function(amount)
{
        "\b\([You just solved a puzzle.";
      if (global.warned) 
      {
      "]\)\b";
      } else
      {
      " You can turn these notifications at any time by typing 'notify'.]\)\b";
      global.warned := true;
      }
}

#endif
