/* Please read read.me BEFORE using these files.  THEN come back and read
 * this file.  While it is very easy to use wadv.t, it's even easier if you
 * read the instructions.
 */

/* NOTE: When you uncomment a #define lime, be SURE that the # symbol is at
 * the very beginning of that line.  Otherwise you will experience problems.
 */

/*=-=-=-=-=-=  Begin Required Modules  =-=-=-=-=-=*/

/* Select a scoring method below and uncomment out the appropriate line.  Some
 * of these do not actually display a score, but they all can keep track of
 * one.  I myself have been using the Puzzles Remaining: method.
 *
 *	The following lines show how the right half of the status line will
 * appear on turn 10, with 5 points (1 puzzle solved), 100 total points
 * (20 total puzzles), and a starting time of 9:00am on Monday.
 *
 *	You are 5% done.			PERCENT_SCORE
 *	Puzzles Remaining: 19			PUZZLE_SCORE
 *	Score: 5				SCORE_SCORE
 *	Score: 5 / Turn: 10			SCORE_TURN_SCORE
 *	Monday 9:10 a.m.			TIME_SCORE
 *	Turn: 10				TURN_SCORE
 *
 * These are each easily modifiable, so I think that this is a good enough
 * selection for you to play with.  The SCORE_TURN_SCORE method is the
 * default selected below for you.  To choose another, just comment the
 * default out, and uncomment another one.  Whichever you choose, please
 * be sure to read score.t before using any of them.  There are some important
 * notes in that file, as well as some reasonably interesting code besides.
 */
//	SCRMT

// #define PERCENT_SCORE
// #define PUZZLE_SCORE
// #define SCORE_SCORE
#define SCORE_TURN_SCORE
// #define TIME_SCORE
// #define TURN_SCORE

/*=-=-=-=-=-= End of Required Modules. =-=-=-=-=-=*/

/* The Auto-Save Reminder Module:
 *	To use this module, uncomment the #define line below.  What this
 * module does is to ask the player if he wants to save every X turns, where
 * X is the number in the #define line below.  I suggest setting it no lower
 * than 50.  The default is 75.  In addition, this module adds a verb,
 * remind, that can let the player turn the reminders off and on.
 */
//	ASAVR

// #define AUTO_SAVE_REMINDER 5

/* The Complex Inventory Module:
 *	The complex inventory module changes the format of the inventory
 * display.  Instead of:
 * 	You have a bracelet (worn), a dagger (wielded), an elephant, and a
 * lantern (lit).
 *
 *      You see:
 *  You are holding:
 *  An elephant
 *  A lantern (lit)
 *
 *  You are wielding:
 *  A dagger
 *
 *  You are wearing:
 *  A bracelet
 *
 * To use this module, uncomment the #define line that follows.
 */
//	CXINV

// #define COMPLEX_INVENTORY

/* The Easy Death Module:
 *	This module is standard in my games.  All it does is take the old
 * Would you like to restore, quit, restart? prompt and makes it into this:
 * Would you like to (r)estore, (q)uit, re(s)tart?  This allows the player
 * to enter 'q' instead of the full 'quit' etc.
 * 	Thus, the player can continue on after dying with very little break
 * in the game's flow, except to perhaps read a humorous death message.
 * Please note that both with and without this module, wadv.t provides for
 * undo'ing after death.  If you have a dislike for this feature, it is a
 * simple matter to just remove the offending code.  If you want my advice,
 * however, I'd suggest not inconveniencing the player.  While this module
 * isn't quite the LucasArts method of no death at all, it comes very close.
 */
//	EDETH

// #define EASY_DEATH

/* The Eating Module:
 *	This module requires the player to periodically eat or he will starve
 * to death.  There has been a lot of discussion lately as to whether this
 * sort of puzzle has outlived its usefulness, and the general consensus is
 * yes, unless there are some special circumstances.  But anyways, to turn
 * it on, uncomment out the line below.  You may want to read EAT.T in order
 * to understand just how it works.  Also look at fooditem (FOOTM) in
 * OBJECTS.T
 */
//	MSTET

// #define MUST_EAT

/* The Itty Bitty Combat Module:
 *	This module does only a few things, but these are generally very
 * useful to the player.  First, it implements the two verbs 'wield' and
 * 'unwield'.  Then, it lets the player use the 'wield' verb to set a
 * default weapon for use when attacking things.  Thus, the game would behave
 * like this:
 *
 * >hit squirrel
 * With what?
 *
 * >wield sword
 * Wielded.
 *
 * >hit squirrel
 * (with sword)
 * You chop the squirrel to tiny bits, thus saving your breakfast cereal.
 */
// ITBIT

// #define BITTY_COMBAT

/* The Score Notifier Module:
 *	This module does some very small, very simple things.  First, it adds
 * a thing to your game that lets your player know when his score has changed.
 * the other thing this module does is add a verb 'notify' that can turn this
 * feature off and on again.  Please note that the Score Notifier Module is
 * pre-set to work properly with the scoring methods outlined at the beginning
 * of this file, no matter which method you are using.
 */
//	SCNOT

// #define SCORE_NOTIFIER

/* The Sleeping Module:
 *	This module requires the player to periodically sleep or he will
 * fall unconscious.  There has been a lot of discussion lately as to whether
 * this puzzle, like eating has outlived its usefulness, and the general
 * consensus is yes, unless there are some special circumstances.  But
 * anyways, to turn it on, uncomment out the line below.  You may want to
 * read SLEEP.T in order to understand just how it works.
 */
//	MSTSP

// #define MUST_SLEEP

/*============================================================================
	End of modules.  What follows is only of interest to those fiddling
  with the actual coding of wadv.t, and who are curious to see how evocable
  features are made.
============================================================================*/
#include <header.t>
#include <objects.t>
#include <verbs.t>
#include <function.t>
#include <score.t>

#ifdef AUTO_SAVE_REMINDER
#include <asave.t>
#endif

#ifdef COMPLEX_INVENTORY
#include <cinven.t>
#endif

#ifdef EASY_DEATH
#include <edeath.t>
#endif

#ifdef BITTY_COMBAT
#include <combat.t>
#endif

#ifdef SCORE_NOTIFIER
#include <notify.t>
#endif

#ifdef MUST_EAT
#include <eat.t>
#endif

#ifdef MUST_SLEEP
#include <sleep.t>
#endif
